/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.Encoding;
import org.gjt.sp.jedit.io.EncodingDetector;

public class EncodingWithBOM
implements Encoding {
    private static final int BOM16 = 65279;
    private static final byte[] UTF8BOM = new byte[]{-17, -69, -65};
    private static final Map<String, byte[]> bomMap = new HashMap<String, byte[]>();
    private final CharsetEncoding plain;
    private final byte[] bom;

    public EncodingWithBOM(String string) {
        byte[] byArray = bomMap.get(string);
        if (byArray == null) {
            throw new UnsupportedCharsetException(string + " with BOM");
        }
        this.plain = new CharsetEncoding(string);
        this.bom = byArray;
    }

    public Reader getTextReader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bom.length];
        int n = inputStream.read(byArray);
        if (n < this.bom.length || !Arrays.equals(byArray, this.bom)) {
            throw new MalformedInputException(0);
        }
        return this.plain.getTextReader(inputStream);
    }

    public Writer getTextWriter(OutputStream outputStream) throws IOException {
        outputStream.write(this.bom);
        return this.plain.getTextWriter(outputStream);
    }

    public Reader getPermissiveTextReader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bom.length];
        int n = inputStream.read(byArray);
        if (n < this.bom.length || !Arrays.equals(byArray, this.bom)) {
            inputStream = new SequenceInputStream(new ByteArrayInputStream(byArray, 0, n), inputStream);
        }
        return this.plain.getPermissiveTextReader(inputStream);
    }

    static {
        bomMap.put("UTF-8", UTF8BOM);
        byte by = -1;
        byte by2 = -2;
        bomMap.put("UTF-16LE", new byte[]{by, by2});
        bomMap.put("UTF-16BE", new byte[]{by2, by});
        bomMap.put("UTF-32LE", new byte[]{by, by2, 0, 0});
        bomMap.put("UTF-32BE", new byte[]{0, 0, by2, by});
    }

    public static class Detector
    implements EncodingDetector {
        public String detectEncoding(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[4];
            int n = inputStream.read(byArray);
            byte by = -1;
            byte by2 = -2;
            if (n >= 4) {
                if (byArray[0] == by && byArray[1] == by2 && byArray[2] == 0 && byArray[3] == 0) {
                    return "X-UTF-32LE-BOM";
                }
                if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == by2 && byArray[3] == by) {
                    return "X-UTF-32BE-BOM";
                }
            }
            if (n >= 2) {
                if (byArray[0] == by && byArray[1] == by2) {
                    return "x-UTF-16LE-BOM";
                }
                if (byArray[0] == by2 && byArray[1] == by) {
                    return "UTF-16";
                }
            }
            if (n >= UTF8BOM.length) {
                int n2;
                for (n2 = 0; n2 < UTF8BOM.length && byArray[n2] == UTF8BOM[n2]; ++n2) {
                }
                if (n2 == UTF8BOM.length) {
                    return "UTF-8Y";
                }
            }
            return null;
        }
    }
}

