/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDetection {
    public static BufferedInputStream getMarkedStream(InputStream inputStream) {
        int n = BufferIORequest.getByteIOBufferSize();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        assert (bufferedInputStream.markSupported());
        bufferedInputStream.mark(n);
        return bufferedInputStream;
    }

    public static boolean isGzipped(InputStream inputStream) throws IOException {
        int n = 31;
        int n2 = 139;
        return inputStream.read() == n && inputStream.read() == n2;
    }

    public static List<EncodingDetector> getEncodingDetectors() {
        ArrayList<EncodingDetector> arrayList = new ArrayList<EncodingDetector>();
        String string = "encodingDetectors";
        String string2 = jEdit.getProperty(string, "BOM XML-PI");
        if (string2 != null && string2.length() > 0) {
            for (String string3 : string2.split("\\s+")) {
                EncodingDetector encodingDetector = AutoDetection.getEncodingDetectorService(string3);
                if (encodingDetector != null) {
                    arrayList.add(encodingDetector);
                    continue;
                }
                Log.log(9, AutoDetection.class, "getEncodingDetectors(): No EncodingDetector for the name \"" + string3 + "\"");
            }
        }
        return arrayList;
    }

    public static String getDetectedEncoding(BufferedInputStream bufferedInputStream) throws IOException {
        List<EncodingDetector> list = AutoDetection.getEncodingDetectors();
        for (EncodingDetector encodingDetector : list) {
            bufferedInputStream.reset();
            String string = encodingDetector.detectEncoding(new BufferedInputStream(bufferedInputStream));
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private static EncodingDetector getEncodingDetectorService(String string) {
        String string2 = "org.gjt.sp.jedit.io.EncodingDetector";
        Object object = ServiceManager.getService(string2, string);
        if (object != null && object instanceof EncodingDetector) {
            return (EncodingDetector)object;
        }
        return null;
    }

    public static class Result {
        private final BufferedInputStream markedStream;
        private final boolean gzipped;
        private final String encoding;

        public Result(InputStream inputStream) throws IOException {
            BufferedInputStream bufferedInputStream = AutoDetection.getMarkedStream(inputStream);
            this.gzipped = AutoDetection.isGzipped(bufferedInputStream);
            if (this.gzipped) {
                bufferedInputStream.reset();
                bufferedInputStream = AutoDetection.getMarkedStream(new GZIPInputStream(bufferedInputStream));
            }
            bufferedInputStream.reset();
            this.encoding = AutoDetection.getDetectedEncoding(bufferedInputStream);
            this.markedStream = bufferedInputStream;
        }

        public BufferedInputStream getRewindedStream() throws IOException {
            this.markedStream.reset();
            return this.markedStream;
        }

        public boolean streamIsGzipped() {
            return this.gzipped;
        }

        public String getDetectedEncoding() {
            return this.encoding;
        }
    }
}

