/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpIndentRule
implements IndentRule {
    private IndentAction prevPrevAction;
    private IndentAction prevAction;
    private IndentAction thisAction;
    private Pattern regexp;
    private boolean collapse;

    public RegexpIndentRule(String string, IndentAction indentAction, IndentAction indentAction2, IndentAction indentAction3, boolean bl) throws PatternSyntaxException {
        this.prevPrevAction = indentAction;
        this.prevAction = indentAction2;
        this.thisAction = indentAction3;
        this.regexp = Pattern.compile(string, 2);
        this.collapse = bl;
    }

    @Override
    public void apply(JEditBuffer jEditBuffer, int n, int n2, int n3, List<IndentAction> list) {
        if (this.thisAction != null && this.lineMatches(jEditBuffer, n)) {
            list.add(this.thisAction);
        }
        if (this.prevAction != null && n2 != -1 && this.lineMatches(jEditBuffer, n2)) {
            list.add(this.prevAction);
            if (this.collapse) {
                list.add(IndentAction.PrevCollapse);
            }
        }
        if (this.prevPrevAction != null && n3 != -1 && this.lineMatches(jEditBuffer, n3)) {
            list.add(this.prevPrevAction);
            if (this.collapse) {
                list.add(IndentAction.PrevPrevCollapse);
            }
        }
    }

    @Deprecated
    public boolean isMatch(String string) {
        Matcher matcher = this.regexp.matcher(string);
        return matcher.matches();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.regexp + ']';
    }

    private boolean lineMatches(JEditBuffer jEditBuffer, int n) {
        TokenFilter tokenFilter = new TokenFilter(jEditBuffer.getLineLength(n));
        jEditBuffer.markTokens(n, tokenFilter);
        return this.regexp.matcher(tokenFilter.result).matches();
    }

    private static class TokenFilter
    implements TokenHandler {
        public StringBuilder result;

        public TokenFilter(int n) {
            this.result = new StringBuilder(n);
        }

        public void handleToken(Segment segment, byte by, int n, int n2, TokenMarker.LineContext lineContext) {
            if (n2 <= 0) {
                return;
            }
            switch (by) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.result.append(' ');
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.result.append('0');
                    break;
                }
                default: {
                    this.result.append(segment.array, segment.offset + n, n2);
                }
            }
        }

        public void setLineContext(TokenMarker.LineContext lineContext) {
        }
    }
}

