/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.StandardUtilities;

public interface IndentAction {
    public static final Collapse PrevCollapse = new Collapse();
    public static final Collapse PrevPrevCollapse = new Collapse();

    public int calculateIndent(JEditBuffer var1, int var2, int var3, int var4);

    public boolean keepChecking();

    public static class NoIncrease
    implements IndentAction {
        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            int n4 = StandardUtilities.getLeadingWhiteSpaceWidth(jEditBuffer.getLineSegment(n), jEditBuffer.getTabSize());
            return n4 < n3 ? n4 : n3;
        }

        public boolean keepChecking() {
            return true;
        }
    }

    public static class AlignParameter
    implements IndentAction {
        private int openParensColumn;

        public AlignParameter(int n) {
            this.openParensColumn = n;
        }

        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            return this.openParensColumn + 1;
        }

        public boolean keepChecking() {
            return false;
        }
    }

    public static class AlignOffset
    implements IndentAction {
        private int offset;

        public AlignOffset(int n) {
            this.offset = n;
        }

        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            return this.offset;
        }

        public boolean keepChecking() {
            return false;
        }
    }

    public static class Decrease
    implements IndentAction {
        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            return n3 - jEditBuffer.getIndentSize();
        }

        public boolean keepChecking() {
            return true;
        }
    }

    public static class Increase
    implements IndentAction {
        private int amount;

        public Increase() {
            this.amount = 1;
        }

        public Increase(int n) {
            this.amount = n;
        }

        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            return n3 + jEditBuffer.getIndentSize() * this.amount;
        }

        public boolean keepChecking() {
            return true;
        }

        public boolean equals(Object object) {
            if (object instanceof Increase) {
                return ((Increase)object).amount == this.amount;
            }
            return false;
        }
    }

    public static class Reset
    implements IndentAction {
        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            return n2;
        }

        public boolean keepChecking() {
            return true;
        }
    }

    public static class Collapse
    implements IndentAction {
        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            return n3;
        }

        public boolean keepChecking() {
            return true;
        }

        private Collapse() {
        }
    }
}

