/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.List;
import java.util.Stack;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepIndentRule
implements IndentRule {
    private final char openChar;
    private final char closeChar;

    public DeepIndentRule(char c, char c2) {
        this.openChar = c;
        this.closeChar = c2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(JEditBuffer jEditBuffer, int n, int n2, int n3, List<IndentAction> list) {
        int n4;
        if (n2 == -1) {
            return;
        }
        int n5 = n4 = n2;
        CharSequence charSequence = jEditBuffer.getLineSegment(n4);
        int n6 = -1;
        while (true) {
            int n7;
            if (n4 != n5) {
                charSequence = jEditBuffer.getLineSegment(n4);
                n5 = n4;
            }
            Parens parens = new Parens(jEditBuffer, n4, n6);
            if (parens.openOffset == -1 && parens.closeOffset == -1) {
                if (n3 == -1) return;
                n6 = -1;
                n4 = n3;
                n3 = -1;
                continue;
            }
            if (parens.closeOffset == -1) {
                n7 = parens.openOffset + this.getIndent(charSequence, jEditBuffer.getTabSize()) - charSequence.length();
                list.clear();
                list.add(new IndentAction.AlignParameter(n7));
                return;
            }
            n7 = TextUtilities.findMatchingBracket(jEditBuffer, n4, parens.closeOffset);
            if (n7 < 0) return;
            n3 = -1;
            n4 = jEditBuffer.getLineOfOffset(n7);
            n6 = n7 - jEditBuffer.getLineStartOffset(n4) - 1;
            if (n6 < 0) return;
        }
    }

    private int getIndent(CharSequence charSequence, int n) {
        int n2 = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) == '\t') {
                n2 += n;
                continue;
            }
            if (!Character.isWhitespace(charSequence.charAt(i))) {
                n2 += charSequence.length() - i;
                break;
            }
            ++n2;
        }
        return n2;
    }

    private class Parens
    implements TokenHandler {
        int openOffset;
        int closeOffset;
        private int searchPos;
        private Stack<Integer> open;
        private Stack<Integer> close;

        Parens(JEditBuffer jEditBuffer, int n, int n2) {
            this.searchPos = n2;
            this.open = new Stack();
            this.close = new Stack();
            jEditBuffer.markTokens(n, this);
            this.openOffset = this.open.isEmpty() ? -1 : this.open.pop();
            this.closeOffset = this.close.isEmpty() ? -1 : this.close.pop();
        }

        public void handleToken(Segment segment, byte by, int n, int n2, TokenMarker.LineContext lineContext) {
            if (n2 <= 0 || this.searchPos != -1 && this.searchPos < n) {
                return;
            }
            if (this.searchPos != -1 && n + n2 > this.searchPos) {
                n2 = this.searchPos - n + 1;
            }
            switch (by) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    for (int i = n; i < n + n2; ++i) {
                        if (segment.array[segment.offset + i] == DeepIndentRule.this.openChar) {
                            if (this.open.isEmpty() && !this.close.isEmpty()) {
                                this.close.pop();
                                continue;
                            }
                            this.open.push(i);
                            continue;
                        }
                        if (segment.array[segment.offset + i] != DeepIndentRule.this.closeChar) continue;
                        if (this.close.isEmpty() && !this.open.isEmpty()) {
                            this.open.pop();
                            continue;
                        }
                        this.close.push(i);
                    }
                }
            }
        }

        public void setLineContext(TokenMarker.LineContext lineContext) {
        }

        public String toString() {
            return "Parens(" + this.openOffset + ',' + this.closeOffset + ')';
        }
    }
}

