/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

public abstract class BracketIndentRule
implements IndentRule {
    protected char openBracket;
    protected char closeBracket;

    public BracketIndentRule(char c, char c2) {
        this.openBracket = c;
        this.closeBracket = c2;
    }

    @Deprecated
    public Brackets getBrackets(String string) {
        Brackets brackets = new Brackets();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.openBracket) {
                if (string.length() - i >= 3 && string.substring(i, i + 3).equals("{{{")) {
                    i += 2;
                    continue;
                }
                ++brackets.openCount;
                continue;
            }
            if (c != this.closeBracket) continue;
            if (brackets.openCount != 0) {
                --brackets.openCount;
                continue;
            }
            ++brackets.closeCount;
        }
        return brackets;
    }

    public Brackets getBrackets(JEditBuffer jEditBuffer, int n) {
        return this.getBrackets(jEditBuffer, n, 0, jEditBuffer.getLineLength(n));
    }

    public Brackets getBrackets(JEditBuffer jEditBuffer, int n, int n2, int n3) {
        LineScanner lineScanner = new LineScanner(n2, n3);
        jEditBuffer.markTokens(n, lineScanner);
        return lineScanner.result;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.openBracket + "," + this.closeBracket + "]";
    }

    private class LineScanner
    implements TokenHandler {
        public final Brackets result = new Brackets();
        private int scannedIndex = 0;
        private final int beginIndex;
        private final int endIndex;

        public LineScanner(int n, int n2) {
            this.beginIndex = n;
            this.endIndex = n2;
        }

        boolean rejectsToken(byte by) {
            switch (by) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    return true;
                }
            }
            return false;
        }

        private void scan(Segment segment, int n, int n2) {
            int n3;
            int n4 = this.scannedIndex;
            if (n4 >= this.endIndex) {
                return;
            }
            if (n4 < this.beginIndex) {
                n3 = this.beginIndex - n4;
                if (n3 >= n2) {
                    return;
                }
                n += n3;
                n2 -= n3;
                n4 = this.beginIndex;
            }
            if (n4 + n2 > this.endIndex) {
                n2 = this.endIndex - n4;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                char c = segment.array[segment.offset + n + n3];
                if (c == BracketIndentRule.this.openBracket) {
                    ++this.result.openCount;
                    continue;
                }
                if (c != BracketIndentRule.this.closeBracket) continue;
                if (this.result.openCount != 0) {
                    --this.result.openCount;
                    continue;
                }
                ++this.result.closeCount;
            }
        }

        public void handleToken(Segment segment, byte by, int n, int n2, TokenMarker.LineContext lineContext) {
            if (!this.rejectsToken(by)) {
                this.scan(segment, n, n2);
            }
            this.scannedIndex += n2;
        }

        public void setLineContext(TokenMarker.LineContext lineContext) {
        }
    }

    public static class Brackets {
        int openCount;
        int closeCount;
    }
}

