/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpHistoryModel;
import org.gjt.sp.jedit.jEdit;

public class HistoryButton
extends JPanel
implements ActionListener {
    public static final int BACK = 0;
    public static final int FORWARD = 1;
    private int type;
    private HelpHistoryModel history;
    private RolloverButton arrow_button;
    private RolloverButton drop_button;
    private JPopupMenu historyList;
    private ActionListener arrowActionListener;

    public HistoryButton(int n, HelpHistoryModel helpHistoryModel) {
        this.arrow_button = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty(n == 0 ? "helpviewer.back.icon" : "helpviewer.forward.icon")));
        this.arrow_button.setToolTipText(jEdit.getProperty(n == 0 ? "helpviewer.back.label" : "helpviewer.forward.label"));
        Box box = new Box(0);
        this.drop_button = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
        this.drop_button.addActionListener(new DropActionHandler());
        box.add(this.arrow_button);
        box.add(this.drop_button);
        this.setMaximumSize(new Dimension(this.drop_button.getPreferredSize().width + this.arrow_button.getPreferredSize().width + 5, this.arrow_button.getPreferredSize().height + 10));
        this.add(box);
        this.type = n;
        this.history = helpHistoryModel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.drop_button.setEnabled(bl);
        this.arrow_button.setEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.arrow_button.addActionListener(this);
        this.arrowActionListener = actionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.arrowActionListener.actionPerformed(new ActionEvent(this, 1001, actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
    }

    private HistoryButton getParentHistoryButton() {
        return this;
    }

    class HistoryListActionHandler
    extends AbstractAction {
        HelpHistoryModel.HistoryEntry entry;

        HistoryListActionHandler(HelpHistoryModel.HistoryEntry historyEntry) {
            super(historyEntry.title);
            this.entry = historyEntry;
            this.putValue("ActionCommandKey", historyEntry.url + ':' + historyEntry.scrollPosition);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HistoryButton.this.getParentHistoryButton().actionPerformed(actionEvent);
            HistoryButton.this.history.setCurrentEntry(this.entry);
        }
    }

    class DropActionHandler
    implements ActionListener {
        DropActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HistoryButton.this.historyList = new JPopupMenu();
            HelpHistoryModel.HistoryEntry[] historyEntryArray = HistoryButton.this.type == 0 ? HistoryButton.this.history.getPreviousURLs() : HistoryButton.this.history.getNextURLs();
            if (historyEntryArray != null) {
                if (HistoryButton.this.type == 0) {
                    for (int i = historyEntryArray.length - 1; i >= 0; --i) {
                        if (historyEntryArray[i] == null) continue;
                        HistoryButton.this.historyList.add(new HistoryListActionHandler(historyEntryArray[i]));
                    }
                } else {
                    for (int i = 0; i < historyEntryArray.length; ++i) {
                        if (historyEntryArray[i] == null) continue;
                        HistoryButton.this.historyList.add(new HistoryListActionHandler(historyEntryArray[i]));
                    }
                }
                HistoryButton.this.historyList.show((JComponent)actionEvent.getSource(), 0, 0);
            }
        }
    }
}

