/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.help.HelpHistoryModel;
import org.gjt.sp.jedit.help.HelpHistoryModelListener;
import org.gjt.sp.jedit.help.HelpSearchPanel;
import org.gjt.sp.jedit.help.HelpTOCPanel;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.help.HistoryButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class HelpViewer
extends JFrame
implements HelpViewerInterface,
EBComponent,
HelpHistoryModelListener {
    private String baseURL;
    private String shortURL;
    private HistoryButton back;
    private HistoryButton forward;
    private JEditorPane viewer;
    private JScrollPane viewerScrollPane;
    private JLabel title;
    private JSplitPane splitter;
    private HelpHistoryModel historyModel;
    private HelpTOCPanel toc;
    private boolean queuedTOCReload;

    public HelpViewer() {
        this("welcome.html");
    }

    public HelpViewer(URL uRL) {
        this(uRL.toString());
    }

    public HelpViewer(String string) {
        super(jEdit.getProperty("helpviewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        try {
            this.baseURL = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc")).toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
        }
        ActionHandler actionHandler = new ActionHandler();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.toc = new HelpTOCPanel(this);
        jTabbedPane.addTab(jEdit.getProperty("helpviewer.toc.label"), this.toc);
        jTabbedPane.addTab(jEdit.getProperty("helpviewer.search.label"), new HelpSearchPanel(this));
        jTabbedPane.setMinimumSize(new Dimension(0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = new Box(0);
        this.title = new JLabel();
        box.add(this.title);
        box.add(Box.createGlue());
        this.historyModel = new HelpHistoryModel(25);
        this.back = new HistoryButton(0, this.historyModel);
        this.back.addActionListener(actionHandler);
        box.add(this.back);
        this.forward = new HistoryButton(1, this.historyModel);
        this.forward.addActionListener(actionHandler);
        box.add(this.forward);
        this.back.setPreferredSize(this.forward.getPreferredSize());
        jPanel.add("North", box);
        this.viewer = new JEditorPane();
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.viewer.setFont(new Font("Monospaced", 0, 12));
        this.viewer.addPropertyChangeListener(new PropertyChangeHandler());
        this.viewer.addKeyListener(new KeyHandler());
        this.viewerScrollPane = new JScrollPane(this.viewer);
        jPanel.add("Center", this.viewerScrollPane);
        this.splitter = new JSplitPane(1, jEdit.getBooleanProperty("appearance.continuousLayout"), jTabbedPane, jPanel);
        this.splitter.setBorder(null);
        this.getContentPane().add("Center", this.splitter);
        this.historyModel.addHelpHistoryModelListener(this);
        this.historyUpdated();
        this.gotoURL(string, true, 0);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setPreferredSize(new Dimension(750, 500));
        this.pack();
        GUIUtilities.loadGeometry(this, "helpviewer");
        GUIUtilities.addSizeSaver(this, "helpviewer");
        EditBus.addToBus(this);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.splitter.setDividerLocation(jEdit.getIntegerProperty("helpviewer.splitter", 250));
                HelpViewer.this.viewer.requestFocus();
            }
        });
    }

    public void gotoURL(String string, boolean bl, final int n) {
        String string2;
        if (MiscUtilities.isURL(string)) {
            if (string.startsWith(this.baseURL)) {
                string2 = string.substring(this.baseURL.length());
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
            } else {
                string2 = string;
            }
        } else {
            string2 = string;
            string = this.baseURL.endsWith("/") ? this.baseURL + string : this.baseURL + '/' + string;
        }
        this.viewer.setCursor(Cursor.getDefaultCursor());
        try {
            URL uRL = new URL(string);
            if (!uRL.equals(this.viewer.getPage())) {
                this.title.setText(jEdit.getProperty("helpviewer.loading"));
            }
            this.historyModel.setCurrentScrollPosition(this.viewer.getPage(), this.getCurrentScrollPosition());
            this.viewer.setPage(uRL);
            if (0 != n) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HelpViewer.this.viewerScrollPane.getVerticalScrollBar().setValue(n);
                    }
                });
            }
            if (bl) {
                this.historyModel.addToHistory(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
            Object[] objectArray = new String[]{string, malformedURLException.getMessage()};
            GUIUtilities.error(this, "badurl", objectArray);
            return;
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            Object[] objectArray = new String[]{string, iOException.toString()};
            GUIUtilities.error(this, "read-error", objectArray);
            return;
        }
        this.shortURL = string2;
        if (string2 != null) {
            this.toc.selectNode(string2);
        }
        this.viewer.requestFocus();
    }

    int getCurrentScrollPosition() {
        return this.viewerScrollPane.getVerticalScrollBar().getValue();
    }

    URL getCurrentPage() {
        return this.viewer.getPage();
    }

    public void dispose() {
        EditBus.removeFromBus(this);
        jEdit.setIntegerProperty("helpviewer.splitter", this.splitter.getDividerLocation());
        super.dispose();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PluginUpdate) {
            PluginUpdate pluginUpdate = (PluginUpdate)eBMessage;
            if (!(pluginUpdate.getWhat() != PluginUpdate.LOADED && pluginUpdate.getWhat() != PluginUpdate.UNLOADED || pluginUpdate.isExiting())) {
                if (!this.queuedTOCReload) {
                    this.queueTOCReload();
                }
                this.queuedTOCReload = true;
            }
        } else if (eBMessage instanceof PropertiesChanged) {
            GUIUtilities.initContinuousLayout(this.splitter);
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getShortURL() {
        return this.shortURL;
    }

    public void historyUpdated() {
        this.back.setEnabled(this.historyModel.hasPrevious());
        this.forward.setEnabled(this.historyModel.hasNext());
    }

    public Component getComponent() {
        return this.getRootPane();
    }

    public void queueTOCReload() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.queuedTOCReload = false;
                HelpViewer.this.toc.load();
            }
        });
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    JScrollBar jScrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(-1));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    JScrollBar jScrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    JScrollBar jScrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(-1));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    JScrollBar jScrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
                    keyEvent.consume();
                }
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("page".equals(propertyChangeEvent.getPropertyName())) {
                String string = (String)HelpViewer.this.viewer.getDocument().getProperty("title");
                if (string == null) {
                    string = MiscUtilities.getFileName(HelpViewer.this.viewer.getPage().toString());
                }
                HelpViewer.this.title.setText(string);
                HelpViewer.this.historyModel.updateTitle(HelpViewer.this.viewer.getPage().toString(), string);
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HelpViewer.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                    HelpViewer.this.historyUpdated();
                } else {
                    URL uRL = hyperlinkEvent.getURL();
                    if (uRL != null) {
                        HelpViewer.this.gotoURL(uRL.toString(), true, 0);
                    }
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                HelpViewer.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                HelpViewer.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string;
            Object object = actionEvent.getSource();
            String string2 = actionEvent.getActionCommand();
            int n2 = string2.lastIndexOf(58);
            if (-1 == n2) {
                string = string2;
                n = 0;
            } else {
                string = string2.substring(0, n2);
                n = Integer.parseInt(string2.substring(n2 + 1));
            }
            if (string.length() != 0) {
                HelpViewer.this.gotoURL(string, false, n);
                return;
            }
            if (object == HelpViewer.this.back) {
                HelpHistoryModel.HistoryEntry historyEntry = HelpViewer.this.historyModel.back(HelpViewer.this);
                if (historyEntry == null) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    HelpViewer.this.gotoURL(historyEntry.url, false, historyEntry.scrollPosition);
                }
            } else if (object == HelpViewer.this.forward) {
                HelpHistoryModel.HistoryEntry historyEntry = HelpViewer.this.historyModel.forward(HelpViewer.this);
                if (historyEntry == null) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    HelpViewer.this.gotoURL(historyEntry.url, false, historyEntry.scrollPosition);
                }
            }
        }
    }
}

