/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class WrapWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        WrapWidget wrapWidget = new WrapWidget(view);
        return wrapWidget;
    }

    private static class WrapWidget
    implements Widget {
        private final JLabel wrap = new ToolTipLabel();
        private final View view;

        public WrapWidget(final View view) {
            this.wrap.setHorizontalAlignment(0);
            this.wrap.setToolTipText(jEdit.getProperty("view.status.wrap-tooltip"));
            this.view = view;
            this.wrap.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    view.getBuffer().toggleWordWrap(view);
                }
            });
        }

        public JComponent getComponent() {
            return this.wrap;
        }

        public void update() {
            Buffer buffer = this.view.getBuffer();
            String string = buffer.getStringProperty("wrap");
            if (string.equals("none")) {
                this.wrap.setText("-");
            } else if (string.equals("hard")) {
                this.wrap.setText("H");
            } else if (string.equals("soft")) {
                this.wrap.setText("S");
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.wrap.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(Math.max(fontMetrics.charWidth('-'), fontMetrics.charWidth('H')), fontMetrics.charWidth('S')) + 1, fontMetrics.getHeight());
            this.wrap.setPreferredSize(dimension);
            this.wrap.setMaximumSize(dimension);
        }
    }
}

