/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class MultiSelectWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        MultiSelectWidget multiSelectWidget = new MultiSelectWidget(view);
        return multiSelectWidget;
    }

    private static class MultiSelectWidget
    implements Widget {
        private final JLabel multiSelect = new ToolTipLabel();
        private final View view;

        MultiSelectWidget(final View view) {
            this.multiSelect.setHorizontalAlignment(0);
            this.multiSelect.setToolTipText(jEdit.getProperty("view.status.multi-tooltip"));
            this.view = view;
            this.multiSelect.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JEditTextArea jEditTextArea = view.getTextArea();
                    if (jEditTextArea != null) {
                        jEditTextArea.toggleMultipleSelectionEnabled();
                    }
                }
            });
        }

        public JComponent getComponent() {
            return this.multiSelect;
        }

        public void update() {
            JEditTextArea jEditTextArea = this.view.getTextArea();
            if (jEditTextArea != null) {
                this.multiSelect.setText(jEditTextArea.isMultipleSelectionEnabled() ? "M" : "-");
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.multiSelect.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(fontMetrics.charWidth('-'), fontMetrics.charWidth('M')) + 1, fontMetrics.getHeight());
            this.multiSelect.setPreferredSize(dimension);
            this.multiSelect.setMaximumSize(dimension);
        }
    }
}

