/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ErrorsWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        ErrorWidget errorWidget = new ErrorWidget(view);
        return errorWidget;
    }

    private static class ErrorDialog
    extends EnhancedDialog {
        private final JTextArea textArea;
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private final PrintStream printStream = new PrintStream(this.byteArrayOutputStream);
        private final JButton removeThisError;
        private final JButton removeAllErrors;
        private final Object[] throwables = Log.throwables.toArray();
        private final JComboBox combo;

        private ErrorDialog(Frame frame) {
            super(frame, "Errors", false);
            Serializable serializable;
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            if (this.throwables.length != 0) {
                serializable = (Throwable)this.throwables[0];
                this.setThrowable((Throwable)serializable);
            }
            this.combo = new JComboBox<Object>(this.throwables);
            this.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ErrorDialog.this.setThrowable((Throwable)ErrorDialog.this.combo.getSelectedItem());
                }
            });
            this.getContentPane().add((Component)this.combo, "North");
            this.getContentPane().add(new JScrollPane(this.textArea));
            serializable = new Box(0);
            ((Container)serializable).add(Box.createGlue());
            this.removeThisError = new JButton(jEdit.getProperty("grab-key.remove"));
            ((Container)serializable).add(this.removeThisError);
            ((Container)serializable).add(Box.createHorizontalStrut(6));
            this.removeAllErrors = new JButton(jEdit.getProperty("common.clearAll"));
            ((Container)serializable).add(this.removeAllErrors);
            MyActionListener myActionListener = new MyActionListener();
            this.removeThisError.addActionListener(myActionListener);
            this.removeAllErrors.addActionListener(myActionListener);
            ((Container)serializable).add(Box.createGlue());
            this.getContentPane().add((Component)serializable, "South");
            this.pack();
            GUIUtilities.loadGeometry(this, "status.errorWidget");
            this.setVisible(true);
        }

        private void setThrowable(Throwable throwable) {
            if (throwable == null) {
                this.textArea.setText(null);
            } else {
                throwable.printStackTrace(this.printStream);
                this.textArea.setText(this.byteArrayOutputStream.toString());
                this.textArea.setCaretPosition(0);
                this.byteArrayOutputStream.reset();
            }
        }

        public void dispose() {
            GUIUtilities.saveGeometry(this, "status.errorWidget");
            super.dispose();
        }

        public void ok() {
            this.dispose();
        }

        public void cancel() {
            this.dispose();
        }

        private class MyActionListener
        implements ActionListener {
            private MyActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == ErrorDialog.this.removeThisError) {
                    Throwable throwable = (Throwable)ErrorDialog.this.combo.getSelectedItem();
                    if (throwable != null) {
                        Log.throwables.remove(throwable);
                        ErrorDialog.this.combo.removeItem(throwable);
                        if (ErrorDialog.this.combo.getItemCount() == 0) {
                            ErrorDialog.this.dispose();
                        }
                    }
                } else if (object == ErrorDialog.this.removeAllErrors) {
                    for (Object object2 : ErrorDialog.this.throwables) {
                        Log.throwables.remove(object2);
                    }
                    ErrorDialog.this.dispose();
                }
            }
        }
    }

    private static class ErrorHighlight
    extends JLabel
    implements ActionListener {
        private int currentSize;
        private Timer timer;

        ErrorHighlight(View view) {
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.addMouseListener(new MyMouseAdapter(view));
        }

        public void addNotify() {
            super.addNotify();
            this.update();
            int n = 1000;
            this.timer = new Timer(n, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private void update() {
            int n = Log.throwables.size();
            if (n != this.currentSize) {
                this.currentSize = n;
                if (n == 0) {
                    this.setForeground(jEdit.getColorProperty("view.status.foreground"));
                    this.setText(null);
                    this.setToolTipText(n + " error");
                } else {
                    this.setForeground(Color.red);
                    this.setText(Integer.toString(n) + " error(s)");
                    this.setToolTipText(n + " error(s)");
                }
            }
        }

        private class MyMouseAdapter
        extends MouseAdapter {
            private final View view;

            MyMouseAdapter(View view) {
                this.view = view;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (Log.throwables.isEmpty()) {
                    return;
                }
                if (GUIUtilities.isRightButton(mouseEvent.getModifiers())) {
                    JPopupMenu jPopupMenu = GUIUtilities.loadPopupMenu("errorwidget.popupmenu");
                    GUIUtilities.showPopupMenu(jPopupMenu, ErrorHighlight.this, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() == 2) {
                    new ErrorDialog((Frame)this.view);
                }
            }
        }
    }

    private static class ErrorWidget
    implements Widget {
        private final ErrorHighlight errorHighlight;

        ErrorWidget(View view) {
            this.errorHighlight = new ErrorHighlight(view);
        }

        public JComponent getComponent() {
            return this.errorHighlight;
        }

        public void update() {
            this.errorHighlight.update();
        }

        public void propertiesChanged() {
        }
    }
}

