/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class BufferSetWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        BufferSetWidget bufferSetWidget = new BufferSetWidget(view);
        return bufferSetWidget;
    }

    private static class BufferSetWidget
    implements Widget,
    EBComponent {
        private final JLabel bufferSetLabel = new ToolTipLabel(){

            public void addNotify() {
                super.addNotify();
                EditBus.addToBus(BufferSetWidget.this);
            }

            public void removeNotify() {
                super.removeNotify();
                EditBus.removeFromBus(BufferSetWidget.this);
            }
        };
        private final View view;
        private BufferSet.Scope currentScope;

        BufferSetWidget(final View view) {
            this.view = view;
            this.update();
            this.bufferSetLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        EditPane editPane = view.getEditPane();
                        BufferSet.Scope scope = editPane.getBufferSetScope();
                        switch (scope) {
                            case global: {
                                scope = BufferSet.Scope.view;
                                break;
                            }
                            case view: {
                                scope = BufferSet.Scope.editpane;
                                break;
                            }
                            case editpane: {
                                scope = BufferSet.Scope.global;
                            }
                        }
                        editPane.setBufferSetScope(scope);
                    }
                }
            });
        }

        public JComponent getComponent() {
            return this.bufferSetLabel;
        }

        public void update() {
            BufferSet.Scope scope = this.view.getEditPane().getBufferSetScope();
            if (this.currentScope == null || !this.currentScope.equals((Object)scope)) {
                this.bufferSetLabel.setText(scope.toString().substring(0, 1).toUpperCase());
                this.bufferSetLabel.setToolTipText(jEdit.getProperty("view.status.bufferset-tooltip", new Object[]{scope}));
                this.currentScope = scope;
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.bufferSetLabel.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(fontMetrics.charWidth('E'), Math.max(fontMetrics.charWidth('V'), fontMetrics.charWidth('G'))), fontMetrics.getHeight());
            this.bufferSetLabel.setPreferredSize(dimension);
            this.bufferSetLabel.setMaximumSize(dimension);
        }

        public void handleMessage(EBMessage eBMessage) {
            EditPaneUpdate editPaneUpdate;
            if (eBMessage instanceof ViewUpdate) {
                ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
                if (viewUpdate.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
                    this.update();
                }
            } else if (eBMessage instanceof EditPaneUpdate && (editPaneUpdate = (EditPaneUpdate)eBMessage).getEditPane() == this.view.getEditPane() && editPaneUpdate.getWhat() == EditPaneUpdate.BUFFERSET_CHANGED) {
                this.update();
            }
        }
    }
}

