/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class TipOfTheDay
extends EnhancedDialog {
    private JCheckBox showNextTime;
    private JButton nextTip;
    private JButton close;
    private JEditorPane tipText;
    private int currentTip = -1;

    public TipOfTheDay(View view) {
        super(view, jEdit.getProperty("tip.title"), false);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JLabel jLabel = new JLabel(jEdit.getProperty("tip.caption"));
        jLabel.setFont(new Font("SansSerif", 0, 24));
        jLabel.setForeground(UIManager.getColor("Button.foreground"));
        jPanel.add("North", jLabel);
        this.tipText = new JEditorPane();
        this.tipText.setEditable(false);
        this.tipText.setContentType("text/html");
        this.nextTip();
        JScrollPane jScrollPane = new JScrollPane(this.tipText);
        jScrollPane.setPreferredSize(new Dimension(150, 150));
        jPanel.add("Center", jScrollPane);
        ActionHandler actionHandler = new ActionHandler();
        Box box = new Box(0);
        this.showNextTime = new JCheckBox(jEdit.getProperty("tip.show-next-time"), jEdit.getBooleanProperty("tip.show"));
        this.showNextTime.addActionListener(actionHandler);
        box.add(this.showNextTime);
        box.add(Box.createHorizontalStrut(6));
        box.add(Box.createGlue());
        this.nextTip = new JButton(jEdit.getProperty("tip.next-tip"));
        this.nextTip.addActionListener(actionHandler);
        box.add(this.nextTip);
        box.add(Box.createHorizontalStrut(6));
        this.close = new JButton(jEdit.getProperty("common.close"));
        this.close.addActionListener(actionHandler);
        box.add(this.close);
        jPanel.getRootPane().setDefaultButton(this.close);
        Dimension dimension = this.nextTip.getPreferredSize();
        dimension.width = Math.max(dimension.width, this.close.getPreferredSize().width);
        this.nextTip.setPreferredSize(dimension);
        this.close.setPreferredSize(dimension);
        jPanel.add("South", box);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    private void nextTip() {
        File[] fileArray = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc", "tips")).listFiles();
        if (fileArray == null || fileArray.length == 0) {
            this.tipText.setText(jEdit.getProperty("tip.not-found"));
            return;
        }
        int n = fileArray.length;
        int n2 = this.currentTip;
        while (n2 == this.currentTip || !fileArray[n2].getName().endsWith(".html")) {
            n2 = new Random().nextInt(Integer.MAX_VALUE) % n;
        }
        try {
            this.tipText.setPage(fileArray[n2].toURI().toURL());
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == TipOfTheDay.this.showNextTime) {
                jEdit.setBooleanProperty("tip.show", TipOfTheDay.this.showNextTime.isSelected());
            } else if (object == TipOfTheDay.this.nextTip) {
                TipOfTheDay.this.nextTip();
            } else if (object == TipOfTheDay.this.close) {
                TipOfTheDay.this.dispose();
            }
        }
    }
}

