/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class StyleEditor
extends EnhancedDialog
implements ActionListener {
    private JCheckBox italics;
    private JCheckBox bold;
    private JCheckBox fgColorCheckBox;
    private ColorWellButton fgColor;
    private JCheckBox bgColorCheckBox;
    private ColorWellButton bgColor;
    private JButton ok;
    private JButton cancel;
    private boolean okClicked;

    public StyleEditor(JDialog jDialog, SyntaxStyle syntaxStyle, String string) {
        super(jDialog, jEdit.getProperty("style-editor.title"), true);
        this.initialize(jDialog, syntaxStyle, string);
    }

    public StyleEditor(JFrame jFrame, SyntaxStyle syntaxStyle, String string) {
        super(jFrame, jEdit.getProperty("style-editor.title"), true);
        this.initialize(jFrame, syntaxStyle, string);
    }

    private void initialize(Component component, SyntaxStyle syntaxStyle, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 2, 12, 12));
        jPanel2.add(new JLabel(jEdit.getProperty("style-editor.tokenType")));
        jPanel2.add(new JLabel(string));
        this.italics = new JCheckBox(jEdit.getProperty("style-editor.italics"));
        this.italics.setSelected(syntaxStyle.getFont().isItalic());
        jPanel2.add(this.italics);
        jPanel2.add(new JLabel());
        this.bold = new JCheckBox(jEdit.getProperty("style-editor.bold"));
        this.bold.setSelected(syntaxStyle.getFont().isBold());
        jPanel2.add(this.bold);
        jPanel2.add(new JLabel());
        Color color = syntaxStyle.getForegroundColor();
        this.fgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.fgColor"));
        this.fgColorCheckBox.setSelected(color != null);
        this.fgColorCheckBox.addActionListener(this);
        jPanel2.add(this.fgColorCheckBox);
        this.fgColor = new ColorWellButton(color);
        this.fgColor.setEnabled(color != null);
        jPanel2.add(this.fgColor);
        Color color2 = syntaxStyle.getBackgroundColor();
        this.bgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.bgColor"));
        this.bgColorCheckBox.setSelected(color2 != null);
        this.bgColorCheckBox.addActionListener(this);
        jPanel2.add(this.bgColorCheckBox);
        this.bgColor = new ColorWellButton(color2);
        this.bgColor.setEnabled(color2 != null);
        jPanel2.add(this.bgColor);
        jPanel.add("Center", jPanel2);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        box.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(this);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        box.add(this.cancel);
        this.cancel.addActionListener(this);
        box.add(Box.createGlue());
        jPanel.add("South", box);
        this.pack();
        this.setLocationRelativeTo(component);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        } else if (object == this.fgColorCheckBox) {
            this.fgColor.setEnabled(this.fgColorCheckBox.isSelected());
        } else if (object == this.bgColorCheckBox) {
            this.bgColor.setEnabled(this.bgColorCheckBox.isSelected());
        }
    }

    public void ok() {
        this.okClicked = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public SyntaxStyle getStyle() {
        if (!this.okClicked) {
            return null;
        }
        Color color = this.fgColorCheckBox.isSelected() ? this.fgColor.getSelectedColor() : null;
        Color color2 = this.bgColorCheckBox.isSelected() ? this.bgColor.getSelectedColor() : null;
        return new SyntaxStyle(color, color2, new Font("Dialog", (this.italics.isSelected() ? 2 : 0) | (this.bold.isSelected() ? 1 : 0), 12));
    }
}

