/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class StatusBar
extends JPanel
implements WorkThreadProgressListener {
    private String currentBar;
    private final View view;
    private final JPanel panel;
    private final Box box;
    private final ToolTipLabel caretStatus;
    private Component messageComp;
    private final JLabel message;
    private final Widget modeWidget;
    private final Widget foldWidget;
    private final Widget encodingWidget;
    private final Widget wrapWidget;
    private final Widget multiSelectWidget;
    private final Widget rectSelectWidget;
    private final Widget overwriteWidget;
    private final Widget lineSepWidget;
    StringBuilder buf = new StringBuilder();
    private Timer tempTimer;
    private boolean currentMessageIsIO;
    private final Segment seg = new Segment();
    private boolean showCaretStatus;
    static final String caretTestStr = "9999,999-999 (99999999/99999999)";

    public StatusBar(View view) {
        super(new BorderLayout());
        this.setName("StatusBar");
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.view = view;
        this.panel = new JPanel(new BorderLayout());
        this.box = new Box(0);
        this.panel.add("East", this.box);
        this.add("Center", this.panel);
        MouseHandler mouseHandler = new MouseHandler();
        this.caretStatus = new ToolTipLabel();
        this.caretStatus.setName("caretStatus");
        this.caretStatus.setToolTipText(jEdit.getProperty("view.status.caret-tooltip"));
        this.caretStatus.addMouseListener(mouseHandler);
        this.message = new JLabel(" ");
        this.setMessageComponent(this.message);
        this.modeWidget = this._getWidget("mode");
        this.foldWidget = this._getWidget("fold");
        this.encodingWidget = this._getWidget("encoding");
        this.wrapWidget = this._getWidget("wrap");
        this.multiSelectWidget = this._getWidget("multiSelect");
        this.rectSelectWidget = this._getWidget("rectSelect");
        this.overwriteWidget = this._getWidget("overwrite");
        this.lineSepWidget = this._getWidget("lineSep");
    }

    public void propertiesChanged() {
        Object object;
        Color color = jEdit.getColorProperty("view.status.foreground");
        Color color2 = jEdit.getColorProperty("view.status.background");
        this.showCaretStatus = jEdit.getBooleanProperty("view.status.show-caret-status");
        this.panel.setBackground(color2);
        this.panel.setForeground(color);
        this.caretStatus.setBackground(color2);
        this.caretStatus.setForeground(color);
        this.message.setBackground(color2);
        this.message.setForeground(color);
        Font font = new JLabel().getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (this.showCaretStatus) {
            this.panel.add("West", this.caretStatus);
            this.caretStatus.setFont(font);
            object = new Dimension(fontMetrics.stringWidth(caretTestStr), fontMetrics.getHeight());
            this.caretStatus.setPreferredSize((Dimension)object);
            this.updateCaretStatus();
        } else {
            this.panel.remove(this.caretStatus);
        }
        object = jEdit.getProperty("view.status");
        if (!StandardUtilities.objectsEqual(this.currentBar, object)) {
            this.box.removeAll();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            while (stringTokenizer.hasMoreTokens()) {
                Object object2;
                String string = stringTokenizer.nextToken();
                if (Character.isLetter(string.charAt(0))) {
                    object2 = this.getWidget(string);
                    if (object2 == null) {
                        Log.log(7, this, "Widget " + string + " doesn't exist");
                        continue;
                    }
                    JComponent jComponent = object2.getComponent();
                    ((Component)jComponent).setBackground(color2);
                    ((Component)jComponent).setForeground(color);
                    this.box.add(jComponent);
                    object2.update();
                    object2.propertiesChanged();
                    continue;
                }
                object2 = new JLabel(string);
                ((JComponent)object2).setBackground(color2);
                ((JComponent)object2).setForeground(color);
                this.box.add((Component)object2);
            }
            this.currentBar = object;
        }
        this.updateBufferStatus();
        this.updateMiscStatus();
    }

    public void addNotify() {
        super.addNotify();
        VFSManager.getIOThreadPool().addProgressListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        VFSManager.getIOThreadPool().removeProgressListener(this);
    }

    public void statusUpdate(final WorkThreadPool workThreadPool, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (StatusBar.this.message != null && !"".equals(StatusBar.this.message.getText().trim()) && !StatusBar.this.currentMessageIsIO) {
                    return;
                }
                int n = workThreadPool.getRequestCount();
                if (n == 0) {
                    StatusBar.this.setMessageAndClear(jEdit.getProperty("view.status.io.done"));
                    StatusBar.this.currentMessageIsIO = true;
                } else if (n == 1) {
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io-1"));
                    StatusBar.this.currentMessageIsIO = true;
                } else {
                    Object[] objectArray = new Object[]{n};
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io", objectArray));
                    StatusBar.this.currentMessageIsIO = true;
                }
            }
        });
    }

    public void progressUpdate(WorkThreadPool workThreadPool, int n) {
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessageAndClear(String string) {
        this.setMessage(string);
        this.tempTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StatusBar.this.isShowing()) {
                    StatusBar.this.setMessage(null);
                }
            }
        });
        this.tempTimer.setInitialDelay(10000);
        this.tempTimer.setRepeats(false);
        this.tempTimer.start();
    }

    public void setMessage(String string) {
        if (this.tempTimer != null) {
            this.tempTimer.stop();
            this.tempTimer = null;
        }
        this.setMessageComponent(this.message);
        if (string == null) {
            if (this.view.getMacroRecorder() != null) {
                this.message.setText(jEdit.getProperty("view.status.recording"));
            } else {
                this.message.setText(" ");
            }
        } else {
            this.message.setText(string);
        }
    }

    public void setMessageComponent(Component component) {
        this.currentMessageIsIO = false;
        if (component == null || this.messageComp == component) {
            return;
        }
        this.messageComp = component;
        this.panel.add("Center", this.messageComp);
    }

    public void updateCaretStatus() {
        if (this.showCaretStatus) {
            Buffer buffer = this.view.getBuffer();
            if (!buffer.isLoaded() || buffer != this.view.getTextArea().getBuffer()) {
                this.caretStatus.setText(" ");
                return;
            }
            JEditTextArea jEditTextArea = this.view.getTextArea();
            int n = jEditTextArea.getCaretPosition();
            int n2 = jEditTextArea.getCaretLine();
            if (n2 >= buffer.getLineCount()) {
                return;
            }
            int n3 = jEditTextArea.getLineStartOffset(n2);
            int n4 = n - n3;
            if (n4 < 0) {
                return;
            }
            int n5 = buffer.getLength();
            buffer.getText(n3, n4, this.seg);
            int n6 = StandardUtilities.getVirtualWidth(this.seg, buffer.getTabSize());
            this.seg.array = null;
            this.seg.count = 0;
            if (jEdit.getBooleanProperty("view.status.show-caret-linenumber", true)) {
                this.buf.append(n2 + 1);
                this.buf.append(',');
            }
            if (jEdit.getBooleanProperty("view.status.show-caret-dot", true)) {
                this.buf.append(n4 + 1);
            }
            if (jEdit.getBooleanProperty("view.status.show-caret-virtual", true) && n6 != n4) {
                this.buf.append('-');
                this.buf.append(n6 + 1);
            }
            if (this.buf.length() > 0) {
                this.buf.append(' ');
            }
            if (jEdit.getBooleanProperty("view.status.show-caret-offset", true) && jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true)) {
                this.buf.append('(');
                this.buf.append(n);
                this.buf.append('/');
                this.buf.append(n5);
                this.buf.append(')');
            } else if (jEdit.getBooleanProperty("view.status.show-caret-offset", true)) {
                this.buf.append('(');
                this.buf.append(n);
                this.buf.append(')');
            } else if (jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true)) {
                this.buf.append('(');
                this.buf.append(n5);
                this.buf.append(')');
            }
            this.caretStatus.setText(this.buf.toString());
            this.buf.setLength(0);
        }
    }

    public void updateBufferStatus() {
        this.wrapWidget.update();
        this.lineSepWidget.update();
        this.modeWidget.update();
        this.foldWidget.update();
        this.encodingWidget.update();
    }

    public void updateMiscStatus() {
        this.multiSelectWidget.update();
        this.rectSelectWidget.update();
        this.overwriteWidget.update();
    }

    private Widget getWidget(String string) {
        if ("mode".equals(string)) {
            return this.modeWidget;
        }
        if ("fold".equals(string)) {
            return this.foldWidget;
        }
        if ("encoding".equals(string)) {
            return this.encodingWidget;
        }
        if ("wrap".equals(string)) {
            return this.wrapWidget;
        }
        if ("multiSelect".equals(string)) {
            return this.multiSelectWidget;
        }
        if ("rectSelect".equals(string)) {
            return this.rectSelectWidget;
        }
        if ("overwrite".equals(string)) {
            return this.overwriteWidget;
        }
        if ("lineSep".equals(string)) {
            return this.lineSepWidget;
        }
        return this._getWidget(string);
    }

    private Widget _getWidget(String string) {
        StatusWidgetFactory statusWidgetFactory = (StatusWidgetFactory)ServiceManager.getService("org.gjt.sp.jedit.gui.statusbar.StatusWidget", string);
        if (statusWidgetFactory == null) {
            Log.log(9, this, "Widget " + string + " doesn't exist");
            return null;
        }
        return statusWidgetFactory.getWidget(this.view);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == StatusBar.this.caretStatus && mouseEvent.getClickCount() == 2) {
                StatusBar.this.view.getTextArea().showGoToLineDialog();
            }
        }
    }
}

