/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.FilteredListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class LogViewer
extends JPanel
implements DefaultFocusComponent,
EBComponent {
    private ListHandler listHandler;
    private final FilteredListModel listModel;
    private final JList list;
    private final JButton copy;
    private final JCheckBox tail;
    private final JTextField filter;
    private boolean tailIsOn;

    public LogViewer() {
        super(new BorderLayout());
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            object = new String[]{MiscUtilities.constructPath(string, "activity.log")};
            jComponent = new JLabel(jEdit.getProperty("log-viewer.caption", (Object[])object));
            jPanel.add(jComponent);
        }
        jPanel.add(Box.createHorizontalGlue());
        this.tailIsOn = jEdit.getBooleanProperty("log-viewer.tail", false);
        this.tail = new JCheckBox(jEdit.getProperty("log-viewer.tail.label"), this.tailIsOn);
        this.tail.addActionListener(new ActionHandler());
        this.filter = new JTextField();
        this.filter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                LogViewer.this.setFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                LogViewer.this.setFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                LogViewer.this.setFilter();
            }
        });
        jPanel.add(this.filter);
        jPanel.add(this.tail);
        jPanel.add(Box.createHorizontalStrut(12));
        this.copy = new JButton(jEdit.getProperty("log-viewer.copy"));
        this.copy.addActionListener(new ActionHandler());
        jPanel.add(this.copy);
        object = Log.getLogListModel();
        this.listModel = new MyFilteredListModel((ListModel)object);
        object.removeListDataListener(this.listModel);
        this.list = new LogList(this.listModel);
        this.listModel.setList(this.list);
        this.add("North", jPanel);
        jComponent = new JScrollPane(this.list);
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = Math.min(600, dimension.width);
        jComponent.setPreferredSize(dimension);
        this.add("Center", jComponent);
        this.propertiesChanged();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.list.setCellRenderer(new ColorizerCellRenderer());
        super.setBounds(n, n2, n3, n4);
        this.scrollLaterIfRequired();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public void addNotify() {
        super.addNotify();
        ListModel listModel = Log.getLogListModel();
        listModel.addListDataListener(this.listModel);
        this.listHandler = new ListHandler();
        listModel.addListDataListener(this.listHandler);
        if (this.tailIsOn) {
            this.scrollToTail();
        }
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        super.removeNotify();
        ListModel listModel = Log.getLogListModel();
        listModel.removeListDataListener(this.listModel);
        listModel.removeListDataListener(this.listHandler);
        this.listHandler = null;
        EditBus.removeFromBus(this);
    }

    public void focusOnDefaultComponent() {
        this.list.requestFocus();
    }

    private void setFilter() {
        this.listModel.setFilter(this.filter.getText());
        this.scrollLaterIfRequired();
    }

    private void propertiesChanged() {
        this.list.setFont(jEdit.getFontProperty("view.font"));
        this.list.setFixedCellHeight(this.list.getFontMetrics(this.list.getFont()).getHeight());
    }

    private void scrollToTail() {
        int n = this.list.getModel().getSize();
        if (n != 0) {
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    private void scrollLaterIfRequired() {
        if (this.tailIsOn) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogViewer.this.scrollToTail();
                }
            });
        }
    }

    private static class MyFilteredListModel
    extends FilteredListModel {
        MyFilteredListModel(ListModel listModel) {
            super(listModel);
        }

        public String prepareFilter(String string) {
            return string.toLowerCase();
        }

        public boolean passFilter(int n, String string) {
            return this.delegated.getElementAt(n).toString().toLowerCase().contains(string);
        }
    }

    private static class ColorizerCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ColorizerCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                Color color = jList.getForeground();
                if (string.contains("[debug]")) {
                    color = Color.BLUE;
                } else if (string.contains("[notice]")) {
                    color = Color.GREEN;
                } else if (string.contains("[warning]")) {
                    color = Color.ORANGE;
                } else if (string.contains("[error]")) {
                    color = Color.RED;
                }
                this.setForeground(color);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class LogList
    extends JList {
        private int startIndex;

        LogList(ListModel listModel) {
            super(listModel);
            this.setVisibleRowCount(24);
            this.getSelectionModel().setSelectionMode(1);
            this.setAutoscrolls(true);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.startIndex = LogViewer.this.list.locationToIndex(mouseEvent.getPoint());
            }
            super.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                int n = LogViewer.this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    if (this.startIndex == -1) {
                        LogViewer.this.list.setSelectionInterval(n, n);
                        this.startIndex = n;
                    } else {
                        LogViewer.this.list.setSelectionInterval(this.startIndex, n);
                    }
                    LogViewer.this.list.ensureIndexIsVisible(n);
                    mouseEvent.consume();
                }
            } else {
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }

    private class ListHandler
    implements ListDataListener {
        private ListHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            LogViewer.this.scrollLaterIfRequired();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LogViewer.this.tail) {
                LogViewer.this.tailIsOn = !LogViewer.this.tailIsOn;
                jEdit.setBooleanProperty("log-viewer.tail", LogViewer.this.tailIsOn);
                if (LogViewer.this.tailIsOn) {
                    LogViewer.this.scrollToTail();
                }
            } else if (object == LogViewer.this.copy) {
                StringBuilder stringBuilder = new StringBuilder();
                Object[] objectArray = LogViewer.this.list.getSelectedValues();
                if (objectArray != null && objectArray.length != 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuilder.append(objectArray[i]);
                        stringBuilder.append('\n');
                    }
                } else {
                    ListModel listModel = LogViewer.this.list.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        stringBuilder.append(listModel.getElementAt(i));
                        stringBuilder.append('\n');
                    }
                }
                Registers.setRegister('$', stringBuilder.toString());
            }
        }
    }
}

