/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEditHistoryModelSaver
implements HistoryModelSaver {
    private static final String TO_ESCAPE = "\r\n\t\\\"'[]";
    private static File history;
    private static long historyModTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, HistoryModel> load(Map<String, HistoryModel> map) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return map;
        }
        history = new File(MiscUtilities.constructPath(string, "history"));
        if (!history.exists()) {
            return map;
        }
        historyModTime = history.lastModified();
        Log.log(3, HistoryModel.class, "Loading history");
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(history), Charset.forName("UTF-8").newDecoder()));
                    map.putAll(JEditHistoryModelSaver.loadFromReader(bufferedReader));
                }
                catch (CharacterCodingException characterCodingException) {
                    bufferedReader.close();
                    Log.log(3, HistoryModel.class, "Failed to load history with UTF-8. Fallbacking to the system default encoding.");
                    bufferedReader = new BufferedReader(new FileReader(history));
                    map.putAll(JEditHistoryModelSaver.loadFromReader(bufferedReader));
                }
                Object var6_7 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object var6_8 = null;
                IOUtilities.closeQuietly(bufferedReader);
                return map;
            }
            catch (IOException iOException) {
                Log.log(9, HistoryModel.class, iOException);
                Object var6_9 = null;
                IOUtilities.closeQuietly(bufferedReader);
                return map;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            IOUtilities.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtilities.closeQuietly(bufferedReader);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save(Map<String, HistoryModel> map) {
        File file;
        block8: {
            Log.log(3, HistoryModel.class, "Saving history");
            File file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#history#save#"));
            file = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "history"));
            if (file.exists() && file.lastModified() != historyModTime) {
                Log.log(7, HistoryModel.class, file + " changed on disk; will not save history");
                return false;
            }
            jEdit.backupSettingsFile(file);
            String string = System.getProperty("line.separator");
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                    if (map != null) {
                        Collection<HistoryModel> collection = map.values();
                        for (HistoryModel historyModel : collection) {
                            if (historyModel.getSize() == 0) continue;
                            bufferedWriter.write(91);
                            bufferedWriter.write(StandardUtilities.charsToEscapes(historyModel.getName(), TO_ESCAPE));
                            bufferedWriter.write(93);
                            bufferedWriter.write(string);
                            for (int i = 0; i < historyModel.getSize(); ++i) {
                                bufferedWriter.write(StandardUtilities.charsToEscapes(historyModel.getItem(i), TO_ESCAPE));
                                bufferedWriter.write(string);
                            }
                        }
                    }
                    bufferedWriter.close();
                    file.delete();
                    file2.renameTo(file);
                }
                catch (IOException iOException) {
                    Log.log(9, HistoryModel.class, iOException);
                    Object var11_12 = null;
                    IOUtilities.closeQuietly(bufferedWriter);
                    break block8;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                IOUtilities.closeQuietly(bufferedWriter);
                throw throwable;
            }
            IOUtilities.closeQuietly(bufferedWriter);
        }
        historyModTime = file.lastModified();
        return true;
    }

    private static Map<String, HistoryModel> loadFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        HashMap<String, HistoryModel> hashMap = new HashMap<String, HistoryModel>();
        HistoryModel historyModel = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                if (historyModel != null) {
                    hashMap.put(historyModel.getName(), historyModel);
                }
                String string2 = MiscUtilities.escapesToChars(string.substring(1, string.length() - 1));
                historyModel = new HistoryModel(string2);
                continue;
            }
            if (historyModel == null) {
                throw new IOException("History data starts before model name");
            }
            historyModel.addElement(MiscUtilities.escapesToChars(string));
        }
        if (historyModel != null) {
            hashMap.put(historyModel.getName(), historyModel);
        }
        return hashMap;
    }
}

