/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.gui.CheckBoxListModel;

public class JCheckBoxList
extends JTable {
    private TableCellRenderer dummy;

    public JCheckBoxList(Object[] objectArray) {
        this.setModel(objectArray);
    }

    public JCheckBoxList(Vector vector) {
        this.setModel(vector);
    }

    public void setModel(Object[] objectArray) {
        this.setModel(new CheckBoxListModel(objectArray));
        this.init();
    }

    public void setModel(Vector vector) {
        this.setModel(new CheckBoxListModel(vector));
        this.init();
    }

    public Object[] getCheckedValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < checkBoxListModel.items.size(); ++i) {
            Entry entry = checkBoxListModel.items.get(i);
            if (!entry.checked || entry.caption) continue;
            arrayList.add(entry.value);
        }
        Object[] objectArray = new Object[arrayList.size()];
        return arrayList.toArray(objectArray);
    }

    public void selectAll() {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < checkBoxListModel.items.size(); ++i) {
            Entry entry = checkBoxListModel.items.elementAt(i);
            if (entry.caption) continue;
            entry.checked = true;
        }
        checkBoxListModel.fireTableRowsUpdated(0, checkBoxListModel.getRowCount());
    }

    public Entry[] getValues() {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        Object[] objectArray = new Entry[checkBoxListModel.items.size()];
        checkBoxListModel.items.copyInto(objectArray);
        return objectArray;
    }

    public Object getSelectedValue() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getModel().getValueAt(n, 1);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 0) {
            Entry entry = ((CheckBoxListModel)this.getModel()).items.get(n);
            if (entry.caption) {
                return this.dummy;
            }
        }
        return super.getCellRenderer(n, n2);
    }

    private void init() {
        this.dummy = new DummyRenderer();
        this.getSelectionModel().setSelectionMode(0);
        this.setShowGrid(false);
        this.setAutoResizeMode(3);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        int n = new JCheckBox().getPreferredSize().width;
        tableColumn.setPreferredWidth(n);
        tableColumn.setMinWidth(n);
        tableColumn.setWidth(n);
        tableColumn.setMaxWidth(n);
        tableColumn.setResizable(false);
        tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new LabelRenderer());
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont = this.plainFont.deriveFont(1);

        LabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Entry entry = ((CheckBoxListModel)JCheckBoxList.this.getModel()).items.get(n);
            if (entry.caption) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.plainFont);
            }
            return this;
        }
    }

    private static class DummyRenderer
    extends DefaultTableCellRenderer {
        private DummyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, null, bl, false, n, n2);
        }
    }

    public static class Entry {
        boolean checked;
        boolean caption;
        Object value;

        public Entry(Object object) {
            this.caption = true;
            this.value = object;
        }

        public Entry(boolean bl, Object object) {
            this.checked = bl;
            this.value = object;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

