/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.gui.MutableListModel;

public class HistoryModel
extends DefaultListModel
implements MutableListModel {
    private static int max;
    private String name;
    private static Map<String, HistoryModel> models;
    private static boolean modified;
    private static HistoryModelSaver saver;

    public HistoryModel(String string) {
        this.name = string;
    }

    public void addItem(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = this.indexOf(string);
        if (n != -1) {
            this.removeElementAt(n);
        }
        this.insertElementAt(string, 0);
        while (this.getSize() > max) {
            this.removeElementAt(this.getSize() - 1);
        }
    }

    public void insertElementAt(Object object, int n) {
        modified = true;
        super.insertElementAt(object, n);
    }

    public String getItem(int n) {
        return (String)this.elementAt(n);
    }

    public boolean removeElement(Object object) {
        modified = true;
        return super.removeElement(object);
    }

    public void clear() {
        this.removeAllElements();
    }

    public void removeAllElements() {
        modified = true;
        super.removeAllElements();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String string) {
        HistoryModel historyModel;
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        if ((historyModel = models.get(string)) == null) {
            historyModel = new HistoryModel(string);
            models.put(string, historyModel);
        }
        return historyModel;
    }

    public static void loadHistory() {
        if (saver != null) {
            models = saver.load(models);
        }
    }

    public static void saveHistory() {
        if (saver != null && modified && saver.save(models)) {
            modified = false;
        }
    }

    public static void setMax(int n) {
        max = n;
    }

    public static void setSaver(HistoryModelSaver historyModelSaver) {
        saver = historyModelSaver;
    }
}

