/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowManagerImpl;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class FloatingWindowContainer
extends JFrame
implements DockableWindowContainer,
PropertyChangeListener {
    String dockableName = null;
    private final DockableWindowManagerImpl dockableWindowManager;
    private final boolean clone;
    private DockableWindowManagerImpl.Entry entry;
    private final JButton menu;

    public FloatingWindowContainer(DockableWindowManagerImpl dockableWindowManagerImpl, boolean bl) {
        this.dockableWindowManager = dockableWindowManagerImpl;
        dockableWindowManagerImpl.addPropertyChangeListener(this);
        this.clone = bl;
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.setDefaultCloseOperation(2);
        Box box = new Box(0);
        this.menu = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
        box.add(this.menu);
        this.menu.addMouseListener(new MouseHandler());
        this.menu.setToolTipText(jEdit.getProperty("docking.menu.label"));
        Box box2 = new Box(1);
        box2.add(Box.createVerticalStrut(3));
        box2.add(new JSeparator(0));
        box2.add(Box.createVerticalStrut(3));
        box.add(box2);
        this.getContentPane().add("North", box);
    }

    public void register(DockableWindowManagerImpl.Entry entry) {
        this.entry = entry;
        this.dockableName = entry.factory.name;
        this.setTitle(entry.shortTitle());
        this.getContentPane().add("Center", entry.win);
        this.pack();
        View view = this.dockableWindowManager.getView();
        GUIUtilities.loadGeometry(this, view, this.dockableName);
        GUIUtilities.addSizeSaver(this, view, this.dockableName);
        KeyListener keyListener = this.dockableWindowManager.closeListener(this.dockableName);
        this.addKeyListener(keyListener);
        this.getContentPane().addKeyListener(keyListener);
        this.menu.addKeyListener(keyListener);
        entry.win.addKeyListener(keyListener);
        this.setVisible(true);
        if (!entry.win.isVisible()) {
            entry.win.setVisible(true);
        }
    }

    public void remove(DockableWindowManagerImpl.Entry entry) {
        this.dispose();
    }

    public void unregister(DockableWindowManagerImpl.Entry entry) {
        this.entry = null;
        entry.btn = null;
        entry.container = null;
        super.dispose();
    }

    public void show(final DockableWindowManagerImpl.Entry entry) {
        if (entry == null) {
            this.dispose();
        } else {
            this.setTitle(entry.longTitle());
            this.toFront();
            this.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (entry.win instanceof DefaultFocusComponent) {
                        ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
                    } else {
                        entry.win.requestFocus();
                    }
                }
            });
        }
    }

    public boolean isVisible(DockableWindowManagerImpl.Entry entry) {
        return true;
    }

    public void dispose() {
        this.entry.container = null;
        this.entry.win = null;
        super.dispose();
    }

    public DockableWindowManagerImpl getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.dockableName == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.startsWith(this.dockableName) && string.endsWith("title")) {
            this.setTitle(propertyChangeEvent.getNewValue().toString());
        }
    }

    class MouseHandler
    extends MouseAdapter {
        JPopupMenu popup;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.popup != null && this.popup.isVisible()) {
                this.popup.setVisible(false);
            } else {
                this.popup = FloatingWindowContainer.this.dockableWindowManager.createPopupMenu(FloatingWindowContainer.this, ((FloatingWindowContainer)FloatingWindowContainer.this).entry.factory.name, FloatingWindowContainer.this.clone);
                GUIUtilities.showPopupMenu(this.popup, FloatingWindowContainer.this.menu, FloatingWindowContainer.this.menu.getX(), FloatingWindowContainer.this.menu.getY() + FloatingWindowContainer.this.menu.getHeight(), false);
            }
        }
    }
}

