/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorListDialog
extends EnhancedDialog {
    private JButton ok;
    private JButton pluginMgr;

    public ErrorListDialog(Frame frame, String string, String string2, Vector<ErrorEntry> vector, boolean bl) {
        super(frame, string, !bl);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string2);
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setForeground(jEdit.getColorProperty("view.fgColor"));
        jTextPane.setBackground(jEdit.getColorProperty("view.bgColor"));
        jTextPane.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        jTextPane.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        Font font = new JLabel().getFont();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        SimpleAttributeSet simpleAttributeSet2 = (SimpleAttributeSet)simpleAttributeSet.clone();
        StyleConstants.setBold(simpleAttributeSet2, true);
        for (ErrorEntry object2 : vector) {
            try {
                styledDocument.insertString(styledDocument.getLength(), object2.path + ":\n", simpleAttributeSet2);
                for (String string3 : object2.messages) {
                    styledDocument.insertString(styledDocument.getLength(), string3 + "\n", simpleAttributeSet);
                }
            }
            catch (BadLocationException badLocationException) {
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jTextPane, 22, 32);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = Math.min(dimension.width, 400);
        jScrollPane.setPreferredSize(dimension);
        jPanel2.add("Center", jScrollPane);
        jPanel.add("Center", jPanel2);
        Box badLocationException = new Box(0);
        badLocationException.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        if (bl) {
            this.pluginMgr = new JButton(jEdit.getProperty("error-list.plugin-manager"));
            this.pluginMgr.addActionListener(new ActionHandler());
            badLocationException.add(this.pluginMgr);
            badLocationException.add(Box.createHorizontalStrut(6));
        }
        badLocationException.add(this.ok);
        badLocationException.add(Box.createGlue());
        jPanel.add("South", badLocationException);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ErrorListDialog.this.ok) {
                ErrorListDialog.this.dispose();
            } else if (actionEvent.getSource() == ErrorListDialog.this.pluginMgr) {
                PluginManager.showPluginManager(JOptionPane.getFrameForComponent(ErrorListDialog.this));
            }
        }
    }

    public static class ErrorEntry {
        String path;
        String[] messages;

        public ErrorEntry(String string, String string2, Object[] objectArray) {
            this.path = string;
            String string3 = jEdit.getProperty(string2, objectArray);
            if (string3 == null) {
                string3 = "Undefined property: " + string2;
            }
            Log.log(9, this, string + ":");
            Log.log(9, this, string3);
            Vector<String> vector = new Vector<String>();
            int n = -1;
            for (int i = 0; i < string3.length(); ++i) {
                if (string3.charAt(i) != '\n') continue;
                vector.addElement(string3.substring(n + 1, i));
                n = i;
            }
            if (n != string3.length()) {
                vector.addElement(string3.substring(n + 1));
            }
            this.messages = new String[vector.size()];
            vector.copyInto(this.messages);
        }

        public boolean equals(Object object) {
            if (object instanceof ErrorEntry) {
                ErrorEntry errorEntry = (ErrorEntry)object;
                return errorEntry.path.equals(this.path);
            }
            return false;
        }

        public String toString() {
            return this.path + ":\n" + TextUtilities.join(Arrays.asList(this.messages), "\n");
        }
    }
}

