/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.AbbrevEditor;
import org.gjt.sp.jedit.jEdit;

public class EditAbbrevDialog
extends JDialog {
    private AbbrevEditor editor;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;
    private String originalAbbrev;
    private Map abbrevs;

    public EditAbbrevDialog(Frame frame, String string, String string2, Map map) {
        super(frame, jEdit.getProperty("edit-abbrev.title"), true);
        this.init(string, string2, map);
    }

    public EditAbbrevDialog(Dialog dialog, String string, String string2, Map map) {
        super(dialog, jEdit.getProperty("edit-abbrev.title"), true);
        this.init(string, string2, map);
    }

    public String getAbbrev() {
        if (!this.isOK) {
            return null;
        }
        return this.editor.getAbbrev();
    }

    public String getExpansion() {
        if (!this.isOK) {
            return null;
        }
        return this.editor.getExpansion();
    }

    private void init(String string, String string2, Map map) {
        this.abbrevs = map;
        this.originalAbbrev = string;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.editor = new AbbrevEditor();
        this.editor.setAbbrev(string);
        this.editor.setExpansion(string2);
        this.editor.setBorder(new EmptyBorder(0, 0, 12, 0));
        jPanel.add("Center", this.editor);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        box.add(this.cancel);
        box.add(Box.createGlue());
        jPanel.add("South", box);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        this.editor.getBeforeCaretTextArea().addKeyListener(keyHandler);
        this.editor.getAfterCaretTextArea().addKeyListener(keyHandler);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private boolean checkForExistingAbbrev() {
        String string = this.editor.getAbbrev();
        if (this.abbrevs.get(string) != null) {
            if (string.equals(this.originalAbbrev)) {
                return true;
            }
            int n = GUIUtilities.confirm(this, "edit-abbrev.duplicate", null, 0, 2);
            return n == 0;
        }
        return true;
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                EditAbbrevDialog.this.dispose();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == EditAbbrevDialog.this.ok) {
                if (EditAbbrevDialog.this.editor.getAbbrev() == null || EditAbbrevDialog.this.editor.getAbbrev().length() == 0) {
                    EditAbbrevDialog.this.getToolkit().beep();
                    return;
                }
                if (!EditAbbrevDialog.this.checkForExistingAbbrev()) {
                    return;
                }
                EditAbbrevDialog.this.isOK = true;
            }
            EditAbbrevDialog.this.dispose();
        }
    }
}

