/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableLayout;
import org.gjt.sp.jedit.gui.DockablePanel;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.PanelWindowContainer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockableWindowManagerImpl
extends DockableWindowManager {
    private Map<String, Entry> windows;
    private PanelWindowContainer left;
    private PanelWindowContainer right;
    private PanelWindowContainer top;
    private PanelWindowContainer bottom;
    private List<Entry> clones;
    private Entry lastEntry;
    public Stack<String> showStack = new Stack();
    int resizePos;
    Rectangle resizeRect;
    private boolean continuousLayout;

    @Override
    public void setDockingLayout(DockableWindowManager.DockingLayout dockingLayout) {
        DockableWindowConfig dockableWindowConfig = (DockableWindowConfig)dockingLayout;
        if (dockableWindowConfig == null) {
            return;
        }
        if (dockableWindowConfig.top != null && dockableWindowConfig.top.length() != 0) {
            this.showDockableWindow(dockableWindowConfig.top);
        }
        if (dockableWindowConfig.left != null && dockableWindowConfig.left.length() != 0) {
            this.showDockableWindow(dockableWindowConfig.left);
        }
        if (dockableWindowConfig.bottom != null && dockableWindowConfig.bottom.length() != 0) {
            this.showDockableWindow(dockableWindowConfig.bottom);
        }
        if (dockableWindowConfig.right != null && dockableWindowConfig.right.length() != 0) {
            this.showDockableWindow(dockableWindowConfig.right);
        }
    }

    @Override
    public DockableWindowManager.DockingLayout getDockingLayout(View.ViewConfig viewConfig) {
        DockableWindowConfig dockableWindowConfig = new DockableWindowConfig();
        dockableWindowConfig.top = this.getTopDockingArea().getCurrent();
        dockableWindowConfig.left = this.getLeftDockingArea().getCurrent();
        dockableWindowConfig.bottom = this.getBottomDockingArea().getCurrent();
        dockableWindowConfig.right = this.getRightDockingArea().getCurrent();
        dockableWindowConfig.topPos = this.getTopDockingArea().getDimension();
        dockableWindowConfig.leftPos = this.getLeftDockingArea().getDimension();
        dockableWindowConfig.bottomPos = this.getBottomDockingArea().getDimension();
        dockableWindowConfig.rightPos = this.getRightDockingArea().getDimension();
        return dockableWindowConfig;
    }

    public DockableWindowManagerImpl(View view, DockableWindowFactory dockableWindowFactory, View.ViewConfig viewConfig) {
        super(view, dockableWindowFactory, viewConfig);
        this.setLayout(new DockableLayout());
        this.windows = new HashMap<String, Entry>();
        this.clones = new ArrayList<Entry>();
        DockableWindowConfig dockableWindowConfig = (DockableWindowConfig)viewConfig.docking;
        if (dockableWindowConfig == null) {
            dockableWindowConfig = new DockableWindowConfig();
        }
        this.top = new PanelWindowContainer(this, "top", dockableWindowConfig.topPos);
        this.left = new PanelWindowContainer(this, "left", dockableWindowConfig.leftPos);
        this.bottom = new PanelWindowContainer(this, "bottom", dockableWindowConfig.bottomPos);
        this.right = new PanelWindowContainer(this, "right", dockableWindowConfig.rightPos);
        this.add("top-buttons", this.top.buttonPanel);
        this.add("left-buttons", this.left.buttonPanel);
        this.add("bottom-buttons", this.bottom.buttonPanel);
        this.add("right-buttons", this.right.buttonPanel);
        this.add("top", this.top.dockablePanel);
        this.add("left", this.left.dockablePanel);
        this.add("bottom", this.bottom.dockablePanel);
        this.add("right", this.right.dockablePanel);
    }

    @Override
    public void setMainPanel(JPanel jPanel) {
        this.add((Component)jPanel, 0);
    }

    @Override
    public void init() {
        super.init();
        Iterator<DockableWindowFactory.Window> iterator = this.factory.getDockableWindowIterator();
        while (iterator.hasNext()) {
            this.addEntry(iterator.next());
        }
        this.propertiesChanged();
    }

    @Override
    public JComponent floatDockableWindow(String string) {
        Entry entry = this.windows.get(string);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return null;
        }
        Entry entry2 = new Entry(entry.factory, "floating");
        entry2.win = entry2.factory.createDockableWindow(this.view, "floating");
        if (entry2.win != null) {
            FloatingWindowContainer floatingWindowContainer = new FloatingWindowContainer(this, true);
            entry2.container = floatingWindowContainer;
            entry2.container.register(entry2);
            entry2.container.show(entry2);
        }
        this.clones.add(entry2);
        return entry2.win;
    }

    @Override
    public void showDockableWindow(String string) {
        this.lastEntry = this.windows.get(string);
        if (this.lastEntry == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return;
        }
        if (this.lastEntry.win == null) {
            this.lastEntry.win = this.lastEntry.factory.createDockableWindow(this.view, this.lastEntry.position);
        }
        if (this.lastEntry.win != null) {
            Object object;
            if (this.lastEntry.position.equals("floating") && this.lastEntry.container == null) {
                this.lastEntry.container = object = new FloatingWindowContainer(this, this.view.isPlainView());
                this.lastEntry.container.register(this.lastEntry);
            }
            this.showStack.push(string);
            this.lastEntry.container.show(this.lastEntry);
            object = DockableWindowUpdate.ACTIVATED;
            EditBus.send(new DockableWindowUpdate(this, object, string));
        }
    }

    @Override
    public void hideDockableWindow(String string) {
        Entry entry = this.windows.get(string);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return;
        }
        if (entry.win == null) {
            return;
        }
        entry.container.show(null);
    }

    @Override
    public JComponent getDockable(String string) {
        Entry entry = this.windows.get(string);
        if (entry == null || entry.win == null) {
            return null;
        }
        return entry.win;
    }

    @Override
    public boolean isDockableWindowVisible(String string) {
        Entry entry = this.windows.get(string);
        if (entry == null || entry.win == null) {
            return false;
        }
        return entry.container.isVisible(entry);
    }

    @Override
    public boolean isDockableWindowDocked(String string) {
        Entry entry = this.windows.get(string);
        if (entry == null) {
            return false;
        }
        return !entry.position.equals("floating");
    }

    @Override
    public void closeCurrentArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    String string = DockableWindowManagerImpl.this.showStack.pop();
                    DockableWindowManagerImpl.this.hideDockableWindow(string);
                    return;
                }
                catch (Exception exception) {
                    for (Component component = DockableWindowManagerImpl.this.view.getFocusOwner(); component != null; component = component.getParent()) {
                        if (!(component instanceof DockablePanel)) continue;
                        DockablePanel dockablePanel = (DockablePanel)component;
                        PanelWindowContainer panelWindowContainer = dockablePanel.getWindowContainer();
                        panelWindowContainer.show((Entry)null);
                        return;
                    }
                    DockableWindowManagerImpl.this.getToolkit().beep();
                    return;
                }
            }
        });
    }

    @Override
    public void close() {
        super.close();
        for (Entry entry : this.windows.values()) {
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
        for (Entry entry : this.clones) {
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
    }

    @Override
    public PanelWindowContainer getTopDockingArea() {
        return this.top;
    }

    @Override
    public PanelWindowContainer getLeftDockingArea() {
        return this.left;
    }

    @Override
    public PanelWindowContainer getBottomDockingArea() {
        return this.bottom;
    }

    @Override
    public PanelWindowContainer getRightDockingArea() {
        return this.right;
    }

    public JPopupMenu createPopupMenu(final DockableWindowContainer dockableWindowContainer, final String string, final boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (string == null && dockableWindowContainer instanceof PanelWindowContainer) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DockableWindowManagerImpl.this.showDockableWindow(actionEvent.getActionCommand());
                }
            };
            String[] stringArray = ((PanelWindowContainer)dockableWindowContainer).getDockables();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String object = stringArray[i];
                treeMap.put(this.getDockableTitle(object), object);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                JMenuItem jMenuItem = new JMenuItem((String)entry.getKey());
                jMenuItem.setActionCommand((String)entry.getValue());
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
            }
        } else {
            String[] stringArray;
            JMenuItem jMenuItem = new JMenuItem(this.getDockableTitle(string));
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            String string2 = jEdit.getProperty(string + ".dock-position", "floating");
            if (!bl) {
                stringArray = new String[]{"floating", "top", "left", "bottom", "right"};
                for (int i = 0; i < stringArray.length; ++i) {
                    final String string3 = stringArray[i];
                    if (string3.equals(string2)) continue;
                    JMenuItem jMenuItem2 = new JMenuItem(jEdit.getProperty("view.docking.menu-" + string3));
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jEdit.setProperty(string + ".dock-position", string3);
                            EditBus.send(new DockableWindowUpdate(DockableWindowManagerImpl.this, DockableWindowUpdate.PROPERTIES_CHANGED, string));
                            DockableWindowManagerImpl.this.showDockableWindow(string);
                        }
                    });
                    jPopupMenu.add(jMenuItem2);
                }
                jPopupMenu.addSeparator();
            }
            stringArray = new JMenuItem(jEdit.getProperty("view.docking.menu-clone"));
            stringArray.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DockableWindowManagerImpl.this.floatDockableWindow(string);
                }
            });
            jPopupMenu.add((JMenuItem)stringArray);
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("view.docking.menu-close"));
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl) {
                        ((FloatingWindowContainer)dockableWindowContainer).dispose();
                    } else {
                        DockableWindowManagerImpl.this.removeDockableWindow(string);
                    }
                }
            });
            jPopupMenu.add(jMenuItem3);
            if (!bl && !string2.equals("floating")) {
                JMenuItem jMenuItem4 = new JMenuItem(jEdit.getProperty("view.docking.menu-undock"));
                jMenuItem4.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jEdit.setProperty(string + ".dock-position", "floating");
                        EditBus.send(new DockableWindowUpdate(DockableWindowManagerImpl.this, DockableWindowUpdate.PROPERTIES_CHANGED, string));
                        Entry entry = (Entry)DockableWindowManagerImpl.this.windows.get(string);
                        if (entry == null) {
                            Log.log(9, this, "Unknown dockable window: " + string);
                        } else {
                            entry.win = null;
                        }
                    }
                });
                jPopupMenu.add(jMenuItem4);
            }
        }
        return jPopupMenu;
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.resizeRect != null) {
            graphics.setColor(Color.darkGray);
            graphics.fillRect(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
        }
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        block10: {
            block11: {
                block9: {
                    if (!(eBMessage instanceof DockableWindowUpdate)) break block9;
                    if (((DockableWindowUpdate)eBMessage).getWhat() != DockableWindowUpdate.PROPERTIES_CHANGED) break block10;
                    this.propertiesChanged();
                    break block10;
                }
                if (!(eBMessage instanceof PropertiesChanged)) break block11;
                this.propertiesChanged();
                break block10;
            }
            if (!(eBMessage instanceof PluginUpdate)) break block10;
            PluginUpdate pluginUpdate = (PluginUpdate)eBMessage;
            if (pluginUpdate.getWhat() == PluginUpdate.LOADED) {
                Iterator<DockableWindowFactory.Window> iterator = this.factory.getDockableWindowIterator();
                while (iterator.hasNext()) {
                    DockableWindowFactory.Window window = iterator.next();
                    if (window.plugin != pluginUpdate.getPluginJAR()) continue;
                    this.addEntry(window);
                }
                this.propertiesChanged();
            } else if (!pluginUpdate.isExiting()) {
                if (pluginUpdate.getWhat() == PluginUpdate.DEACTIVATED) {
                    Iterator<Entry> iterator = this.getAllPluginEntries(pluginUpdate.getPluginJAR(), false);
                    while (iterator.hasNext()) {
                        Entry entry = iterator.next();
                        if (entry.container == null) continue;
                        entry.container.remove(entry);
                    }
                } else if (pluginUpdate.getWhat() == PluginUpdate.UNLOADED) {
                    Iterator<Entry> iterator = this.getAllPluginEntries(pluginUpdate.getPluginJAR(), true);
                    while (iterator.hasNext()) {
                        Entry entry = iterator.next();
                        if (entry.container == null) continue;
                        entry.container.unregister(entry);
                        entry.win = null;
                        entry.container = null;
                    }
                }
            }
        }
    }

    void setResizePos(int n, PanelWindowContainer panelWindowContainer) {
        this.resizePos = n;
        if (n < 0) {
            n = 0;
        }
        if (this.continuousLayout) {
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, 8, 8);
        if (panelWindowContainer == this.top) {
            n = Math.min(n, this.getHeight() - this.top.buttonPanel.getHeight() - this.bottom.dockablePanel.getHeight() - this.bottom.buttonPanel.getHeight() - 10);
            rectangle.x = this.top.dockablePanel.getX() + 1;
            rectangle.y = n + this.top.buttonPanel.getHeight() + 1;
            rectangle.width = this.top.dockablePanel.getWidth() - 2;
        } else if (panelWindowContainer == this.left) {
            n = Math.min(n, this.getWidth() - this.left.buttonPanel.getWidth() - this.right.dockablePanel.getWidth() - this.right.buttonPanel.getWidth() - 10);
            rectangle.x = n + this.left.buttonPanel.getWidth() + 1;
            rectangle.y = this.left.dockablePanel.getY() + 1;
            rectangle.height = this.left.dockablePanel.getHeight() - 2;
        } else if (panelWindowContainer == this.bottom) {
            n = Math.min(n, this.getHeight() - this.bottom.buttonPanel.getHeight() - this.top.dockablePanel.getHeight() - this.top.buttonPanel.getHeight() - 10);
            rectangle.x = this.bottom.dockablePanel.getX() + 1;
            rectangle.y = this.getHeight() - this.bottom.buttonPanel.getHeight() - n - 10 + 2;
            rectangle.width = this.bottom.dockablePanel.getWidth() - 2;
        } else if (panelWindowContainer == this.right) {
            n = Math.min(n, this.getWidth() - this.right.buttonPanel.getWidth() - this.left.dockablePanel.getWidth() - this.left.buttonPanel.getWidth() - 10);
            rectangle.x = this.getWidth() - this.right.buttonPanel.getWidth() - n - 10 + 1;
            rectangle.y = this.right.dockablePanel.getY() + 1;
            rectangle.height = this.right.dockablePanel.getHeight() - 2;
        }
        Rectangle rectangle2 = this.resizeRect == null ? rectangle : this.resizeRect.union(rectangle);
        this.resizeRect = rectangle;
        this.repaint(rectangle2);
    }

    void finishResizing() {
        this.resizeRect = null;
        this.repaint();
    }

    @Override
    protected void propertiesChanged() {
        if (this.view.isPlainView()) {
            return;
        }
        ((DockableLayout)this.getLayout()).setAlternateLayout(jEdit.getBooleanProperty("view.docking.alternateLayout"));
        String[] stringArray = this.factory.getRegisteredDockableWindows();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Entry entry = this.windows.get(string);
            String string2 = jEdit.getProperty(string + ".dock-position", "floating");
            if (string2.equals(entry.position)) continue;
            entry.position = string2;
            if (entry.container != null) {
                entry.container.unregister(entry);
                entry.container = null;
                if (entry.factory.movable && !string2.equals("floating")) {
                    if (entry.win instanceof DockableWindow) {
                        ((DockableWindow)((Object)entry.win)).move(string2);
                    }
                } else {
                    entry.win = null;
                }
            }
            if (string2.equals("floating")) continue;
            if (string2.equals("top")) {
                entry.container = this.top;
            } else if (string2.equals("left")) {
                entry.container = this.left;
            } else if (string2.equals("bottom")) {
                entry.container = this.bottom;
            } else if (string2.equals("right")) {
                entry.container = this.right;
            } else {
                Log.log(7, this, "Unknown position: " + string2);
                continue;
            }
            entry.container.register(entry);
        }
        this.top.sortDockables();
        this.left.sortDockables();
        this.bottom.sortDockables();
        this.right.sortDockables();
        this.continuousLayout = jEdit.getBooleanProperty("appearance.continuousLayout");
        this.revalidate();
        this.repaint();
    }

    private void addEntry(DockableWindowFactory.Window window) {
        Entry entry;
        if (this.view.isPlainView()) {
            entry = new Entry(window, "floating");
        } else {
            entry = new Entry(window);
            if (!entry.position.equals("floating")) {
                if (entry.position.equals("top")) {
                    entry.container = this.top;
                } else if (entry.position.equals("left")) {
                    entry.container = this.left;
                } else if (entry.position.equals("bottom")) {
                    entry.container = this.bottom;
                } else if (entry.position.equals("right")) {
                    entry.container = this.right;
                } else {
                    Log.log(7, this, "Unknown position: " + entry.position);
                }
            }
            if (entry.container != null) {
                entry.container.register(entry);
            }
        }
        this.windows.put(window.name, entry);
    }

    private Iterator<Entry> getAllPluginEntries(PluginJAR pluginJAR, boolean bl) {
        Entry entry;
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        Iterator<Entry> iterator = this.windows.values().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.factory.plugin != pluginJAR) continue;
            linkedList.add(entry);
            if (!bl) continue;
            iterator.remove();
        }
        iterator = this.clones.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.factory.plugin != pluginJAR) continue;
            linkedList.add(entry);
            iterator.remove();
        }
        return linkedList.iterator();
    }

    @Override
    public void disposeDockableWindow(String string) {
    }

    class Entry {
        DockableWindowFactory.Window factory;
        String position;
        DockableWindowContainer container;
        JComponent win;
        AbstractButton btn;

        Entry(DockableWindowFactory.Window window) {
            this(window, jEdit.getProperty(window.name + ".dock-position", "floating"));
        }

        public String longTitle() {
            String string = jEdit.getProperty(this.factory.name + ".longtitle");
            if (string == null) {
                return this.shortTitle();
            }
            return string;
        }

        public String shortTitle() {
            String string = jEdit.getProperty(this.factory.name + ".title");
            if (string == null) {
                return "NO TITLE PROPERTY: " + this.factory.name;
            }
            return string;
        }

        public String label() {
            String string = jEdit.getProperty(this.factory.name + ".label");
            string = string.replaceAll("\\$", "");
            return string;
        }

        Entry(DockableWindowFactory.Window window, String string) {
            this.factory = window;
            this.position = string;
        }
    }

    public static class DockableWindowConfig
    extends DockableWindowManager.DockingLayout {
        public String top;
        public String left;
        public String bottom;
        public String right;
        public int topPos;
        public int leftPos;
        public int bottomPos;
        public int rightPos;

        public DefaultHandler getPerspectiveHandler() {
            return new PerspectiveHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean saveLayout(String string, int n) {
            String string2 = System.getProperty("line.separator");
            String string3 = this.getLayoutFilename(string, n);
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(string3));
                    bufferedWriter.write("<DOCKING LEFT=\"");
                    bufferedWriter.write(this.left == null ? "" : this.left);
                    bufferedWriter.write("\" TOP=\"");
                    bufferedWriter.write(this.top == null ? "" : this.top);
                    bufferedWriter.write("\" RIGHT=\"");
                    bufferedWriter.write(this.right == null ? "" : this.right);
                    bufferedWriter.write("\" BOTTOM=\"");
                    bufferedWriter.write(this.bottom == null ? "" : this.bottom);
                    bufferedWriter.write("\" LEFT_POS=\"");
                    bufferedWriter.write(String.valueOf(this.leftPos));
                    bufferedWriter.write("\" TOP_POS=\"");
                    bufferedWriter.write(String.valueOf(this.topPos));
                    bufferedWriter.write("\" RIGHT_POS=\"");
                    bufferedWriter.write(String.valueOf(this.rightPos));
                    bufferedWriter.write("\" BOTTOM_POS=\"");
                    bufferedWriter.write(String.valueOf(this.bottomPos));
                    bufferedWriter.write("\" />");
                    bufferedWriter.write(string2);
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException, iOException);
                    boolean bl = false;
                    Object var9_7 = null;
                    IOUtilities.closeQuietly(bufferedWriter);
                    return bl;
                }
                Object var9_6 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                IOUtilities.closeQuietly(bufferedWriter);
                throw throwable;
            }
            IOUtilities.closeQuietly(bufferedWriter);
            return true;
        }

        public boolean loadLayout(String string, int n) {
            String string2 = this.getLayoutFilename(string, n);
            DefaultHandler defaultHandler = this.getPerspectiveHandler();
            try {
                XMLUtilities.parseXML(new FileInputStream(string2), defaultHandler);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }

        public String getName() {
            return "DockableWindowManager";
        }

        public class PerspectiveHandler
        extends DefaultHandler {
            public void startElement(String string, String string2, String string3, Attributes attributes) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.attribute(attributes.getQName(i), attributes.getValue(i));
                }
            }

            private void attribute(String string, String string2) {
                if (string.equals("TOP")) {
                    DockableWindowConfig.this.top = string2;
                } else if (string.equals("LEFT")) {
                    DockableWindowConfig.this.left = string2;
                } else if (string.equals("BOTTOM")) {
                    DockableWindowConfig.this.bottom = string2;
                } else if (string.equals("RIGHT")) {
                    DockableWindowConfig.this.right = string2;
                } else if (string.equals("TOP_POS")) {
                    DockableWindowConfig.this.topPos = Integer.parseInt(string2);
                } else if (string.equals("LEFT_POS")) {
                    DockableWindowConfig.this.leftPos = Integer.parseInt(string2);
                } else if (string.equals("BOTTOM_POS")) {
                    DockableWindowConfig.this.bottomPos = Integer.parseInt(string2);
                } else if (string.equals("RIGHT_POS")) {
                    DockableWindowConfig.this.rightPos = Integer.parseInt(string2);
                }
            }
        }
    }
}

