/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockableWindowFactory {
    private static DockableWindowFactory instance;
    private final Map<String, Window> dockableWindowFactories = new HashMap<String, Window>();

    public static synchronized DockableWindowFactory getInstance() {
        if (instance == null) {
            instance = new DockableWindowFactory();
        }
        return instance;
    }

    public void loadDockableWindows(PluginJAR pluginJAR, URL uRL, PluginJAR.PluginCacheEntry pluginCacheEntry) {
        try {
            Log.log(1, DockableWindowManager.class, "Loading dockables from " + uRL);
            DockableListHandler dockableListHandler = new DockableListHandler(pluginJAR, uRL);
            boolean bl = XMLUtilities.parseXML(uRL.openStream(), dockableListHandler);
            if (!bl && pluginCacheEntry != null) {
                pluginCacheEntry.cachedDockableNames = dockableListHandler.getCachedDockableNames();
                pluginCacheEntry.cachedDockableActionFlags = dockableListHandler.getCachedDockableActionFlags();
                pluginCacheEntry.cachedDockableMovableFlags = dockableListHandler.getCachedDockableMovableFlags();
            }
        }
        catch (IOException iOException) {
            Log.log(9, DockableWindowManager.class, iOException);
        }
    }

    public void unloadDockableWindows(PluginJAR pluginJAR) {
        Iterator<Map.Entry<String, Window>> iterator = this.dockableWindowFactories.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Window> entry = iterator.next();
            Window window = entry.getValue();
            if (window.plugin != pluginJAR) continue;
            iterator.remove();
        }
    }

    public void cacheDockableWindows(PluginJAR pluginJAR, String[] stringArray, boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            Window window = new Window(pluginJAR, stringArray[i], null, blArray[i], blArray2[i]);
            this.dockableWindowFactories.put(stringArray[i], window);
        }
    }

    public void registerDockableWindow(PluginJAR pluginJAR, String string, String string2, boolean bl, boolean bl2) {
        Window window = this.dockableWindowFactories.get(string);
        if (window != null) {
            window.code = string2;
            window.loaded = true;
        } else {
            window = new Window(pluginJAR, string, string2, bl, bl2);
            this.dockableWindowFactories.put(string, window);
        }
    }

    public String[] getRegisteredDockableWindows() {
        String[] stringArray = new String[this.dockableWindowFactories.size()];
        Iterator<Window> iterator = this.dockableWindowFactories.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Window window = iterator.next();
            stringArray[n++] = window.name;
        }
        return stringArray;
    }

    public Window getDockableWindowFactory(String string) {
        return this.dockableWindowFactories.get(string);
    }

    public String getDockableWindowPluginClass(String string) {
        Window window = this.getDockableWindowFactory(string);
        if (window == null || window.plugin == null || window.plugin.getPlugin() == null) {
            return null;
        }
        return window.plugin.getPlugin().getClassName();
    }

    Iterator<Window> getDockableWindowIterator() {
        return this.dockableWindowFactories.values().iterator();
    }

    class Window {
        PluginJAR plugin;
        String name;
        String code;
        boolean loaded;
        boolean movable;
        boolean isBeingCreated = false;

        Window(PluginJAR pluginJAR, String string, String string2, boolean bl, boolean bl2) {
            this.plugin = pluginJAR;
            this.name = string;
            this.code = string2;
            this.movable = bl2;
            if (string2 != null) {
                this.loaded = true;
            }
            if (bl) {
                ActionSet actionSet = pluginJAR == null ? jEdit.getBuiltInActionSet() : pluginJAR.getActionSet();
                actionSet.addAction(new OpenAction(string));
                actionSet.addAction(new ToggleAction(string));
                actionSet.addAction(new FloatAction(string));
                String string3 = jEdit.getProperty(string + ".label");
                if (string3 == null) {
                    string3 = "NO LABEL PROPERTY: " + string;
                }
                Object[] objectArray = new String[]{string3};
                jEdit.setTemporaryProperty(string + ".label", string3);
                jEdit.setTemporaryProperty(string + "-toggle.label", jEdit.getProperty("view.docking.toggle.label", objectArray));
                jEdit.setTemporaryProperty(string + "-toggle.toggle", "true");
                jEdit.setTemporaryProperty(string + "-float.label", jEdit.getProperty("view.docking.float.label", objectArray));
            }
        }

        void load() {
            if (this.loaded) {
                return;
            }
            DockableWindowFactory.this.loadDockableWindows(this.plugin, this.plugin.getDockablesURI(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JComponent createDockableWindow(View view, String string) {
            Object object = this;
            synchronized (object) {
                if (this.isBeingCreated) {
                    return null;
                }
                this.isBeingCreated = true;
            }
            this.load();
            if (!this.loaded) {
                Log.log(7, this, "Outdated cache");
                return null;
            }
            object = new NameSpace(BeanShell.getNameSpace(), "DockableWindowManager.Factory.createDockableWindow()");
            try {
                ((NameSpace)object).setVariable("position", string);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, this, utilEvalError);
            }
            JComponent jComponent = (JComponent)BeanShell.eval(view, (NameSpace)object, this.code);
            Window window = this;
            synchronized (window) {
                this.isBeingCreated = false;
            }
            return jComponent;
        }

        class FloatAction
        extends EditAction {
            private String dockable;

            FloatAction(String string) {
                super(string + "-float");
                this.dockable = string;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().floatDockableWindow(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().floatDockableWindow(\"" + this.dockable + "\");";
            }
        }

        class ToggleAction
        extends EditAction {
            private String dockable;

            ToggleAction(String string) {
                super(string + "-toggle");
                this.dockable = string;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().toggleDockableWindow(this.dockable);
            }

            public boolean isSelected(View view) {
                return view.getDockableWindowManager().isDockableWindowVisible(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().toggleDockableWindow(\"" + this.dockable + "\");";
            }
        }

        class OpenAction
        extends EditAction {
            private String dockable;

            OpenAction(String string) {
                super(string);
                this.dockable = string;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().showDockableWindow(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().showDockableWindow(\"" + this.dockable + "\");";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DockableListHandler
    extends DefaultHandler {
        private PluginJAR plugin;
        private URL uri;
        private List<String> cachedDockableNames;
        private List<Boolean> cachedDockableActionFlags;
        private List<Boolean> cachedDockableMovableFlags;
        private String dockableName;
        private StringBuilder code;
        private boolean actions;
        private boolean movable;
        final boolean MOVABLE_DEFAULT = false;
        private Stack<String> stateStack;

        DockableListHandler(PluginJAR pluginJAR, URL uRL) {
            this.plugin = pluginJAR;
            this.uri = uRL;
            this.stateStack = new Stack();
            this.actions = true;
            this.movable = false;
            this.code = new StringBuilder();
            this.cachedDockableNames = new LinkedList<String>();
            this.cachedDockableActionFlags = new LinkedList<Boolean>();
            this.cachedDockableMovableFlags = new LinkedList<Boolean>();
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            return XMLUtilities.findEntity(string2, "dockables.dtd", MiscUtilities.class);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = this.peekElement();
            if (string.equals("DOCKABLE")) {
                this.code.append(cArray, n, n2);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            String string4 = this.pushElement(string3);
            if (string4.equals("DOCKABLE")) {
                this.dockableName = attributes.getValue("NAME");
                this.actions = "FALSE".equals(attributes.getValue("NO_ACTIONS"));
                String string5 = attributes.getValue("MOVABLE");
                if (string5 != null) {
                    this.movable = string5.equalsIgnoreCase("TRUE");
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3 == null) {
                return;
            }
            String string4 = this.peekElement();
            if (string3.equals(string4)) {
                if (string4.equals("DOCKABLE")) {
                    DockableWindowFactory.this.registerDockableWindow(this.plugin, this.dockableName, this.code.toString(), this.actions, this.movable);
                    this.cachedDockableNames.add(this.dockableName);
                    this.cachedDockableActionFlags.add(this.actions);
                    this.cachedDockableMovableFlags.add(this.movable);
                    this.actions = true;
                    this.movable = false;
                    this.code.setLength(0);
                }
            } else {
                throw new InternalError();
            }
            this.popElement();
        }

        @Override
        public void startDocument() {
            try {
                this.pushElement(null);
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
        }

        public String[] getCachedDockableNames() {
            return this.cachedDockableNames.toArray(new String[this.cachedDockableNames.size()]);
        }

        public boolean[] getCachedDockableActionFlags() {
            return this.booleanListToArray(this.cachedDockableActionFlags);
        }

        public boolean[] getCachedDockableMovableFlags() {
            return this.booleanListToArray(this.cachedDockableMovableFlags);
        }

        private boolean[] booleanListToArray(List<Boolean> list) {
            boolean[] blArray = new boolean[list.size()];
            int n = 0;
            for (Boolean bl : list) {
                blArray[n++] = bl;
            }
            return blArray;
        }

        private String pushElement(String string) {
            string = string == null ? null : string.intern();
            this.stateStack.push(string);
            return string;
        }

        private String peekElement() {
            return this.stateStack.peek();
        }

        private String popElement() {
            return this.stateStack.pop();
        }
    }
}

