/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;

public class CompletionPopup
extends JWindow {
    private final View view;
    private final KeyHandler keyHandler;
    private Candidates candidates;
    private final JList list;

    public CompletionPopup(View view) {
        super(view);
        this.view = view;
        this.keyHandler = new KeyHandler();
        this.candidates = null;
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new CellRenderer());
        this.list.addKeyListener(this.keyHandler);
        this.list.addMouseListener(new MouseHandler());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setFocusTraversalKeysEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.list, 22, 31);
        jPanel.add((Component)jScrollPane, "Center");
        this.setContentPane(jPanel);
        this.addWindowFocusListener(new WindowFocusHandler());
    }

    public CompletionPopup(View view, Point point) {
        this(view);
        if (point != null) {
            this.setLocation(point);
        }
    }

    public void dispose() {
        if (this.isDisplayable()) {
            if (this.view.getKeyEventInterceptor() == this.keyHandler) {
                this.view.setKeyEventInterceptor(null);
            }
            super.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CompletionPopup.this.view.getTextArea().requestFocus();
                }
            });
        }
    }

    public void reset(Candidates candidates, boolean bl) {
        if (candidates == null || !candidates.isValid() || candidates.getSize() <= 0) {
            this.dispose();
            return;
        }
        this.candidates = candidates;
        this.list.setModel(new CandidateListModel());
        this.list.setVisibleRowCount(Math.min(candidates.getSize(), 8));
        this.pack();
        this.setLocation(CompletionPopup.fitInScreen(this.getLocation(null), this, this.view.getTextArea().getPainter().getFontMetrics().getHeight()));
        if (bl) {
            this.setSelectedIndex(0);
            GUIUtilities.requestFocus(this, this.list);
        }
        this.setVisible(true);
        this.view.setKeyEventInterceptor(this.keyHandler);
    }

    public Candidates getCandidates() {
        return this.candidates;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        if (this.candidates != null && 0 <= n && n < this.candidates.getSize()) {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
            String string = this.candidates.getDescription(n);
            if (string != null) {
                this.view.getStatus().setMessageAndClear(string);
            }
        }
    }

    public boolean doSelectedCompletion() {
        int n = this.list.getSelectedIndex();
        if (this.candidates != null && 0 <= n && n < this.candidates.getSize()) {
            this.candidates.complete(n);
            this.dispose();
            return true;
        }
        return false;
    }

    protected void keyPressed(KeyEvent keyEvent) {
    }

    protected void keyTyped(KeyEvent keyEvent) {
    }

    private static Point fitInScreen(Point point, Window window, int n) {
        Rectangle rectangle = window.getGraphicsConfiguration().getBounds();
        if (point.y + window.getHeight() >= rectangle.height) {
            point.y = point.y - window.getHeight() - n;
        }
        return point;
    }

    private void moveRelative(int n) {
        int n2 = this.list.getSelectedIndex();
        int n3 = n2 + n;
        if (n3 < 0) {
            n3 = 0;
        } else {
            int n4 = this.list.getModel().getSize();
            if (n4 < 1) {
                return;
            }
            if (n3 >= n4) {
                n3 = n4 - 1;
            }
        }
        if (n3 != n2) {
            this.setSelectedIndex(n3);
        }
    }

    private void moveRelativePages(int n) {
        int n2 = this.list.getVisibleRowCount() - 1;
        this.moveRelative(n2 * n);
    }

    private void passKeyEventToView(KeyEvent keyEvent) {
        assert (this.view.getKeyEventInterceptor() == this.keyHandler);
        this.view.setKeyEventInterceptor(null);
        this.view.getInputHandler().processKeyEvent(keyEvent, 2, false);
        if (this.isDisplayable()) {
            this.view.setKeyEventInterceptor(this.keyHandler);
        }
    }

    private class WindowFocusHandler
    implements WindowFocusListener {
        private WindowFocusHandler() {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            CompletionPopup.this.dispose();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (CompletionPopup.this.doSelectedCompletion()) {
                mouseEvent.consume();
            } else {
                CompletionPopup.this.dispose();
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            CompletionPopup.this.keyPressed(keyEvent);
            if (CompletionPopup.this.candidates == null || !CompletionPopup.this.candidates.isValid()) {
                CompletionPopup.this.dispose();
            } else if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 9: 
                    case 10: {
                        if (CompletionPopup.this.doSelectedCompletion()) {
                            keyEvent.consume();
                            break;
                        }
                        CompletionPopup.this.dispose();
                        break;
                    }
                    case 27: {
                        CompletionPopup.this.dispose();
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        CompletionPopup.this.moveRelative(-1);
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        CompletionPopup.this.moveRelative(1);
                        keyEvent.consume();
                        break;
                    }
                    case 33: {
                        CompletionPopup.this.moveRelativePages(-1);
                        keyEvent.consume();
                        break;
                    }
                    case 34: {
                        CompletionPopup.this.moveRelativePages(1);
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        if (!keyEvent.isActionKey() && !keyEvent.isControlDown() && !keyEvent.isAltDown() && !keyEvent.isMetaDown()) break;
                        CompletionPopup.this.dispose();
                    }
                }
            }
            if (!keyEvent.isConsumed()) {
                CompletionPopup.this.passKeyEventToView(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            CompletionPopup.this.keyTyped(keyEvent);
            if (CompletionPopup.this.candidates == null || !CompletionPopup.this.candidates.isValid()) {
                CompletionPopup.this.dispose();
            }
            if (!keyEvent.isConsumed()) {
                CompletionPopup.this.passKeyEventToView(keyEvent);
            }
        }
    }

    private class CellRenderer
    implements ListCellRenderer {
        private CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return CompletionPopup.this.candidates.getCellRenderer(jList, n, bl, bl2);
        }
    }

    private class CandidateListModel
    extends AbstractListModel {
        private CandidateListModel() {
        }

        public int getSize() {
            return CompletionPopup.this.candidates.getSize();
        }

        public Object getElementAt(int n) {
            return CompletionPopup.this.candidates;
        }
    }

    public static interface Candidates {
        public int getSize();

        public boolean isValid();

        public void complete(int var1);

        public Component getCellRenderer(JList var1, int var2, boolean var3, boolean var4);

        public String getDescription(int var1);
    }
}

