/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.CompletionPopup;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteWord
extends CompletionPopup {
    private View view;
    private JEditTextArea textArea;
    private Buffer buffer;
    private String word;
    private String noWordSep;

    public static void completeWord(View view) {
        JEditTextArea jEditTextArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int n = jEditTextArea.getCaretLine();
        int n2 = jEditTextArea.getCaretPosition();
        if (!buffer.isEditable()) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(n2);
        String string = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        String string2 = CompleteWord.getWordToComplete(buffer, n, n2, string);
        if (string2 == null) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        Object[] objectArray = CompleteWord.getCompletions(buffer, string2, n2);
        if (objectArray.length == 0) {
            jEditTextArea.getToolkit().beep();
        } else if (objectArray.length == 1) {
            Completion completion = objectArray[0];
            if (completion.text.equals(string2)) {
                jEditTextArea.getToolkit().beep();
            } else {
                jEditTextArea.replaceSelection(completion.text.substring(string2.length()));
            }
        } else {
            String string3 = MiscUtilities.getLongestPrefix(objectArray, keywordMap != null ? keywordMap.getIgnoreCase() : false);
            if (string2.length() < string3.length()) {
                buffer.insert(n2, string3.substring(string2.length()));
            }
            jEditTextArea.scrollToCaret(false);
            Point point = jEditTextArea.offsetToXY(n2 - string2.length());
            point.y += jEditTextArea.getPainter().getFontMetrics().getHeight();
            SwingUtilities.convertPointToScreen(point, jEditTextArea.getPainter());
            new CompleteWord(view, string3, (Completion[])objectArray, point, string);
        }
    }

    public CompleteWord(View view, String string, Completion[] completionArray, Point point, String string2) {
        super(view, point);
        this.noWordSep = string2;
        this.view = view;
        this.textArea = view.getTextArea();
        this.buffer = view.getBuffer();
        this.word = string;
        this.reset(new Words(completionArray), true);
    }

    private static String getNonAlphaNumericWordChars(Buffer buffer, KeywordMap keywordMap) {
        String string;
        String string2 = buffer.getStringProperty("noWordSep");
        if (string2 == null) {
            string2 = "";
        }
        if (keywordMap != null && (string = keywordMap.getNonAlphaNumericChars()) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    private static String getWordToComplete(Buffer buffer, int n, int n2, String string) {
        CharSequence charSequence = buffer.getLineSegment(n);
        int n3 = n2 - buffer.getLineStartOffset(n);
        if (n3 == 0) {
            return null;
        }
        char c = charSequence.charAt(n3 - 1);
        if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
            return null;
        }
        int n4 = TextUtilities.findWordStart(charSequence, n3 - 1, string);
        CharSequence charSequence2 = charSequence.subSequence(n4, n3);
        if (charSequence2.length() == 0) {
            return null;
        }
        return ((Object)charSequence2).toString();
    }

    private static Collection<Buffer> getVisibleBuffers() {
        final HashSet<Buffer> hashSet = new HashSet<Buffer>();
        jEdit.visit(new JEditVisitorAdapter(){

            public void visit(EditPane editPane) {
                hashSet.add(editPane.getBuffer());
            }
        });
        return hashSet;
    }

    private static Completion[] getCompletions(Buffer buffer, String string, int n) {
        TreeSet<Completion> treeSet = new TreeSet<Completion>(new StandardUtilities.StringCompare());
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(n);
        String string2 = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        Collection<Buffer> collection = jEdit.getBooleanProperty("completeFromAllBuffers") ? Arrays.asList(jEdit.getBuffers()) : CompleteWord.getVisibleBuffers();
        for (Buffer buffer2 : collection) {
            KeywordMap keywordMap2 = buffer2 == buffer ? keywordMap : null;
            int n2 = buffer2 == buffer ? n : 0;
            CompleteWord.getCompletions(buffer2, string, keywordMap, string2, n2, treeSet);
        }
        Completion[] completionArray = treeSet.toArray(new Completion[treeSet.size()]);
        return completionArray;
    }

    private static void getCompletions(Buffer buffer, String string, KeywordMap keywordMap, String string2, int n, Set<Completion> set) {
        int n2 = string.length();
        if (keywordMap != null) {
            String[] stringArray = keywordMap.getKeywords();
            for (int i = 0; i < stringArray.length; ++i) {
                Completion completion;
                String string3 = stringArray[i];
                if (!string3.regionMatches(keywordMap.getIgnoreCase(), 0, string, 0, n2) || set.contains(completion = new Completion(string3, true))) continue;
                set.add(completion);
            }
        }
        for (int i = 0; i < buffer.getLineCount(); ++i) {
            String string4;
            Completion completion;
            CharSequence charSequence = buffer.getLineSegment(i);
            int n3 = buffer.getLineStartOffset(i);
            if (StandardUtilities.startsWith(charSequence, string) && n != n3 + string.length() && !set.contains(completion = new Completion(string4 = CompleteWord.completeWord(charSequence, 0, string2), false))) {
                set.add(completion);
            }
            int n4 = charSequence.length() - string.length();
            for (int j = 0; j < n4; ++j) {
                String string5;
                Completion completion2;
                char c = charSequence.charAt(j);
                if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 || !StandardUtilities.regionMatches(charSequence, j + 1, string, 0, n2) || n == n3 + j + string.length() + 1 || set.contains(completion2 = new Completion(string5 = CompleteWord.completeWord(charSequence, j + 1, string2), false))) continue;
                set.add(completion2);
            }
        }
    }

    private static String completeWord(CharSequence charSequence, int n, String string) {
        int n2 = TextUtilities.findWordEnd(charSequence, n + 1, string);
        return ((Object)charSequence.subSequence(n, n2)).toString();
    }

    private void resetWords(String string) {
        int n = this.textArea.getCaretPosition();
        Completion[] completionArray = CompleteWord.getCompletions(this.buffer, string, n);
        if (completionArray.length > 0) {
            this.word = string;
            this.reset(new Words(completionArray), true);
        } else {
            this.dispose();
        }
    }

    @Override
    protected void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 8) {
            this.textArea.backspace();
            keyEvent.consume();
            if (this.word.length() == 1) {
                this.dispose();
            } else {
                this.resetWords(this.word.substring(0, this.word.length() - 1));
            }
        }
    }

    @Override
    protected void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (Character.isDigit(c)) {
            int n = c - 48;
            n = n == 0 ? 9 : --n;
            if (n < this.getCandidates().getSize()) {
                this.setSelectedIndex(n);
                if (this.doSelectedCompletion()) {
                    keyEvent.consume();
                    this.dispose();
                }
                return;
            }
        }
        if (c != '\b' && c != '\t') {
            if (!Character.isLetterOrDigit(c) && this.noWordSep.indexOf(c) == -1) {
                this.doSelectedCompletion();
                this.textArea.userInput(c);
                keyEvent.consume();
                this.dispose();
                return;
            }
            this.textArea.userInput(c);
            keyEvent.consume();
            this.resetWords(this.word + c);
        }
    }

    private class Words
    implements CompletionPopup.Candidates {
        private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        private final Completion[] completions;

        public Words(Completion[] completionArray) {
            this.completions = completionArray;
        }

        public int getSize() {
            return this.completions.length;
        }

        public boolean isValid() {
            return true;
        }

        public void complete(int n) {
            String string = this.completions[n].toString().substring(CompleteWord.this.word.length());
            CompleteWord.this.textArea.replaceSelection(string);
        }

        public Component getCellRenderer(JList jList, int n, boolean bl, boolean bl2) {
            this.renderer.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            Completion completion = this.completions[n];
            String string = completion.text;
            Font font = jList.getFont();
            if (n < 9) {
                string = n + 1 + ": " + string;
            } else if (n == 9) {
                string = "0: " + string;
            }
            if (completion.keyword) {
                font = font.deriveFont(1);
            }
            this.renderer.setText(string);
            this.renderer.setFont(font);
            return this.renderer;
        }

        public String getDescription(int n) {
            return null;
        }
    }

    private static class Completion {
        final String text;
        final boolean keyword;

        Completion(String string, boolean bl) {
            this.text = string;
            this.keyword = bl;
        }

        public String toString() {
            return this.text;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Completion) {
                return ((Completion)object).text.equals(this.text);
            }
            return false;
        }
    }
}

