/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AbbrevEditor;
import org.gjt.sp.jedit.jEdit;

public class AddAbbrevDialog
extends JDialog {
    private View view;
    private AbbrevEditor editor;
    private JButton global;
    private JButton modeSpecific;
    private JButton cancel;

    public AddAbbrevDialog(View view, String string) {
        super(view, jEdit.getProperty("add-abbrev.title"), true);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.editor = new AbbrevEditor();
        this.editor.setAbbrev(string);
        this.editor.setBorder(new EmptyBorder(6, 0, 12, 0));
        jPanel.add("Center", this.editor);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.global = new JButton(jEdit.getProperty("add-abbrev.global"));
        this.global.addActionListener(new ActionHandler());
        box.add(this.global);
        box.add(Box.createHorizontalStrut(6));
        this.modeSpecific = new JButton(jEdit.getProperty("add-abbrev.mode"));
        this.modeSpecific.addActionListener(new ActionHandler());
        box.add(this.modeSpecific);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        box.add(this.cancel);
        box.add(Box.createGlue());
        jPanel.add("South", box);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        this.editor.getBeforeCaretTextArea().addKeyListener(keyHandler);
        this.editor.getAfterCaretTextArea().addKeyListener(keyHandler);
        this.setDefaultCloseOperation(2);
        if (string == null) {
            GUIUtilities.requestFocus(this, this.editor.getAbbrevField());
        } else {
            GUIUtilities.requestFocus(this, this.editor.getBeforeCaretTextArea());
        }
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                AddAbbrevDialog.this.dispose();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == AddAbbrevDialog.this.global) {
                String string = AddAbbrevDialog.this.editor.getAbbrev();
                if (string == null || string.length() == 0) {
                    AddAbbrevDialog.this.getToolkit().beep();
                    return;
                }
                Abbrevs.addGlobalAbbrev(string, AddAbbrevDialog.this.editor.getExpansion());
                Abbrevs.expandAbbrev(AddAbbrevDialog.this.view, false);
            } else if (object == AddAbbrevDialog.this.modeSpecific) {
                String string = AddAbbrevDialog.this.editor.getAbbrev();
                if (string == null || string.length() == 0) {
                    AddAbbrevDialog.this.getToolkit().beep();
                    return;
                }
                Abbrevs.addModeAbbrev(AddAbbrevDialog.this.view.getBuffer().getMode().getName(), string, AddAbbrevDialog.this.editor.getExpansion());
                Abbrevs.expandAbbrev(AddAbbrevDialog.this.view, false);
            }
            AddAbbrevDialog.this.dispose();
        }
    }
}

