/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.ContextAddDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public abstract class AbstractContextOptionPane
extends AbstractOptionPane {
    private DefaultListModel listModel;
    private JList list;
    private JButton add;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;
    private JButton reset;
    private JLabel caption;
    private JPanel buttons;

    protected AbstractContextOptionPane(String string, String string2) {
        super(string);
        this.caption = new JLabel(string2);
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        this.add("North", this.caption);
        this.listModel = new DefaultListModel();
        this.reloadContextList(this.getContextMenu());
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        this.add("Center", new JScrollPane(this.list));
        this.buttons = new JPanel();
        this.buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.buttons.setLayout(new BoxLayout(this.buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.add.icon")));
        this.add.setToolTipText(jEdit.getProperty("common.add"));
        this.add.addActionListener(actionHandler);
        this.buttons.add(this.add);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener(actionHandler);
        this.buttons.add(this.remove);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.moveUp.icon")));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        this.buttons.add(this.moveUp);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.moveDown.icon")));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        this.buttons.add(this.moveDown);
        this.buttons.add(Box.createGlue());
        this.reset = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.reset.icon")));
        this.reset.setToolTipText(jEdit.getProperty("options.context.reset"));
        this.reset.addActionListener(actionHandler);
        this.buttons.add(this.reset);
        this.updateButtons();
        this.add("South", this.buttons);
    }

    protected abstract String getContextMenu();

    protected abstract void saveContextMenu(String var1);

    protected void addButton(JComponent jComponent) {
        this.buttons.add(jComponent);
    }

    protected void _save() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(((MenuItem)this.listModel.elementAt((int)i)).actionName);
        }
        this.saveContextMenu(stringBuilder.toString());
    }

    private void updateButtons() {
        int n = this.list.getSelectedIndex();
        this.remove.setEnabled(n != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(n > 0);
        this.moveDown.setEnabled(n != -1 && n != this.listModel.getSize() - 1);
    }

    private void reloadContextList(String string) {
        this.listModel.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("-")) {
                this.listModel.addElement(new MenuItem("-", "-"));
                continue;
            }
            EditAction editAction = jEdit.getAction(string3);
            if (editAction == null || (string2 = editAction.getLabel()) == null) continue;
            this.listModel.addElement(new MenuItem(string3, string2));
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbstractContextOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == AbstractContextOptionPane.this.add) {
                ContextAddDialog contextAddDialog = new ContextAddDialog(AbstractContextOptionPane.this);
                String string = contextAddDialog.getSelection();
                if (string == null) {
                    return;
                }
                int n = AbstractContextOptionPane.this.list.getSelectedIndex();
                n = n == -1 ? AbstractContextOptionPane.this.listModel.getSize() : ++n;
                MenuItem menuItem = string.equals("-") ? new MenuItem("-", "-") : new MenuItem(string, jEdit.getAction(string).getLabel());
                AbstractContextOptionPane.this.listModel.insertElementAt(menuItem, n);
                AbstractContextOptionPane.this.list.setSelectedIndex(n);
                AbstractContextOptionPane.this.list.ensureIndexIsVisible(n);
            } else if (object == AbstractContextOptionPane.this.remove) {
                int n = AbstractContextOptionPane.this.list.getSelectedIndex();
                AbstractContextOptionPane.this.listModel.removeElementAt(n);
                if (AbstractContextOptionPane.this.listModel.getSize() != 0) {
                    AbstractContextOptionPane.this.list.setSelectedIndex(Math.min(AbstractContextOptionPane.this.listModel.getSize() - 1, n));
                }
                AbstractContextOptionPane.this.updateButtons();
            } else if (object == AbstractContextOptionPane.this.moveUp) {
                int n = AbstractContextOptionPane.this.list.getSelectedIndex();
                Object e = AbstractContextOptionPane.this.list.getSelectedValue();
                AbstractContextOptionPane.this.listModel.removeElementAt(n);
                AbstractContextOptionPane.this.listModel.insertElementAt(e, n - 1);
                AbstractContextOptionPane.this.list.setSelectedIndex(n - 1);
                AbstractContextOptionPane.this.list.ensureIndexIsVisible(n - 1);
            } else if (object == AbstractContextOptionPane.this.moveDown) {
                int n = AbstractContextOptionPane.this.list.getSelectedIndex();
                Object e = AbstractContextOptionPane.this.list.getSelectedValue();
                AbstractContextOptionPane.this.listModel.removeElementAt(n);
                AbstractContextOptionPane.this.listModel.insertElementAt(e, n + 1);
                AbstractContextOptionPane.this.list.setSelectedIndex(n + 1);
                AbstractContextOptionPane.this.list.ensureIndexIsVisible(n + 1);
            } else if (object == AbstractContextOptionPane.this.reset) {
                String string = "options.context.reset.dialog";
                int n = GUIUtilities.confirm(AbstractContextOptionPane.this.list, string, null, 0, 2);
                if (n == 0) {
                    String string2 = jEdit.getProperty("view.context");
                    jEdit.resetProperty("view.context");
                    String string3 = jEdit.getProperty("view.context");
                    jEdit.setProperty("view.context", string2);
                    AbstractContextOptionPane.this.reloadContextList(string3);
                    AbstractContextOptionPane.this.list.setSelectedIndex(0);
                    AbstractContextOptionPane.this.list.ensureIndexIsVisible(0);
                    AbstractContextOptionPane.this.updateButtons();
                }
            }
        }
    }

    static class MenuItem {
        String actionName;
        String label;

        MenuItem(String string, String string2) {
            this.actionName = string;
            this.label = GUIUtilities.prettifyMenuLabel(string2);
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MenuItemCompare
    implements Comparator<MenuItem> {
        MenuItemCompare() {
        }

        @Override
        public int compare(MenuItem menuItem, MenuItem menuItem2) {
            return StandardUtilities.compareStrings(menuItem.label, menuItem2.label, true);
        }
    }
}

