/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetAdapter;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferSetManager
implements EBComponent {
    public BufferSetManager() {
        EditBus.addToBus(this);
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof ViewUpdate) {
            ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
            if (viewUpdate.getWhat() == ViewUpdate.CLOSED) {
                View view = viewUpdate.getView();
                BufferSet bufferSet = view.getLocalBufferSet();
                bufferSet.getAllBuffers(new BufferSetClosed(bufferSet));
            }
        } else if (eBMessage instanceof EditPaneUpdate) {
            EditPane editPane;
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED && (editPane = editPaneUpdate.getEditPane()).getBufferSetScope() == BufferSet.Scope.editpane) {
                BufferSet bufferSet = editPane.getBufferSet();
                bufferSet.getAllBuffers(new BufferSetClosed(bufferSet));
            }
        } else if (eBMessage instanceof PropertiesChanged) {
            this.visit(new BufferSetVisitor(){

                public void visit(BufferSet bufferSet) {
                    bufferSet.handleMessage();
                }
            });
        }
    }

    public void mergeBufferSet(BufferSet bufferSet, BufferSet bufferSet2) {
        Buffer[] bufferArray;
        for (Buffer buffer : bufferArray = bufferSet2.getAllBuffers()) {
            this.addBuffer(bufferSet, buffer);
        }
    }

    public int countBufferSets(Buffer buffer) {
        return this.getOwners(buffer).size();
    }

    public void addBuffer(View view, Buffer buffer) {
        EditPane editPane = view == null ? null : view.getEditPane();
        this.addBuffer(editPane, buffer);
    }

    public void addBuffer(EditPane editPane, Buffer buffer) {
        if (editPane == null) {
            this.addBuffer(jEdit.getGlobalBufferSet(), buffer);
        } else {
            BufferSet bufferSet = editPane.getBufferSet();
            this.addBuffer(bufferSet, buffer);
        }
    }

    public void addBuffer(BufferSet bufferSet, Buffer buffer) {
        bufferSet.addBuffer(buffer);
    }

    public void addAllBuffers(BufferSet bufferSet) {
        Buffer[] bufferArray;
        for (Buffer buffer : bufferArray = jEdit.getBuffers()) {
            if (buffer.isClosed()) continue;
            this.addBuffer(bufferSet, buffer);
        }
    }

    public void moveBuffer(EditPane editPane, int n, int n2) {
        editPane.getBufferSet().moveBuffer(n, n2);
    }

    public void removeBuffer(EditPane editPane, Buffer buffer) {
        BufferSet bufferSet = editPane.getBufferSet();
        this.removeBuffer(bufferSet, buffer);
    }

    void removeBuffer(BufferSet bufferSet, Buffer buffer) {
        Log.log(1, this, "removeBuffer(" + bufferSet + ',' + buffer + ')');
        Set<BufferSet> set = this.getOwners(buffer);
        set.remove(bufferSet);
        bufferSet.removeBuffer(buffer);
        if (set.isEmpty()) {
            Log.log(1, this, "Buffer:" + buffer + " is in no bufferSet anymore, closing it");
            jEdit._closeBuffer(null, buffer);
        }
        if (bufferSet.size() == 0 && bufferSet.hasListeners()) {
            int n = jEdit.getNextUntitledBufferId();
            Buffer buffer2 = jEdit.openTemporary(jEdit.getActiveView(), null, "Untitled-" + n, true, null);
            jEdit.commitTemporary(buffer2);
            jEdit.getBufferSetManager().addBuffer(bufferSet, buffer2);
        }
    }

    public void removeBuffer(Buffer buffer) {
        for (BufferSet bufferSet : this.getOwners(buffer)) {
            bufferSet.removeBuffer(buffer);
            if (bufferSet.size() != 0 || !bufferSet.hasListeners()) continue;
            int n = jEdit.getNextUntitledBufferId();
            Buffer buffer2 = jEdit.openTemporary(jEdit.getActiveView(), null, "Untitled-" + n, true, null);
            jEdit.commitTemporary(buffer2);
            jEdit.getBufferSetManager().addBuffer(bufferSet, buffer2);
        }
    }

    public void visit(BufferSetVisitor bufferSetVisitor) {
        BufferSet bufferSet = jEdit.getGlobalBufferSet();
        bufferSetVisitor.visit(jEdit.getGlobalBufferSet());
        for (View view : jEdit.getViews()) {
            BufferSet bufferSet2 = view.getLocalBufferSet();
            if (bufferSet2 != null) {
                bufferSetVisitor.visit(bufferSet2);
            }
            for (EditPane editPane : view.getEditPanes()) {
                BufferSet bufferSet3 = editPane.getBufferSet();
                if (bufferSet3 == bufferSet || bufferSet3 == bufferSet2) continue;
                bufferSetVisitor.visit(bufferSet3);
            }
        }
    }

    private Set<BufferSet> getOwners(Buffer buffer) {
        final HashSet<BufferSet> hashSet = new HashSet<BufferSet>();
        this.visit(new BufferSetVisitor(){

            public void visit(BufferSet bufferSet) {
                hashSet.add(bufferSet);
            }
        });
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (((BufferSet)iterator.next()).indexOf(buffer) != -1) continue;
            iterator.remove();
        }
        return hashSet;
    }

    private class BufferSetClosed
    extends BufferSetAdapter {
        private final BufferSet closedBufferSet;

        private BufferSetClosed(BufferSet bufferSet) {
            this.closedBufferSet = bufferSet;
        }

        public void bufferAdded(Buffer buffer, int n) {
            Set set = BufferSetManager.this.getOwners(buffer);
            set.remove(this.closedBufferSet);
            if (set.isEmpty()) {
                Log.log(3, this, "The buffer " + buffer + " was removed from a BufferSet, closing it");
                jEdit._closeBuffer(null, buffer);
            }
        }
    }

    public static interface BufferSetVisitor {
        public void visit(BufferSet var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NewBufferSetAction {
        empty,
        copy,
        currentbuffer;


        public static NewBufferSetAction fromString(String string) {
            NewBufferSetAction[] newBufferSetActionArray;
            for (NewBufferSetAction newBufferSetAction : newBufferSetActionArray = NewBufferSetAction.values()) {
                if (!newBufferSetAction.getName().equals(string)) continue;
                return newBufferSetAction;
            }
            return currentbuffer;
        }

        public String getName() {
            return super.toString();
        }

        public String toString() {
            return jEdit.getProperty("options.editpane.bufferset.newbufferset." + this.getName());
        }
    }
}

