/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.util.Log;

public class UndoManager {
    private JEditBuffer buffer;
    private Edit undosFirst;
    private Edit undosLast;
    private Edit redosFirst;
    private Edit redosLast;
    private int limit;
    private int undoCount;
    private int compoundEditCount;
    private CompoundEdit compoundEdit;
    private Edit undoClearDirty;
    private Edit redoClearDirty;
    private Object undoId;

    public UndoManager(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void clear() {
        this.redosLast = null;
        this.redosFirst = null;
        this.undosLast = null;
        this.undosFirst = null;
        this.undoCount = 0;
    }

    public boolean canUndo() {
        return this.undosLast != null;
    }

    public int undo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.undosLast == null) {
            return -1;
        }
        this.reviseUndoId();
        --this.undoCount;
        int n = this.undosLast.undo();
        this.redosFirst = this.undosLast;
        this.undosLast = this.undosLast.prev;
        if (this.undosLast == null) {
            this.undosFirst = null;
        }
        return n;
    }

    public boolean canRedo() {
        return this.redosFirst != null;
    }

    public int redo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.redosFirst == null) {
            return -1;
        }
        this.reviseUndoId();
        ++this.undoCount;
        int n = this.redosFirst.redo();
        this.undosLast = this.redosFirst;
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast;
        }
        this.redosFirst = this.redosFirst.next;
        return n;
    }

    public void beginCompoundEdit() {
        if (this.compoundEditCount == 0) {
            this.compoundEdit = new CompoundEdit();
            this.reviseUndoId();
        }
        ++this.compoundEditCount;
    }

    public void endCompoundEdit() {
        if (this.compoundEditCount == 0) {
            Log.log(7, this, new Exception("Unbalanced begin/endCompoundEdit()"));
            return;
        }
        if (this.compoundEditCount == 1) {
            if (this.compoundEdit.first != null) {
                if (this.compoundEdit.first == this.compoundEdit.last) {
                    this.addEdit(this.compoundEdit.first);
                } else {
                    this.addEdit(this.compoundEdit);
                }
            }
            this.compoundEdit = null;
        }
        --this.compoundEditCount;
    }

    public boolean insideCompoundEdit() {
        return this.compoundEditCount != 0;
    }

    public Object getUndoId() {
        return this.undoId;
    }

    public void contentInserted(int n, int n2, String string, boolean bl) {
        Insert insert;
        Edit edit = this.getLastEdit();
        Edit edit2 = this.getMergeEdit();
        if (!bl && edit2 instanceof Insert && this.redosFirst == null) {
            insert = (Insert)edit2;
            if (insert.offset == n) {
                insert.str = string.concat(insert.str);
                insert.length += n2;
                return;
            }
            if (insert.offset + insert.length == n) {
                insert.str = insert.str.concat(string);
                insert.length += n2;
                return;
            }
        }
        insert = new Insert(this, n, n2, string);
        if (bl) {
            this.redoClearDirty = edit;
            this.undoClearDirty = insert;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(insert);
        } else {
            this.reviseUndoId();
            this.addEdit(insert);
        }
    }

    public void contentRemoved(int n, int n2, String string, boolean bl) {
        Remove remove;
        Edit edit = this.getLastEdit();
        Edit edit2 = this.getMergeEdit();
        if (!bl && edit2 instanceof Remove && this.redosFirst == null) {
            remove = (Remove)edit2;
            if (remove.offset == n) {
                remove.content.str = remove.content.str.concat(string);
                remove.content.hashcode = remove.content.str.hashCode();
                remove.length += n2;
                KillRing.getInstance().changed(remove.content);
                return;
            }
            if (n + n2 == remove.offset) {
                remove.content.str = string.concat(remove.content.str);
                remove.content.hashcode = remove.content.str.hashCode();
                remove.length += n2;
                remove.offset = n;
                KillRing.getInstance().changed(remove.content);
                return;
            }
        }
        remove = new Remove(this, n, n2, string);
        if (bl) {
            this.redoClearDirty = edit;
            this.undoClearDirty = remove;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(remove);
        } else {
            this.reviseUndoId();
            this.addEdit(remove);
        }
        KillRing.getInstance().add(remove.content);
    }

    public void resetClearDirty() {
        this.redoClearDirty = this.getLastEdit();
        this.undoClearDirty = this.redosFirst instanceof CompoundEdit ? ((CompoundEdit)this.redosFirst).first : this.redosFirst;
    }

    private void addEdit(Edit edit) {
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast = edit;
        } else {
            this.undosLast.next = edit;
            edit.prev = this.undosLast;
            this.undosLast = edit;
        }
        this.redosLast = null;
        this.redosFirst = null;
        ++this.undoCount;
        while (this.undoCount > this.limit) {
            --this.undoCount;
            if (this.undosFirst == this.undosLast) {
                this.undosLast = null;
                this.undosFirst = null;
                continue;
            }
            this.undosFirst.next.prev = null;
            this.undosFirst = this.undosFirst.next;
        }
    }

    private Edit getMergeEdit() {
        Edit edit = this.getLastEdit();
        return this.compoundEdit != null ? this.compoundEdit.last : edit;
    }

    private Edit getLastEdit() {
        if (this.undosLast instanceof CompoundEdit) {
            return ((CompoundEdit)this.undosLast).last;
        }
        return this.undosLast;
    }

    private void reviseUndoId() {
        this.undoId = new Object();
    }

    static class CompoundEdit
    extends Edit {
        Edit first;
        Edit last;

        CompoundEdit() {
        }

        public int undo() {
            int n = -1;
            Edit edit = this.last;
            while (edit != null) {
                n = edit.undo();
                edit = edit.prev;
            }
            return n;
        }

        public int redo() {
            int n = -1;
            Edit edit = this.first;
            while (edit != null) {
                n = edit.redo();
                edit = edit.next;
            }
            return n;
        }

        public void add(Edit edit) {
            if (this.first == null) {
                this.first = this.last = edit;
            } else {
                edit.prev = this.last;
                this.last.next = edit;
                this.last = edit;
            }
        }
    }

    static class Remove
    extends Edit {
        UndoManager mgr;
        int offset;
        int length;
        final RemovedContent content;

        Remove(UndoManager undoManager, int n, int n2, String string) {
            this.mgr = undoManager;
            this.offset = n;
            this.length = n2;
            this.content = new RemovedContent(string);
        }

        int undo() {
            this.mgr.buffer.insert(this.offset, this.content.str);
            if (this.mgr.undoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset + this.length;
        }

        int redo() {
            this.mgr.buffer.remove(this.offset, this.length);
            if (this.mgr.redoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset;
        }
    }

    public static class RemovedContent {
        String str;
        int hashcode;
        boolean inKillRing;

        public RemovedContent(String string) {
            this.str = string;
            this.hashcode = string.hashCode();
        }

        public String toString() {
            return this.str;
        }
    }

    static class Insert
    extends Edit {
        UndoManager mgr;
        int offset;
        int length;
        String str;

        Insert(UndoManager undoManager, int n, int n2, String string) {
            this.mgr = undoManager;
            this.offset = n;
            this.length = n2;
            this.str = string;
        }

        int undo() {
            this.mgr.buffer.remove(this.offset, this.length);
            if (this.mgr.undoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset;
        }

        int redo() {
            this.mgr.buffer.insert(this.offset, this.str);
            if (this.mgr.redoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset + this.length;
        }
    }

    static abstract class Edit {
        Edit prev;
        Edit next;

        Edit() {
        }

        abstract int undo();

        abstract int redo();
    }
}

