/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.List;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.buffer.UndoManager;
import org.gjt.sp.jedit.gui.MutableListModel;

public class KillRing
implements MutableListModel {
    private UndoManager.RemovedContent[] ring;
    private int count;
    private boolean wrap;
    private static KillRing killRing = new KillRing();

    public static KillRing getInstance() {
        return killRing;
    }

    public static void setInstance(KillRing killRing) {
        KillRing.killRing = killRing;
    }

    public void propertiesChanged(int n) {
        int n2 = Math.max(1, n);
        if (this.ring == null) {
            this.ring = new UndoManager.RemovedContent[n2];
        } else if (n2 != this.ring.length) {
            UndoManager.RemovedContent[] removedContentArray = new UndoManager.RemovedContent[n2];
            int n3 = Math.min(this.getSize(), n2);
            for (int i = 0; i < n3; ++i) {
                removedContentArray[i] = (UndoManager.RemovedContent)this.getElementAt(i);
            }
            this.ring = removedContentArray;
            this.count = n3;
            this.wrap = false;
        }
        if (this.count == this.ring.length) {
            this.count = 0;
            this.wrap = true;
        }
    }

    public void load() {
    }

    public void save() {
    }

    protected void reset(List list) {
        UndoManager.RemovedContent[] removedContentArray = new UndoManager.RemovedContent[list.size()];
        int n = 0;
        for (Object e : list) {
            UndoManager.RemovedContent removedContent = e instanceof String ? new UndoManager.RemovedContent((String)e) : (UndoManager.RemovedContent)e;
            removedContentArray[n++] = removedContent;
        }
        this.ring = removedContentArray;
        this.count = 0;
        this.wrap = true;
    }

    public void addListDataListener(ListDataListener listDataListener) {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
    }

    public Object getElementAt(int n) {
        return this.ring[this.virtualToPhysicalIndex(n)];
    }

    public int getSize() {
        if (this.wrap) {
            return this.ring.length;
        }
        return this.count;
    }

    public boolean removeElement(Object object) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.ring[i].equals(object)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public void insertElementAt(Object object, int n) {
        this.remove(n);
        this.add((UndoManager.RemovedContent)object);
    }

    void changed(UndoManager.RemovedContent removedContent) {
        if (removedContent.inKillRing) {
            int n = this.wrap ? this.ring.length : this.count;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                if (this.ring[i] == removedContent || this.ring[i].hashcode != removedContent.hashcode || !this.ring[i].str.equals(removedContent.str)) continue;
                n2 = i;
                break;
            }
            if (n2 != -1) {
                this.remove(n2);
            }
        } else {
            this.add(removedContent);
        }
    }

    void add(UndoManager.RemovedContent removedContent) {
        int n;
        int n2 = this.wrap ? this.ring.length : this.count;
        for (n = 0; n < n2; ++n) {
            if (this.ring[n].hashcode != removedContent.hashcode || !this.ring[n].str.equals(removedContent.str)) continue;
            return;
        }
        n = 1;
        for (int i = 0; i < removedContent.str.length(); ++i) {
            if (Character.isWhitespace(removedContent.str.charAt(i))) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            return;
        }
        removedContent.inKillRing = true;
        if (this.ring[this.count] != null) {
            this.ring[this.count].inKillRing = false;
        }
        this.ring[this.count] = removedContent;
        if (++this.count >= this.ring.length) {
            this.wrap = true;
            this.count = 0;
        }
    }

    void remove(int n) {
        if (this.wrap) {
            UndoManager.RemovedContent[] removedContentArray = new UndoManager.RemovedContent[this.ring.length];
            int n2 = 0;
            for (int i = 0; i < this.ring.length; ++i) {
                int n3 = this.virtualToPhysicalIndex(i);
                if (n == n3) {
                    this.ring[n3].inKillRing = false;
                    continue;
                }
                removedContentArray[n2++] = this.ring[n3];
            }
            this.ring = removedContentArray;
            this.count = n2;
            this.wrap = false;
        } else {
            System.arraycopy(this.ring, n + 1, this.ring, n, this.count - n - 1);
            --this.count;
        }
    }

    private int virtualToPhysicalIndex(int n) {
        if (this.wrap) {
            if (n < this.count) {
                return this.count - n - 1;
            }
            return this.count + this.ring.length - n - 1;
        }
        return this.count - n - 1;
    }
}

