/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.ContentManager;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.LineManager;
import org.gjt.sp.jedit.buffer.PositionManager;
import org.gjt.sp.jedit.buffer.UndoManager;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.DummyTokenHandler;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEditBuffer {
    public static final String LINESEP = "lineSeparator";
    public static final String ENCODING = "encoding";
    public static final int NORMAL_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    protected Mode mode;
    protected boolean textMode;
    protected UndoManager undoMgr;
    private List<Listener> bufferListeners = new Vector<Listener>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ContentManager contentMgr = new ContentManager();
    private LineManager lineMgr = new LineManager();
    private PositionManager positionMgr = new PositionManager(this);
    private FoldHandler foldHandler;
    private IntegerArray integerArray;
    private TokenMarker tokenMarker;
    private boolean undoInProgress;
    private boolean dirty;
    private boolean readOnly;
    private boolean readOnlyOverride;
    private boolean transaction;
    private boolean loading;
    private boolean io;
    private final Map<Object, PropValue> properties;
    private final Object propertyLock;

    public JEditBuffer(Map map) {
        this.undoMgr = new UndoManager(this);
        this.integerArray = new IntegerArray();
        this.propertyLock = new Object();
        this.properties = new HashMap<Object, PropValue>();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.properties.put(entry.getKey(), new PropValue(entry.getValue(), false));
        }
        if (this.getProperty(ENCODING) == null) {
            this.properties.put(ENCODING, new PropValue(System.getProperty("file.encoding"), false));
        }
        if (this.getProperty(LINESEP) == null) {
            this.properties.put(LINESEP, new PropValue(System.getProperty("line.separator"), false));
        }
    }

    public JEditBuffer() {
        this.undoMgr = new UndoManager(this);
        this.integerArray = new IntegerArray();
        this.propertyLock = new Object();
        this.properties = new HashMap<Object, PropValue>();
        this.properties.put("wrap", new PropValue("none", false));
        this.properties.put("folding", new PropValue("none", false));
        this.tokenMarker = new TokenMarker();
        this.tokenMarker.addRuleSet(new ParserRuleSet("text", "MAIN"));
        this.setTokenMarker(this.tokenMarker);
        this.loadText(null, null);
        if (this.getProperty(ENCODING) == null) {
            this.properties.put(ENCODING, new PropValue(System.getProperty("file.encoding"), false));
        }
        if (this.getProperty(LINESEP) == null) {
            this.properties.put(LINESEP, new PropValue(System.getProperty("line.separator"), false));
        }
        this.setFoldHandler(new DummyFoldHandler());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean isPerformingIO() {
        return this.isLoading() || this.io;
    }

    public void setPerformingIO(boolean bl) {
        this.io = bl;
    }

    public boolean isEditable() {
        return !this.isReadOnly() && !this.isPerformingIO();
    }

    public boolean isReadOnly() {
        return this.readOnly || this.readOnlyOverride;
    }

    public void setReadOnly(boolean bl) {
        this.readOnlyOverride = bl;
    }

    public void setDirty(boolean bl) {
        boolean bl2 = this.isEditable();
        if (bl) {
            if (bl2) {
                this.dirty = true;
            }
        } else {
            this.dirty = false;
            if (!this.isUndoInProgress()) {
                this.undoMgr.resetClearDirty();
            }
        }
    }

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    public void writeLock() {
        this.lock.writeLock().lock();
    }

    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public int getLength() {
        return this.contentMgr.getLength();
    }

    public int getLineCount() {
        return this.lineMgr.getLineCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineOfOffset(int n) {
        try {
            this.readLock();
            if (n < 0 || n > this.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n2 = this.lineMgr.getLineOfOffset(n);
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineStartOffset(int n) {
        try {
            this.readLock();
            if (n < 0 || n >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            if (n == 0) {
                int n2 = 0;
                return n2;
            }
            int n3 = this.lineMgr.getLineEndOffset(n - 1);
            return n3;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineEndOffset(int n) {
        try {
            this.readLock();
            if (n < 0 || n >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n2 = this.lineMgr.getLineEndOffset(n);
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineLength(int n) {
        try {
            this.readLock();
            int n2 = this.getLineEndOffset(n) - this.getLineStartOffset(n) - 1;
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getPriorNonEmptyLine(int n) {
        int n2 = -1;
        if (!this.mode.getIgnoreWhitespace()) {
            return n - 1;
        }
        for (int i = n - 1; i >= 0; --i) {
            Segment segment = new Segment();
            this.getLineText(i, segment);
            if (segment.count != 0) {
                n2 = i;
            }
            for (int j = 0; j < segment.count; ++j) {
                char c = segment.array[segment.offset + j];
                if (Character.isWhitespace(c)) continue;
                return i;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineText(int n) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        try {
            this.readLock();
            int n2 = n == 0 ? 0 : this.lineMgr.getLineEndOffset(n - 1);
            int n3 = this.lineMgr.getLineEndOffset(n);
            String string = this.getText(n2, n3 - n2 - 1);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLineText(int n, Segment segment) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        try {
            this.readLock();
            int n2 = n == 0 ? 0 : this.lineMgr.getLineEndOffset(n - 1);
            int n3 = this.lineMgr.getLineEndOffset(n);
            this.getText(n2, n3 - n2 - 1, segment);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getLineSegment(int n) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        try {
            this.readLock();
            int n2 = n == 0 ? 0 : this.lineMgr.getLineEndOffset(n - 1);
            int n3 = this.lineMgr.getLineEndOffset(n);
            CharSequence charSequence = this.getSegment(n2, n3 - n2 - 1);
            return charSequence;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) {
        try {
            this.readLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            String string = this.contentMgr.getText(n, n2);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(int n, int n2, Segment segment) {
        try {
            this.readLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            this.contentMgr.getText(n, n2, segment);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getSegment(int n, int n2) {
        try {
            this.readLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            CharSequence charSequence = this.contentMgr.getSegment(n, n2);
            return charSequence;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int n, String string) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.writeLock();
            if (n < 0 || n > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            this.contentMgr.insert(n, string);
            this.integerArray.clear();
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.undoInProgress) {
                this.undoMgr.contentInserted(n, n2, string, !this.dirty);
            }
            this.contentInserted(n, n2, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int n, Segment segment) {
        if (segment.count == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.writeLock();
            if (n < 0 || n > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            this.contentMgr.insert(n, segment);
            this.integerArray.clear();
            for (int i = 0; i < segment.count; ++i) {
                if (segment.array[segment.offset + i] != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.undoInProgress) {
                this.undoMgr.contentInserted(n, segment.count, segment.toString(), !this.dirty);
            }
            this.contentInserted(n, segment.count, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.transaction = true;
            this.writeLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            int n3 = this.lineMgr.getLineOfOffset(n);
            int n4 = this.lineMgr.getLineOfOffset(n + n2);
            int n5 = n4 - n3;
            if (!this.undoInProgress && !this.loading) {
                this.undoMgr.contentRemoved(n, n2, this.getText(n, n2), !this.dirty);
            }
            this.firePreContentRemoved(n3, n, n5, n2);
            this.contentMgr.remove(n, n2);
            this.lineMgr.contentRemoved(n3, n, n5, n2);
            this.positionMgr.contentRemoved(n, n2);
            this.setDirty(true);
            this.fireContentRemoved(n3, n, n5, n2);
            if (!this.undoInProgress && !this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
        }
        finally {
            this.transaction = false;
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrailingWhiteSpace(int[] nArray) {
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                int n2;
                Segment segment = new Segment();
                this.getLineText(nArray[i], segment);
                if (segment.count == 0) continue;
                int n3 = segment.offset;
                for (n2 = n = segment.offset + segment.count - 1; n2 >= n3 && Character.isWhitespace(segment.array[n2]); --n2) {
                }
                int n4 = n - n2;
                if (n4 == 0) continue;
                this.remove(this.getLineEndOffset(nArray[i]) - 1 - n4, n4);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentLeft(int[] nArray) {
        int n = this.getTabSize();
        int n2 = this.getIndentSize();
        boolean bl = this.getBooleanProperty("noTabs");
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = this.getLineStartOffset(nArray[i]);
                CharSequence charSequence = this.getLineSegment(nArray[i]);
                int n4 = StandardUtilities.getLeadingWhiteSpace(charSequence);
                if (n4 == 0) continue;
                int n5 = Math.max(0, StandardUtilities.getLeadingWhiteSpaceWidth(charSequence, n) - n2);
                this.insert(n3 + n4, StandardUtilities.createWhiteSpace(n5, bl ? 0 : n));
                this.remove(n3, n4);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentRight(int[] nArray) {
        try {
            this.beginCompoundEdit();
            int n = this.getTabSize();
            int n2 = this.getIndentSize();
            boolean bl = this.getBooleanProperty("noTabs");
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = this.getLineStartOffset(nArray[i]);
                CharSequence charSequence = this.getLineSegment(nArray[i]);
                int n4 = StandardUtilities.getLeadingWhiteSpace(charSequence);
                int n5 = StandardUtilities.getLeadingWhiteSpaceWidth(charSequence, n) + n2;
                this.insert(n3 + n4, StandardUtilities.createWhiteSpace(n5, bl ? 0 : n));
                this.remove(n3, n4);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int n, int n2) {
        try {
            this.beginCompoundEdit();
            for (int i = n; i <= n2; ++i) {
                this.indentLine(i, true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int[] nArray) {
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < nArray.length; ++i) {
                this.indentLine(nArray[i], true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Deprecated
    public boolean indentLine(int n, boolean bl, boolean bl2) {
        return this.indentLine(n, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indentLine(int n, boolean bl) {
        int n2;
        int[] nArray = new int[1];
        int n3 = this.getCurrentIndentForLine(n, nArray);
        int n4 = (n2 = this.getPriorNonEmptyLine(n)) == -1 ? 0 : StandardUtilities.getLeadingWhiteSpaceWidth(this.getLineSegment(n2), this.getTabSize());
        int n5 = this.getIdealIndentForLine(n, n2, n4);
        if (n5 == -1 || n5 == n3 || !bl && n5 < n3) {
            return false;
        }
        try {
            String string;
            this.beginCompoundEdit();
            int n6 = this.getLineStartOffset(n);
            this.remove(n6, nArray[0]);
            String string2 = string = n2 >= 0 ? StandardUtilities.getIndentString(this.getLineText(n2)) : null;
            String string3 = string == null ? StandardUtilities.createWhiteSpace(n5, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize()) : (n5 == n4 ? string : (n5 < n4 ? StandardUtilities.truncateWhiteSpace(n5, this.getTabSize(), string) : string + StandardUtilities.createWhiteSpace(n5 - n4, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize(), n4)));
            this.insert(n6, string3);
        }
        finally {
            this.endCompoundEdit();
        }
        return true;
    }

    public int getCurrentIndentForLine(int n, int[] nArray) {
        Segment segment = new Segment();
        this.getLineText(n, segment);
        int n2 = this.getTabSize();
        int n3 = 0;
        block4: for (int i = 0; i < segment.count; ++i) {
            char c = segment.array[segment.offset + i];
            switch (c) {
                case ' ': {
                    ++n3;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
                case '\t': {
                    n3 += n2 - n3 % n2;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
            }
        }
        return n3;
    }

    public int getIdealIndentForLine(int n) {
        int n2 = this.getPriorNonEmptyLine(n);
        int n3 = n2 == -1 ? 0 : StandardUtilities.getLeadingWhiteSpaceWidth(this.getLineSegment(n2), this.getTabSize());
        return this.getIdealIndentForLine(n, n2, n3);
    }

    private int getIdealIndentForLine(int n, int n2, int n3) {
        int n4 = n2 < 0 ? -1 : this.getPriorNonEmptyLine(n2);
        int n5 = n3;
        List<IndentRule> list = this.getIndentRules(n);
        LinkedList<IndentAction> linkedList = new LinkedList<IndentAction>();
        for (int i = 0; i < list.size(); ++i) {
            IndentRule object = list.get(i);
            object.apply(this, n, n2, n4, linkedList);
        }
        for (IndentAction indentAction : linkedList) {
            n5 = indentAction.calculateIndent(this, n, n3, n5);
            if (indentAction.keepChecking()) continue;
            break;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVirtualWidth(int n, int n2) {
        try {
            this.readLock();
            int n3 = this.getLineStartOffset(n);
            Segment segment = new Segment();
            this.getText(n3, n2, segment);
            int n4 = StandardUtilities.getVirtualWidth(segment, this.getTabSize());
            return n4;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffsetOfVirtualColumn(int n, int n2, int[] nArray) {
        try {
            this.readLock();
            Segment segment = new Segment();
            this.getLineText(n, segment);
            int n3 = StandardUtilities.getOffsetOfVirtualColumn(segment, this.getTabSize(), n2, nArray);
            return n3;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAtColumn(int n, int n2, String string) {
        try {
            this.writeLock();
            int[] nArray = new int[1];
            int n3 = this.getOffsetOfVirtualColumn(n, n2, nArray);
            if (n3 == -1) {
                n3 = this.getLineEndOffset(n) - 1;
                string = StandardUtilities.createWhiteSpace(n2 - nArray[0], 0) + string;
            } else {
                n3 += this.getLineStartOffset(n);
            }
            this.insert(n3, string);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertIndented(int n, String string) {
        try {
            int n2;
            this.beginCompoundEdit();
            int n3 = this.getLineOfOffset(n);
            CharSequence charSequence = this.getLineSegment(n3);
            int n4 = StandardUtilities.getLeadingWhiteSpaceWidth(charSequence, this.getTabSize());
            String string2 = StandardUtilities.createWhiteSpace(n4, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize());
            this.insert(n, string);
            int n5 = this.getLineOfOffset(n + string.length());
            for (n2 = n3 + 1; n2 <= n5; ++n2) {
                this.insert(this.getLineStartOffset(n2), string2);
            }
            n2 = string2.length();
            return n2;
        }
        finally {
            this.endCompoundEdit();
        }
    }

    public boolean isElectricKey(char c) {
        return this.mode.isElectricKey(c);
    }

    public boolean isElectricKey(char c, int n) {
        TokenMarker.LineContext lineContext = this.lineMgr.getLineContext(n);
        Mode mode = ModeProvider.instance.getMode(lineContext.rules.getModeName());
        if (mode == null) {
            return false;
        }
        return mode.isElectricKey(c);
    }

    public void markTokens(int n, TokenHandler tokenHandler) {
        int n2;
        Segment segment = new Segment();
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = this.lineMgr.getFirstInvalidLineContext();
        int n4 = this.textMode || n3 == -1 ? n : Math.min(n3, n);
        if (Debug.TOKEN_MARKER_DEBUG) {
            Log.log(1, this, "tokenize from " + n4 + " to " + n);
        }
        TokenMarker.LineContext lineContext = null;
        TokenMarker.LineContext lineContext2 = null;
        for (n2 = n4; n2 <= n; ++n2) {
            this.getLineText(n2, segment);
            lineContext = this.lineMgr.getLineContext(n2);
            TokenMarker.LineContext lineContext3 = n2 == 0 || this.textMode ? null : this.lineMgr.getLineContext(n2 - 1);
            lineContext2 = this.tokenMarker.markTokens(lineContext3, n2 == n ? tokenHandler : DummyTokenHandler.INSTANCE, segment);
            this.lineMgr.setLineContext(n2, lineContext2);
        }
        n2 = this.lineMgr.getLineCount();
        if (n2 - 1 == n) {
            this.lineMgr.setFirstInvalidLineContext(-1);
        } else if (lineContext != lineContext2) {
            this.lineMgr.setFirstInvalidLineContext(n + 1);
        } else if (n3 != -1) {
            this.lineMgr.setFirstInvalidLineContext(Math.max(n3, n + 1));
        }
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        TokenMarker tokenMarker2 = this.tokenMarker;
        this.tokenMarker = tokenMarker;
        if (tokenMarker2 != null && tokenMarker != tokenMarker2) {
            this.lineMgr.setFirstInvalidLineContext(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position createPosition(int n) {
        try {
            this.readLock();
            if (n < 0 || n > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            Position position = this.positionMgr.createPosition(n);
            return position;
        }
        finally {
            this.readUnlock();
        }
    }

    public void propertiesChanged() {
        String string = this.getStringProperty("folding");
        FoldHandler foldHandler = FoldHandler.getFoldHandler(string);
        if (foldHandler != null) {
            this.setFoldHandler(foldHandler);
        } else {
            if (string != null) {
                Log.log(7, this, "invalid 'folding' property: " + string);
            }
            this.setFoldHandler(new DummyFoldHandler());
        }
    }

    public int getTabSize() {
        int n = this.getIntegerProperty("tabSize", 8);
        if (n <= 0) {
            return 8;
        }
        return n;
    }

    public int getIndentSize() {
        int n = this.getIntegerProperty("indentSize", 8);
        if (n <= 0) {
            return 8;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Object object) {
        Object object2 = this.propertyLock;
        synchronized (object2) {
            PropValue propValue = this.properties.get(object);
            if (propValue != null) {
                return propValue.value;
            }
            if (!(object instanceof String)) {
                return null;
            }
            Object object3 = this.getDefaultProperty((String)object);
            if (object3 == null) {
                return null;
            }
            this.properties.put(object, new PropValue(object3, true));
            return object3;
        }
    }

    public Object getDefaultProperty(String string) {
        return null;
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            this.properties.remove(string);
        } else {
            PropValue propValue = this.properties.get(string);
            if (propValue == null) {
                this.properties.put(string, new PropValue(object, false));
            } else if (!propValue.value.equals(object)) {
                propValue.value = object;
                propValue.defaultValue = false;
            }
        }
    }

    public void setDefaultProperty(String string, Object object) {
        this.properties.put(string, new PropValue(object, true));
    }

    public void unsetProperty(String string) {
        this.properties.remove(string);
    }

    public void resetCachedProperties() {
        Iterator<PropValue> iterator = this.properties.values().iterator();
        while (iterator.hasNext()) {
            PropValue propValue = iterator.next();
            if (!propValue.defaultValue) continue;
            iterator.remove();
        }
    }

    public String getStringProperty(String string) {
        Object object = this.getProperty(string);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public void setStringProperty(String string, String string2) {
        this.setProperty(string, string2);
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        Object object = this.getProperty(string);
        return StandardUtilities.getBoolean(object, bl);
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getIntegerProperty(String string, int n) {
        boolean bl;
        Object object;
        PropValue propValue = this.properties.get(string);
        if (propValue != null) {
            object = propValue.value;
            bl = propValue.defaultValue;
        } else {
            object = this.getProperty(string);
            bl = true;
        }
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            int n2 = Integer.parseInt(object.toString().trim());
            this.properties.put(string, new PropValue(n2, bl));
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setIntegerProperty(String string, int n) {
        this.setProperty(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getPatternProperty(String string, int n) {
        Object object = this.propertyLock;
        synchronized (object) {
            boolean bl;
            Object object2;
            PropValue propValue = this.properties.get(string);
            if (propValue != null) {
                object2 = propValue.value;
                bl = propValue.defaultValue;
            } else {
                object2 = this.getProperty(string);
                bl = true;
            }
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof Pattern) {
                return (Pattern)object2;
            }
            Pattern pattern = Pattern.compile(object2.toString(), n);
            this.properties.put(string, new PropValue(pattern, bl));
            return pattern;
        }
    }

    public ParserRuleSet getRuleSetAtOffset(int n) {
        int n2;
        if ((n -= this.getLineStartOffset(n2 = this.getLineOfOffset(n))) != 0) {
            --n;
        }
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        this.markTokens(n2, defaultTokenHandler);
        Token token = TextUtilities.getTokenAtOffset(defaultTokenHandler.getTokens(), n);
        return token.rules;
    }

    public KeywordMap getKeywordMapAtOffset(int n) {
        return this.getRuleSetAtOffset(n).getKeywords();
    }

    public String getContextSensitiveProperty(int n, String string) {
        ParserRuleSet parserRuleSet = this.getRuleSetAtOffset(n);
        Object var4_4 = null;
        Hashtable<String, String> hashtable = parserRuleSet.getProperties();
        if (hashtable != null) {
            var4_4 = hashtable.get(string);
        }
        if (var4_4 == null) {
            return null;
        }
        return String.valueOf(var4_4);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.setMode(ModeProvider.instance.getMode(string));
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("Mode must be non-null");
        }
        this.mode = mode;
        this.textMode = "text".equals(mode.getName());
        this.setTokenMarker(mode.getTokenMarker());
        this.resetCachedProperties();
        this.propertiesChanged();
    }

    public boolean isFoldStart(int n) {
        return n != this.getLineCount() - 1 && this.getFoldLevel(n) < this.getFoldLevel(n + 1);
    }

    public boolean isFoldEnd(int n) {
        return n != this.getLineCount() - 1 && this.getFoldLevel(n) > this.getFoldLevel(n + 1);
    }

    public void invalidateCachedFoldLevels() {
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldLevelChanged(0, this.getLineCount());
    }

    public int getFoldLevel(int n) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.foldHandler instanceof DummyFoldHandler) {
            return 0;
        }
        int n2 = this.lineMgr.getFirstInvalidFoldLevel();
        if (n2 == -1 || n < n2) {
            return this.lineMgr.getFoldLevel(n);
        }
        if (Debug.FOLD_DEBUG) {
            Log.log(1, this, "Invalid fold levels from " + n2 + " to " + n);
        }
        int n3 = 0;
        boolean bl = false;
        int n4 = n2;
        for (int i = n2; i <= n; ++i) {
            Segment segment = new Segment();
            n3 = this.foldHandler.getFoldLevel(this, i, segment);
            if (n3 != this.lineMgr.getFoldLevel(i)) {
                List<Integer> list;
                if (Debug.FOLD_DEBUG) {
                    Log.log(1, this, i + " fold level changed");
                }
                bl = true;
                if (i == n2 && (list = this.foldHandler.getPrecedingFoldLevels(this, i, segment, n3)) != null) {
                    int n5 = i;
                    for (Integer n6 : list) {
                        this.lineMgr.setFoldLevel(--n5, n6);
                    }
                    if (n5 < n4) {
                        n4 = n5;
                    }
                }
            }
            this.lineMgr.setFoldLevel(i, n3);
        }
        if (n == this.lineMgr.getLineCount() - 1) {
            this.lineMgr.setFirstInvalidFoldLevel(-1);
        } else {
            this.lineMgr.setFirstInvalidFoldLevel(n + 1);
        }
        if (bl) {
            if (Debug.FOLD_DEBUG) {
                Log.log(1, this, "fold level changed: " + n4 + ',' + n);
            }
            this.fireFoldLevelChanged(n4, n);
        }
        return n3;
    }

    public int[] getFoldAtLine(int n) {
        int n2;
        int n3;
        int n4;
        if (this.isFoldStart(n)) {
            n4 = n;
            n3 = this.getFoldLevel(n);
            ++n;
            while (this.getFoldLevel(n) > n3 && ++n != this.getLineCount()) {
            }
            n2 = n - 1;
        } else {
            n3 = this.getFoldLevel(n);
            for (n4 = n; this.getFoldLevel(n4) >= n3 && n4 != 0; --n4) {
            }
            n2 = n;
            while (this.getFoldLevel(n2) >= n3 && ++n2 != this.getLineCount()) {
            }
            --n2;
        }
        while (this.getLineLength(n2) == 0 && n2 > n4) {
            --n2;
        }
        return new int[]{n4, n2};
    }

    public FoldHandler getFoldHandler() {
        return this.foldHandler;
    }

    public void setFoldHandler(FoldHandler foldHandler) {
        FoldHandler foldHandler2 = this.foldHandler;
        if (foldHandler.equals(foldHandler2)) {
            return;
        }
        this.foldHandler = foldHandler;
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldHandlerChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(TextArea textArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        try {
            this.writeLock();
            this.undoInProgress = true;
            this.fireBeginUndo();
            int n = this.undoMgr.undo();
            if (n == -1) {
                textArea.getToolkit().beep();
            } else {
                textArea.setCaretPosition(n);
            }
            this.fireEndUndo();
            this.fireTransactionComplete();
        }
        finally {
            this.undoInProgress = false;
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo(TextArea textArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            this.writeLock();
            this.undoInProgress = true;
            this.fireBeginRedo();
            int n = this.undoMgr.redo();
            if (n == -1) {
                textArea.getToolkit().beep();
            } else {
                textArea.setCaretPosition(n);
            }
            this.fireEndRedo();
            this.fireTransactionComplete();
        }
        finally {
            this.undoInProgress = false;
            this.writeUnlock();
        }
    }

    public boolean isTransactionInProgress() {
        return this.transaction || this.undoInProgress || this.insideCompoundEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.beginCompoundEdit();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.endCompoundEdit();
            if (!this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean insideCompoundEdit() {
        return this.undoMgr.insideCompoundEdit();
    }

    public boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    public Object getUndoId() {
        return this.undoMgr.getUndoId();
    }

    public void addBufferListener(BufferListener bufferListener, int n) {
        Listener listener = new Listener(bufferListener, n);
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            Listener listener2 = this.bufferListeners.get(i);
            if (listener2.priority >= n) continue;
            this.bufferListeners.add(i, listener);
            return;
        }
        this.bufferListeners.add(listener);
    }

    public void addBufferListener(BufferListener bufferListener) {
        this.addBufferListener(bufferListener, 0);
    }

    public void removeBufferListener(BufferListener bufferListener) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            if (this.bufferListeners.get((int)i).listener != bufferListener) continue;
            this.bufferListeners.remove(i);
            return;
        }
    }

    public BufferListener[] getBufferListeners() {
        BufferListener[] bufferListenerArray = new BufferListener[this.bufferListeners.size()];
        for (int i = 0; i < bufferListenerArray.length; ++i) {
            bufferListenerArray[i] = this.bufferListeners.get((int)i).listener;
        }
        return bufferListenerArray;
    }

    public void setUndoLimit(int n) {
        if (this.undoMgr != null) {
            this.undoMgr.setLimit(n);
        }
    }

    public boolean canUndo() {
        if (this.undoMgr == null) {
            return false;
        }
        return this.undoMgr.canUndo();
    }

    public boolean canRedo() {
        if (this.undoMgr == null) {
            return false;
        }
        return this.undoMgr.canRedo();
    }

    protected void fireFoldLevelChanged(int n, int n2) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.foldLevelChanged(this, n, n2);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void fireContentInserted(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.contentInserted(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void fireContentRemoved(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.contentRemoved(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void firePreContentInserted(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.preContentInserted(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void firePreContentRemoved(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.preContentRemoved(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void fireBeginUndo() {
    }

    protected void fireEndUndo() {
    }

    protected void fireBeginRedo() {
    }

    protected void fireEndRedo() {
    }

    protected void fireTransactionComplete() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.transactionComplete(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void fireFoldHandlerChanged() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.foldHandlerChanged(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected void fireBufferLoaded() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener bufferListener = this.getListener(i);
            try {
                bufferListener.bufferLoaded(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + bufferListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    protected boolean isFileReadOnly() {
        return this.readOnly;
    }

    protected void setFileReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadText(Segment segment, IntegerArray integerArray) {
        if (segment == null) {
            segment = new Segment(new char[1024], 0, 0);
        }
        if (integerArray == null) {
            integerArray = new IntegerArray();
            integerArray.add(1);
        }
        try {
            this.writeLock();
            int n = this.getLength();
            this.firePreContentRemoved(0, 0, this.getLineCount() - 1, n);
            this.contentMgr.remove(0, n);
            this.lineMgr.contentRemoved(0, 0, this.getLineCount() - 1, n);
            this.positionMgr.contentRemoved(0, n);
            this.fireContentRemoved(0, 0, this.getLineCount() - 1, n);
            this.firePreContentInserted(0, 0, integerArray.getSize() - 1, segment.count - 1);
            this.contentMgr._setContent(segment.array, segment.count);
            this.lineMgr._contentInserted(integerArray);
            this.positionMgr.contentInserted(0, segment.count);
            this.fireContentInserted(0, 0, integerArray.getSize() - 1, segment.count - 1);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void invalidateFoldLevels() {
        this.lineMgr.setFirstInvalidFoldLevel(0);
    }

    protected void parseBufferLocalProperties() {
        int n = Math.min(9, this.getLineCount() - 1);
        this.parseBufferLocalProperties(this.getSegment(0, this.getLineEndOffset(n) - 1));
        int n2 = Math.max(n + 1, this.getLineCount() - 10);
        if (n2 < this.getLineCount()) {
            int n3 = this.getLineEndOffset(this.getLineCount() - 1) - (this.getLineStartOffset(n2) + 1);
            this.parseBufferLocalProperties(this.getSegment(this.getLineStartOffset(n2), n3));
        }
    }

    private BufferListener getListener(int n) {
        return this.bufferListeners.get((int)n).listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contentInserted(int n, int n2, IntegerArray integerArray) {
        try {
            this.transaction = true;
            int n3 = this.lineMgr.getLineOfOffset(n);
            int n4 = integerArray.getSize();
            if (!this.loading) {
                this.firePreContentInserted(n3, n, n4, n2);
            }
            this.lineMgr.contentInserted(n3, n, n4, n2, integerArray);
            this.positionMgr.contentInserted(n, n2);
            this.setDirty(true);
            if (!this.loading) {
                this.fireContentInserted(n3, n, n4, n2);
                if (!this.undoInProgress && !this.insideCompoundEdit()) {
                    this.fireTransactionComplete();
                }
            }
        }
        finally {
            this.transaction = false;
        }
    }

    private void parseBufferLocalProperties(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        boolean bl = false;
        block8: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case ':': {
                    if (bl) {
                        bl = false;
                        stringBuilder.append(':');
                        continue block8;
                    }
                    if (string != null) {
                        this.properties.put(string, new PropValue(stringBuilder.toString(), false));
                        string = null;
                    }
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '=': {
                    if (bl) {
                        bl = false;
                        stringBuilder.append('=');
                        continue block8;
                    }
                    string = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '\\': {
                    if (bl) {
                        stringBuilder.append('\\');
                    }
                    bl = !bl;
                    continue block8;
                }
                case 'n': {
                    if (bl) {
                        stringBuilder.append('\n');
                        bl = false;
                        continue block8;
                    }
                }
                case 'r': {
                    if (bl) {
                        stringBuilder.append('\r');
                        bl = false;
                        continue block8;
                    }
                }
                case 't': {
                    if (bl) {
                        stringBuilder.append('\t');
                        bl = false;
                        continue block8;
                    }
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    private List<IndentRule> getIndentRules(int n) {
        String string = null;
        TokenMarker.LineContext lineContext = this.lineMgr.getLineContext(n);
        if (lineContext != null && lineContext.rules != null) {
            string = lineContext.rules.getModeName();
        }
        if (string == null) {
            string = this.tokenMarker.getMainRuleSet().getModeName();
        }
        return ModeProvider.instance.getMode(string).getIndentRules();
    }

    protected static class PropValue {
        Object value;
        boolean defaultValue;

        PropValue(Object object, boolean bl) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.value = object;
            this.defaultValue = bl;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static class Listener {
        BufferListener listener;
        int priority;

        Listener(BufferListener bufferListener, int n) {
            this.listener = bufferListener;
            this.priority = n;
        }
    }
}

