/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentFoldHandler
extends FoldHandler {
    public IndentFoldHandler() {
        super("indent");
    }

    private int getLeadingWhitespaceWidth(Segment segment, int n) {
        int n2 = segment.offset;
        int n3 = segment.count;
        int n4 = 0;
        block4: for (int i = 0; i < n3; ++i) {
            switch (segment.array[n2 + i]) {
                case ' ': {
                    ++n4;
                    continue block4;
                }
                case '\t': {
                    n4 += n - n4 % n;
                    continue block4;
                }
                default: {
                    return n4;
                }
            }
        }
        return -1;
    }

    @Override
    public int getFoldLevel(JEditBuffer jEditBuffer, int n, Segment segment) {
        int n2 = jEditBuffer.getTabSize();
        int n3 = 0;
        for (int i = n; i < jEditBuffer.getLineCount(); ++i) {
            jEditBuffer.getLineText(i, segment);
            int n4 = this.getLeadingWhitespaceWidth(segment, n2);
            if (n4 >= 0) {
                return n4 > n3 ? n4 : n3;
            }
            if (i == 0) {
                return 0;
            }
            if (i != n) continue;
            n3 = jEditBuffer.getFoldLevel(n - 1);
        }
        return n3;
    }

    @Override
    public List<Integer> getPrecedingFoldLevels(JEditBuffer jEditBuffer, int n, Segment segment, int n2) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = jEditBuffer.getTabSize();
        int n5 = 0;
        for (n3 = n - 1; n3 > 0; --n3) {
            jEditBuffer.getLineText(n3, segment);
            n5 = this.getLeadingWhitespaceWidth(segment, n4);
            if (n5 >= 0) break;
        }
        int n6 = n2 > n5 ? n2 : n5;
        ++n3;
        while (n3 < n) {
            arrayList.add(n6);
            ++n3;
        }
        return arrayList;
    }
}

