/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.Capabilities;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.SimpleNode;

public class TargetError
extends EvalError {
    Throwable target;
    boolean inNativeCode;

    public TargetError(String string, Throwable throwable, SimpleNode simpleNode, CallStack callStack, boolean bl) {
        super(string, simpleNode, callStack);
        this.target = throwable;
        this.inNativeCode = bl;
    }

    public TargetError(Throwable throwable, SimpleNode simpleNode, CallStack callStack) {
        this("TargetError", throwable, simpleNode, callStack, false);
    }

    public Throwable getTarget() {
        if (this.target instanceof InvocationTargetException) {
            return ((InvocationTargetException)this.target).getTargetException();
        }
        return this.target;
    }

    public String toString() {
        return super.toString() + "\nTarget exception: " + this.printTargetError(this.target);
    }

    public void printStackTrace() {
        this.printStackTrace(false, System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(false, printStream);
    }

    public void printStackTrace(boolean bl, PrintStream printStream) {
        if (bl) {
            super.printStackTrace(printStream);
            printStream.println("--- Target Stack Trace ---");
        }
        this.target.printStackTrace(printStream);
    }

    public String printTargetError(Throwable throwable) {
        String string = this.target.toString();
        if (Capabilities.canGenerateInterfaces()) {
            string = string + "\n" + this.xPrintTargetError(throwable);
        }
        return string;
    }

    public String xPrintTargetError(Throwable throwable) {
        String string = "import java.lang.reflect.UndeclaredThrowableException;String result=\"\";while ( target instanceof UndeclaredThrowableException ) {\ttarget=target.getUndeclaredThrowable(); \tresult+=\"Nested: \"+target.toString();}return result;";
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("target", throwable);
            return (String)interpreter.eval(string);
        }
        catch (EvalError evalError) {
            throw new InterpreterError("xprintarget: " + evalError.toString());
        }
    }

    public boolean inNativeCode() {
        return this.inNativeCode;
    }
}

