/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.bsh.BSHAmbiguousName;
import org.gjt.sp.jedit.bsh.BSHArguments;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.Name;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.ReflectError;
import org.gjt.sp.jedit.bsh.SimpleNode;
import org.gjt.sp.jedit.bsh.TargetError;
import org.gjt.sp.jedit.bsh.UtilEvalError;

class BSHMethodInvocation
extends SimpleNode {
    BSHMethodInvocation(int n) {
        super(n);
    }

    BSHAmbiguousName getNameNode() {
        return (BSHAmbiguousName)this.jjtGetChild(0);
    }

    BSHArguments getArgsNode() {
        return (BSHArguments)this.jjtGetChild(1);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        BSHAmbiguousName bSHAmbiguousName = this.getNameNode();
        if (nameSpace.getParent() != null && nameSpace.getParent().isClass && (bSHAmbiguousName.text.equals("super") || bSHAmbiguousName.text.equals("this"))) {
            return Primitive.VOID;
        }
        Name name = bSHAmbiguousName.getName(nameSpace);
        Object[] objectArray = this.getArgsNode().getArguments(callStack, interpreter);
        try {
            return name.invokeMethod(interpreter, objectArray, callStack, this);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Error in method invocation: " + reflectError.getMessage(), this, callStack);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method Invocation " + name;
            Throwable throwable = invocationTargetException.getTargetException();
            boolean bl = true;
            if (throwable instanceof EvalError) {
                bl = throwable instanceof TargetError ? ((TargetError)throwable).inNativeCode() : false;
            }
            throw new TargetError(string, throwable, this, callStack, bl);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }
}

