/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.SimpleNode;

class BSHLiteral
extends SimpleNode {
    public Object value;

    BSHLiteral(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.value == null) {
            throw new InterpreterError("Null in bsh literal: " + this.value);
        }
        return this.value;
    }

    private char getEscapeChar(char c) {
        switch (c) {
            case 'b': {
                c = (char)8;
                break;
            }
            case 't': {
                c = (char)9;
                break;
            }
            case 'n': {
                c = (char)10;
                break;
            }
            case 'f': {
                c = (char)12;
                break;
            }
            case 'r': {
                c = (char)13;
                break;
            }
        }
        return c;
    }

    public void charSetup(String string) {
        char c = string.charAt(0);
        if (c == '\\') {
            c = string.charAt(1);
            c = Character.isDigit(c) ? (char)Integer.parseInt(string.substring(1), 8) : this.getEscapeChar(c);
        }
        this.value = new Primitive(new Character(c).charValue());
    }

    void stringSetup(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (Character.isDigit(c = string.charAt(++i))) {
                    int n;
                    for (n = i; n < i + 2 && Character.isDigit(string.charAt(n + 1)); ++n) {
                    }
                    c = (char)Integer.parseInt(string.substring(i, n + 1), 8);
                    i = n;
                } else {
                    c = this.getEscapeChar(c);
                }
            }
            stringBuilder.append(c);
        }
        this.value = stringBuilder.toString().intern();
    }
}

