/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.lang.reflect.Array;
import org.gjt.sp.jedit.bsh.BSHArrayInitializer;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Reflect;
import org.gjt.sp.jedit.bsh.SimpleNode;

class BSHArrayDimensions
extends SimpleNode {
    public Class baseType;
    public int numDefinedDims;
    public int numUndefinedDims;
    public int[] definedDimensions;

    BSHArrayDimensions(int n) {
        super(n);
    }

    public void addDefinedDimension() {
        ++this.numDefinedDims;
    }

    public void addUndefinedDimension() {
        ++this.numUndefinedDims;
    }

    public Object eval(Class clazz, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("array base type = " + clazz);
        }
        this.baseType = clazz;
        return this.eval(callStack, interpreter);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHArrayInitializer) {
            if (this.baseType == null) {
                throw new EvalError("Internal Array Eval err:  unknown base type", this, callStack);
            }
            Object object = ((BSHArrayInitializer)simpleNode).eval(this.baseType, this.numUndefinedDims, callStack, interpreter);
            Class<?> clazz = object.getClass();
            int n = Reflect.getArrayDimensions(clazz);
            this.definedDimensions = new int[n];
            if (this.definedDimensions.length != this.numUndefinedDims) {
                throw new EvalError("Incompatible initializer. Allocation calls for a " + this.numUndefinedDims + " dimensional array, but initializer is a " + n + " dimensional array", this, callStack);
            }
            Object object2 = object;
            for (int i = 0; i < this.definedDimensions.length; ++i) {
                this.definedDimensions[i] = Array.getLength(object2);
                if (this.definedDimensions[i] <= 0) continue;
                object2 = Array.get(object2, 0);
            }
            return object;
        }
        this.definedDimensions = new int[this.numDefinedDims];
        for (int i = 0; i < this.numDefinedDims; ++i) {
            try {
                Object object = ((SimpleNode)this.jjtGetChild(i)).eval(callStack, interpreter);
                this.definedDimensions[i] = ((Primitive)object).intValue();
                continue;
            }
            catch (Exception exception) {
                throw new EvalError("Array index: " + i + " does not evaluate to an integer", this, callStack);
            }
        }
        return Primitive.VOID;
    }
}

