/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.util.Log;

class VFSFileNameField
extends HistoryTextField {
    private VFSBrowser browser;

    VFSFileNameField(VFSBrowser vFSBrowser, String string) {
        super(string);
        this.setEnterAddsToHistory(false);
        this.browser = vFSBrowser;
        Dimension dimension = this.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.setMaximumSize(dimension);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        hashSet.remove(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
        this.setFocusTraversalKeys(0, hashSet);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            String string = this.getText();
            switch (keyEvent.getKeyCode()) {
                case 9: {
                    this.doComplete(string);
                    break;
                }
                case 37: {
                    if ((keyEvent.getModifiers() & 8) > 0) {
                        this.browser.previousDirectory();
                        keyEvent.consume();
                        break;
                    }
                    super.processKeyEvent(keyEvent);
                    break;
                }
                case 38: {
                    if ((keyEvent.getModifiers() & 8) > 0) {
                        String string2 = this.browser.getDirectory();
                        this.browser.setDirectory(MiscUtilities.getParentOfPath(string2));
                        keyEvent.consume();
                        break;
                    }
                    this.browser.getBrowserView().getTable().processKeyEvent(keyEvent);
                    break;
                }
                case 39: {
                    if ((keyEvent.getModifiers() & 8) > 0) {
                        keyEvent.consume();
                        this.browser.nextDirectory();
                        break;
                    }
                    super.processKeyEvent(keyEvent);
                    break;
                }
                case 33: 
                case 34: 
                case 40: {
                    this.browser.getBrowserView().getTable().processKeyEvent(keyEvent);
                    break;
                }
                case 10: {
                    this.browser.filesActivated(keyEvent.isShiftDown() ? 1 : 0, false);
                    this.setText(null);
                    keyEvent.consume();
                    break;
                }
                default: {
                    super.processKeyEvent(keyEvent);
                    break;
                }
            }
        } else if (keyEvent.getID() == 400) {
            char c = keyEvent.getKeyChar();
            if (c > ' ' && c != '\u007f' && c != '\u00ff') {
                super.processKeyEvent(keyEvent);
                String string = this.getText();
                BrowserView browserView = this.browser.getBrowserView();
                browserView.selectNone();
                if (MiscUtilities.getLastSeparatorIndex(string) == -1) {
                    int n = this.browser.getMode();
                    browserView.getTable().doTypeSelect(string, n == 3 || n == 1);
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    public String doComplete(String string, String string2, boolean bl) {
        Log.log(1, VFSFileNameField.class, "doComplete(" + string + "," + string2 + "," + bl);
        while (string2.length() != 0) {
            int n = MiscUtilities.getFirstSeparatorIndex(string2);
            if (n == -1) {
                return string;
            }
            String string3 = VFSFile.findCompletion(string, string2.substring(0, n), this.browser, true);
            if (string3 == null) {
                return null;
            }
            string = string3;
            string2 = string2.substring(n + 1);
        }
        return string;
    }

    private void doComplete(String string) {
        String string2;
        int n = MiscUtilities.getLastSeparatorIndex(string);
        String string3 = n != -1 ? string.substring(0, n + 1) : "";
        if (MiscUtilities.isAbsolutePath(string)) {
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            if ((string3 = this.doComplete(VFSBrowser.getRootDirectory(), string3, false)) == null) {
                return;
            }
            this.browser.setDirectory(string3);
            VFSManager.waitForRequests();
            if (n == -1) {
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
            } else {
                string = string.substring(n + 1);
            }
        } else if (string3.length() != 0) {
            string3 = this.doComplete(this.browser.getDirectory(), string3, false);
            if (string3 == null) {
                return;
            }
            this.browser.setDirectory(string3);
            VFSManager.waitForRequests();
            string = string.substring(n + 1);
        }
        BrowserView browserView = this.browser.getBrowserView();
        browserView.selectNone();
        browserView.getTable().doTypeSelect(string, this.browser.getMode() == 3);
        VFSFile[] vFSFileArray = browserView.getSelectedFiles();
        if (vFSFileArray.length == 0) {
            string2 = string;
        } else {
            String string4 = vFSFileArray[0].getPath();
            String string5 = vFSFileArray[0].getName();
            String string6 = MiscUtilities.getParentOfPath(string4);
            string2 = MiscUtilities.isAbsolutePath(string) && !string.startsWith(this.browser.getDirectory()) ? string4 : (MiscUtilities.pathsEqual(string6, this.browser.getDirectory()) ? string5 : string4);
        }
        this.setText(string2);
    }

    private void goToParent() {
        String string = MiscUtilities.getFileName(this.browser.getDirectory());
        String string2 = MiscUtilities.getParentOfPath(this.browser.getDirectory());
        this.browser.setDirectory(string2);
        VFS vFS = VFSManager.getVFSForPath(string2);
        if ((vFS.getCapabilities() & 0x40) != 0) {
            VFSManager.waitForRequests();
            this.setText(string);
            this.browser.getBrowserView().getTable().doTypeSelect(string, this.browser.getMode() == 3);
        }
    }
}

