/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserIORequest;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.FilePropertiesDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.GlobVFSFileFilter;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.util.Log;

public class VFSBrowser
extends JPanel
implements EBComponent,
DefaultFocusComponent,
DockableWindow {
    public static final String NAME = "vfs.browser";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int BROWSER_DIALOG = 4;
    public static final int CHOOSE_DIRECTORY_DIALOG = 3;
    public static final int BROWSER = 2;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;
    public static final int M_INSERT = 4;
    String currentEncoding;
    boolean autoDetectEncoding;
    private static final ActionContext actionContext = new BrowserActionContext();
    private EventListenerList listenerList;
    private View view;
    private boolean horizontalLayout;
    private String path;
    private JPanel pathAndFilterPanel;
    private HistoryTextField pathField;
    private JComponent defaultFocusComponent;
    private JCheckBox filterCheckbox;
    private HistoryComboBoxEditor filterEditor;
    private JComboBox filterField;
    private Box toolbarBox;
    private Box topBox;
    private FavoritesMenuButton favorites;
    private PluginsMenuButton plugins;
    private BrowserView browserView;
    private int mode;
    private boolean multipleSelection;
    private boolean showHiddenFiles;
    private boolean sortMixFilesAndDirs;
    private boolean sortIgnoreCase;
    private boolean doubleClickClose;
    private boolean requestRunning;
    private boolean maybeReloadRequestRunning;
    private Stack<String> historyStack = new Stack();
    private Stack<String> nextDirectoryStack = new Stack();

    public static void browseDirectoryInNewWindow(View view, String string) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        if (string != null) {
            jEdit.setTemporaryProperty("vfs.browser.path.tmp", string);
        }
        dockableWindowManager.floatDockableWindow(NAME);
        jEdit.unsetProperty("vfs.browser.path.tmp");
    }

    public static void browseDirectory(View view, String string) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        VFSBrowser vFSBrowser = (VFSBrowser)dockableWindowManager.getDockable(NAME);
        if (vFSBrowser != null) {
            dockableWindowManager.showDockableWindow(NAME);
            vFSBrowser.setDirectory(string);
        } else {
            if (string != null) {
                jEdit.setTemporaryProperty("vfs.browser.path.tmp", string);
            }
            dockableWindowManager.addDockableWindow(NAME);
            jEdit.unsetProperty("vfs.browser.path.tmp");
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public VFSBrowser(View view, String string) {
        this(view, null, 2, true, string);
    }

    public VFSBrowser(View view, String string, int n, boolean bl, String string2) {
        super(new BorderLayout());
        Object object;
        String[] stringArray;
        String string3;
        this.listenerList = new EventListenerList();
        this.mode = n;
        this.multipleSelection = bl;
        this.view = view;
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        KeyListener keyListener = dockableWindowManager.closeListener(NAME);
        this.addKeyListener(keyListener);
        this.currentEncoding = jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding"));
        this.autoDetectEncoding = jEdit.getBooleanProperty("buffer.encodingAutodetect");
        ActionHandler actionHandler = new ActionHandler();
        this.topBox = new Box(1);
        this.horizontalLayout = n != 2 || "top".equals(string2) || "bottom".equals(string2);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        this.topBox.add(this.toolbarBox);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.pathAndFilterPanel = new JPanel(gridBagLayout);
        if (this.isHorizontalLayout()) {
            this.pathAndFilterPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(jEdit.getProperty("vfs.browser.path"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.pathAndFilterPanel.add(jLabel);
        this.pathField = new HistoryTextField("vfs.browser.path");
        this.pathField.setName("path");
        this.pathField.addKeyListener(keyListener);
        this.pathField.setInstantPopups(true);
        this.pathField.setEnterAddsToHistory(false);
        this.pathField.setSelectAllOnFocus(true);
        if (n == 2) {
            this.pathField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        VFSBrowser.this.pathField.setText(VFSBrowser.this.path);
                    }
                }
            });
        }
        Dimension dimension = this.pathField.getPreferredSize();
        dimension.width = 0;
        this.pathField.setPreferredSize(dimension);
        this.pathField.addActionListener(actionHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.pathField, gridBagConstraints);
        this.pathAndFilterPanel.add(this.pathField);
        this.filterCheckbox = new JCheckBox(jEdit.getProperty("vfs.browser.filter"));
        this.filterCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.filterCheckbox.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.filterCheckbox.setSelected(jEdit.getBooleanProperty("vfs.browser.filter-enabled"));
        this.filterCheckbox.addActionListener(actionHandler);
        this.filterCheckbox.addKeyListener(keyListener);
        this.filterCheckbox.setName("filter-checkbox");
        if (n != 3) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.filterCheckbox, gridBagConstraints);
            this.pathAndFilterPanel.add(this.filterCheckbox);
        }
        this.filterField = new JComboBox();
        this.filterEditor = new HistoryComboBoxEditor("vfs.browser.filter");
        this.filterEditor.setToolTipText(jEdit.getProperty("glob.tooltip"));
        this.filterEditor.setInstantPopups(true);
        this.filterEditor.setSelectAllOnFocus(true);
        this.filterEditor.addActionListener(actionHandler);
        this.filterEditor.addKeyListener(keyListener);
        this.filterField.setName("filter-field");
        if (n == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            string3 = jEdit.getProperty("vfs.browser.last-filter");
            if (string3 == null) {
                string3 = jEdit.getProperty("vfs.browser.default-filter");
            }
        } else {
            stringArray = MiscUtilities.getFileExtension(view.getBuffer().getName());
            string3 = stringArray.length() == 0 ? jEdit.getProperty("vfs.browser.default-filter") : '*' + (String)stringArray;
        }
        this.filterEditor.setItem(new GlobVFSFileFilter(string3));
        this.filterField.addItem(this.filterEditor.getItem());
        this.filterField.addItemListener(actionHandler);
        this.filterField.setRenderer(new VFSFileFilterRenderer());
        stringArray = ServiceManager.getServiceNames(VFSFileFilter.SERVICE_NAME);
        for (int i = 0; i < stringArray.length; ++i) {
            object = (VFSFileFilter)ServiceManager.getService(VFSFileFilter.SERVICE_NAME, stringArray[i]);
            this.filterField.addItem(object);
        }
        if (n != 3) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            if (this.filterField.getItemCount() > 1) {
                this.filterField.setEditor(this.filterEditor);
                this.filterField.setEditable(true);
                gridBagLayout.setConstraints(this.filterField, gridBagConstraints);
                this.pathAndFilterPanel.add(this.filterField);
            } else {
                gridBagLayout.setConstraints(this.filterEditor, gridBagConstraints);
                this.pathAndFilterPanel.add(this.filterEditor);
            }
        }
        this.topBox.add(this.pathAndFilterPanel);
        this.add("North", this.topBox);
        this.browserView = new BrowserView(this);
        this.add("Center", this.browserView);
        if (this.isHorizontalLayout()) {
            this.browserView.setBorder(new EmptyBorder(0, 12, 0, 12));
        }
        this.defaultFocusComponent = this.browserView.getTable();
        this.propertiesChanged();
        this.updateFilterEnabled();
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        if (string == null) {
            string = jEdit.getProperty("vfs.browser.path.tmp");
        }
        if (string == null || string.length() == 0) {
            String string4 = System.getProperty("user.home");
            object = jEdit.getProperty("vfs.browser.defaultPath");
            if ("home".equals(object)) {
                string = string4;
            } else if ("working".equals(object)) {
                string = System.getProperty("user.dir");
            } else if ("buffer".equals(object)) {
                Buffer buffer = view.getBuffer();
                string = buffer.getDirectory();
            } else {
                HistoryModel historyModel;
                string = "last".equals(object) ? ((historyModel = HistoryModel.getModel("vfs.browser.path")).getSize() == 0 ? "~" : historyModel.getItem(0)) : ("favorites".equals(object) ? "favorites:" : string4);
            }
        }
        final String string5 = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VFSBrowser.this.setDirectory(string5);
            }
        });
    }

    public void focusOnDefaultComponent() {
        this.defaultFocusComponent.requestFocus();
    }

    void setDefaultFocusComponent(JComponent jComponent) {
        this.defaultFocusComponent = jComponent;
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        VFSFileFilter vFSFileFilter;
        super.removeNotify();
        jEdit.setBooleanProperty("vfs.browser.filter-enabled", this.filterCheckbox.isSelected());
        if ((this.mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) && (vFSFileFilter = (VFSFileFilter)this.filterField.getSelectedItem()) instanceof GlobVFSFileFilter) {
            jEdit.setProperty("vfs.browser.last-filter", ((GlobVFSFileFilter)vFSFileFilter).getGlob());
        }
        EditBus.removeFromBus(this);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            if (bufferUpdate.getWhat() == BufferUpdate.CREATED || bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
                this.browserView.updateFileView();
            }
        } else if (eBMessage instanceof PluginUpdate) {
            PluginUpdate pluginUpdate = (PluginUpdate)eBMessage;
            if ((pluginUpdate.getWhat() == PluginUpdate.LOADED || pluginUpdate.getWhat() == PluginUpdate.UNLOADED) && this.plugins != null) {
                this.plugins.updatePopupMenu();
            }
        } else if (eBMessage instanceof VFSUpdate) {
            this.maybeReloadDirectory(((VFSUpdate)eBMessage).getPath());
        }
    }

    public View getView() {
        return this.view;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelection;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean bl) {
        this.showHiddenFiles = bl;
    }

    @Deprecated
    public String getFilenameFilter() {
        if (this.filterCheckbox.isSelected()) {
            String string = this.filterField.getSelectedItem().toString();
            if (string.length() == 0) {
                return "*";
            }
            return string;
        }
        return "*";
    }

    public VFSFileFilter getVFSFileFilter() {
        if (this.mode == 3) {
            return new DirectoriesOnlyFilter();
        }
        return (VFSFileFilter)this.filterField.getSelectedItem();
    }

    public void addVFSFileFilter(VFSFileFilter vFSFileFilter) {
        this.filterField.addItem(vFSFileFilter);
        if (this.filterField.getItemCount() == 2) {
            this.filterField.setEditor(this.filterEditor);
            this.filterField.setEditable(true);
            GridBagLayout gridBagLayout = (GridBagLayout)this.pathAndFilterPanel.getLayout();
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.filterEditor);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.pathAndFilterPanel.remove(this.filterEditor);
            gridBagLayout.setConstraints(this.filterField, gridBagConstraints);
            this.pathAndFilterPanel.add(this.filterField);
            this.pathAndFilterPanel.validate();
            this.pathAndFilterPanel.repaint();
        }
    }

    public void setFilenameFilter(String string) {
        if (string == null || string.length() == 0 || "*".equals(string)) {
            this.filterCheckbox.setSelected(false);
        } else {
            this.filterCheckbox.setSelected(true);
            this.filterEditor.setItem(new GlobVFSFileFilter(string));
        }
    }

    public HistoryTextField getDirectoryField() {
        return this.pathField;
    }

    public String getDirectory() {
        return this.path;
    }

    public void previousDirectory() {
        if (this.historyStack.size() > 1) {
            this.historyStack.pop();
            this.nextDirectoryStack.push(this.path);
            this.setDirectory(this.historyStack.peek());
            this.historyStack.pop();
        }
    }

    public void nextDirectory() {
        if (!this.nextDirectoryStack.isEmpty()) {
            this.setDirectory(this.nextDirectoryStack.pop());
        }
    }

    public void setDirectory(String string) {
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        string = MiscUtilities.expandVariables(string);
        this.pathField.setText(string);
        if (!this.startRequest()) {
            return;
        }
        this.historyStack.push(string);
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, string, true);
        this.path = string;
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public static String getRootDirectory() {
        if (OperatingSystem.isMacOS() || OperatingSystem.isDOSDerived()) {
            return "roots:";
        }
        return "/";
    }

    public void rootDirectory() {
        this.setDirectory(VFSBrowser.getRootDirectory());
    }

    public void reloadDirectory() {
        VFSManager.getVFSForPath(this.path).reloadDirectory(this.path);
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, this.path, false);
    }

    public void delete(VFSFile[] vFSFileArray) {
        String string = MiscUtilities.isURL(vFSFileArray[0].getDeletePath()) && "favorites".equals(MiscUtilities.getProtocolOfURL(vFSFileArray[0].getDeletePath())) ? "vfs.browser.delete-favorites" : "vfs.browser.delete-confirm";
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "files";
        for (int i = 0; i < vFSFileArray.length; ++i) {
            stringBuilder.append(vFSFileArray[i].getPath());
            stringBuilder.append('\n');
            if (vFSFileArray[i].getType() != 1) continue;
            string2 = "directories and their contents";
        }
        Object[] objectArray = new Object[]{stringBuilder.toString(), string2};
        int n = GUIUtilities.confirm(this, string, objectArray, 0, 2);
        if (n != 0) {
            return;
        }
        VFS vFS = VFSManager.getVFSForPath(vFSFileArray[0].getDeletePath());
        if (!this.startRequest()) {
            return;
        }
        for (int i = 0; i < vFSFileArray.length; ++i) {
            Object object = vFS.createVFSSession(vFSFileArray[i].getDeletePath(), this);
            if (object == null) continue;
            VFSManager.runInWorkThread(new BrowserIORequest(1, this, object, vFS, vFSFileArray[i].getDeletePath(), null, null));
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void rename(String string) {
        VFS vFS = VFSManager.getVFSForPath(string);
        String string2 = vFS.getFileName(string);
        Object[] objectArray = new String[]{string2};
        String string3 = GUIUtilities.input(this, "vfs.browser.rename", objectArray, string2);
        if (string3 == null) {
            return;
        }
        string3 = MiscUtilities.constructPath(vFS.getParentOfPath(string), string3);
        Object object = vFS.createVFSSession(string, this);
        if (object == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(2, this, object, vFS, string, string3, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void rename(String string, String string2) {
        VFS vFS = VFSManager.getVFSForPath(string);
        String string3 = vFS.getFileName(string);
        String[] stringArray = new String[]{string3};
        String string4 = string2;
        if (string4 == null || string3.equals(string2)) {
            return;
        }
        string4 = MiscUtilities.constructPath(vFS.getParentOfPath(string), string4);
        Object object = vFS.createVFSSession(string, this);
        if (object == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(2, this, object, vFS, string, string4, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void mkdir() {
        String string;
        String string2 = GUIUtilities.input(this, "vfs.browser.mkdir", null);
        if (string2 == null) {
            return;
        }
        final VFSFile[] vFSFileArray = this.getSelectedFiles();
        if (vFSFileArray.length == 0) {
            string = this.path;
        } else if (vFSFileArray[0].getType() == 0) {
            string = vFSFileArray[0].getPath();
            string = VFSManager.getVFSForPath(string).getParentOfPath(string);
        } else {
            string = vFSFileArray[0].getPath();
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        string2 = MiscUtilities.constructPath(string, string2);
        Object object = vFS.createVFSSession(string2, this);
        if (object == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(3, this, object, vFS, string2, null, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
                if (vFSFileArray.length != 0 && vFSFileArray[0].getType() != 0) {
                    VFSDirectoryEntryTable vFSDirectoryEntryTable = VFSBrowser.this.browserView.getTable();
                    int n = vFSDirectoryEntryTable.getSelectedRow();
                    VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)vFSDirectoryEntryTable.getModel();
                    VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[n];
                    if (!entry.expanded) {
                        VFSBrowser.this.browserView.clearExpansionState();
                        VFSBrowser.this.browserView.loadDirectory(entry, entry.dirEntry.getPath(), false);
                    }
                }
            }
        });
    }

    public void newFile() {
        VFSFile[] vFSFileArray = this.getSelectedFiles();
        if (vFSFileArray.length >= 1) {
            VFSFile vFSFile = vFSFileArray[0];
            if (vFSFile.getType() == 1) {
                jEdit.newFile(this.view, vFSFile.getPath());
            } else {
                VFS vFS = VFSManager.getVFSForPath(vFSFile.getPath());
                jEdit.newFile(this.view, vFS.getParentOfPath(vFSFile.getPath()));
            }
        } else {
            jEdit.newFile(this.view, this.path);
        }
    }

    public void fileProperties(VFSFile[] vFSFileArray) {
        new FilePropertiesDialog(this.view, this, vFSFileArray);
    }

    public void searchInDirectory() {
        VFSFile[] vFSFileArray = this.getSelectedFiles();
        if (vFSFileArray.length >= 1) {
            VFSFile vFSFile = vFSFileArray[0];
            this.searchInDirectory(vFSFile.getPath(), vFSFile.getType() != 0);
        } else {
            this.searchInDirectory(this.path, true);
        }
    }

    public void searchInDirectory(String string, boolean bl) {
        VFSFileFilter vFSFileFilter = this.getVFSFileFilter();
        String string2 = vFSFileFilter instanceof GlobVFSFileFilter ? ((GlobVFSFileFilter)vFSFileFilter).getGlob() : "*";
        if (!bl) {
            String string3 = MiscUtilities.getFileName(string);
            String string4 = MiscUtilities.getFileExtension(string3);
            string2 = string4 == null || string4.length() == 0 ? string2 : '*' + string4;
            string = MiscUtilities.getParentOfPath(string);
        }
        SearchAndReplace.setSearchFileSet(new DirectoryListSet(string, string2, true));
        SearchDialog.showSearchDialog(this.view, null, 2);
    }

    BrowserView getBrowserView() {
        return this.browserView;
    }

    public VFSFile[] getSelectedFiles() {
        return this.browserView.getSelectedFiles();
    }

    public void locateFile(final String string) {
        VFSFileFilter vFSFileFilter = this.getVFSFileFilter();
        if (!vFSFileFilter.accept(MiscUtilities.getFileName(string))) {
            this.setFilenameFilter(null);
        }
        this.setDirectory(MiscUtilities.getParentOfPath(string));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.browserView.getTable().selectFile(string);
            }
        });
    }

    public JComponent createPluginsMenu(JComponent jComponent, boolean bl) {
        int n;
        Object object;
        ActionHandler actionHandler = new ActionHandler();
        if (bl && this.getMode() == 2) {
            jComponent.add(GUIUtilities.loadMenuItem("plugin-manager", false));
            jComponent.add(GUIUtilities.loadMenuItem("plugin-options", false));
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).addSeparator();
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).addSeparator();
            }
        }
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        Enumeration<VFS> enumeration = VFSManager.getFilesystems();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if ((((VFS)object).getCapabilities() & 4) == 0) continue;
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs." + ((VFS)object).getName() + ".label"));
            jMenuItem.setActionCommand(((VFS)object).getName());
            jMenuItem.addActionListener(actionHandler);
            arrayList.add(jMenuItem);
        }
        object = jEdit.getPlugins();
        for (n = 0; n < ((Object)object).length; ++n) {
            JMenuItem jMenuItem = ((EditPlugin)object[n]).createBrowserMenuItems();
            if (jMenuItem == null) continue;
            arrayList.add(jMenuItem);
        }
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList, new MenuItemTextComparator());
            for (n = 0; n < arrayList.size(); ++n) {
                jComponent.add((Component)arrayList.get(n));
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.plugins.no-plugins.label"));
            jMenuItem.setEnabled(false);
            jComponent.add(jMenuItem);
        }
        return jComponent;
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.listenerList.add(BrowserListener.class, browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.listenerList.remove(BrowserListener.class, browserListener);
    }

    public void filesActivated(int n, boolean bl) {
        Object object;
        VFSFile[] vFSFileArray = this.browserView.getSelectedFiles();
        Object object2 = null;
        for (int i = 0; i < vFSFileArray.length; ++i) {
            EditPane[] editPaneArray;
            VFSFile vFSFile = vFSFileArray[i];
            if (vFSFile.getType() == 1 || vFSFile.getType() == 2) {
                if (n == 1 && this.mode == 2) {
                    VFSBrowser.browseDirectoryInNewWindow(this.view, vFSFile.getPath());
                    continue;
                }
                this.setDirectory(vFSFile.getPath());
                continue;
            }
            if (this.mode != 2 && this.mode != 4) continue;
            if (n == 4) {
                this.view.getBuffer().insertFile(this.view, vFSFile.getPath());
                continue;
            }
            object = jEdit.getBuffer(vFSFile.getPath());
            if (object == null) {
                editPaneArray = new Hashtable();
                editPaneArray.put("encoding", this.currentEncoding);
                editPaneArray.put("encodingAutodetect", this.autoDetectEncoding);
                object = jEdit.openFile(this.view, null, vFSFile.getPath(), false, (Hashtable)editPaneArray);
            } else if (this.doubleClickClose && bl && this.mode != 4 && vFSFileArray.length == 1) {
                editPaneArray = this.view.getEditPanes();
                for (int j = 0; j < editPaneArray.length; ++j) {
                    if (editPaneArray[j].getBuffer() != object) continue;
                    jEdit.closeBuffer(this.view, (Buffer)object);
                    return;
                }
            }
            if (object == null) continue;
            object2 = object;
        }
        if (object2 != null) {
            switch (n) {
                case 0: {
                    this.view.setBuffer((Buffer)object2);
                    break;
                }
                case 1: {
                    jEdit.newView(this.view, object2, false);
                    break;
                }
                case 2: {
                    jEdit.newView(this.view, object2, true);
                    break;
                }
                case 3: {
                    this.view.splitHorizontally().setBuffer((Buffer)object2);
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BrowserListener.class) continue;
            object = (BrowserListener)objectArray[i + 1];
            object.filesActivated(this, vFSFileArray);
        }
    }

    public void move(String string) {
        boolean bl;
        boolean bl2 = bl = this.mode != 2 || "top".equals(string) || "bottom".equals(string);
        if (bl == this.horizontalLayout) {
            return;
        }
        this.horizontalLayout = bl;
        this.topBox.remove(this.toolbarBox);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        this.topBox.add((Component)this.toolbarBox, 0);
        this.propertiesChanged();
    }

    void directoryLoaded(Object object, Object[] objectArray, boolean bl) {
        VFSManager.runInAWTThread(new DirectoryLoadedAWTRequest(object, objectArray, bl));
    }

    void filesSelected() {
        Object object;
        VFSFile[] vFSFileArray = this.browserView.getSelectedFiles();
        if (this.mode == 2) {
            for (int i = 0; i < vFSFileArray.length; ++i) {
                VFSFile vFSFile = vFSFileArray[i];
                object = jEdit.getBuffer(vFSFile.getPath());
                if (object == null || this.view == null) continue;
                this.view.setBuffer((Buffer)object);
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BrowserListener.class) continue;
            object = (BrowserListener)objectArray[i + 1];
            object.filesSelected(this, vFSFileArray);
        }
    }

    void endRequest() {
        this.requestRunning = false;
    }

    private Container createMenuBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new CommandsMenuButton());
        jToolBar.add(Box.createHorizontalStrut(3));
        this.plugins = new PluginsMenuButton();
        jToolBar.add(this.plugins);
        jToolBar.add(Box.createHorizontalStrut(3));
        this.favorites = new FavoritesMenuButton();
        jToolBar.add(this.favorites);
        return jToolBar;
    }

    private Container createToolBar() {
        if (this.mode == 2) {
            return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-browser");
        }
        return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-dialog");
    }

    private void propertiesChanged() {
        Container container;
        this.showHiddenFiles = jEdit.getBooleanProperty("vfs.browser.showHiddenFiles");
        this.sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
        this.doubleClickClose = jEdit.getBooleanProperty("vfs.browser.doubleClickClose");
        this.browserView.propertiesChanged();
        this.toolbarBox.removeAll();
        if (jEdit.getBooleanProperty("vfs.browser.showToolbar")) {
            container = this.createToolBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add(container);
            } else {
                this.toolbarBox.add(container);
            }
        }
        if (jEdit.getBooleanProperty("vfs.browser.showMenubar")) {
            container = this.createMenuBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add((Component)container, 0);
            } else {
                container.add(Box.createGlue());
                this.toolbarBox.add(container);
            }
        } else {
            this.plugins = null;
            this.favorites = null;
        }
        this.revalidate();
        if (this.path != null) {
            this.reloadDirectory();
        }
    }

    private boolean startRequest() {
        if (this.requestRunning) {
            Log.log(1, this, new Throwable("For debugging purposes"));
            GUIUtilities.error(this, "browser-multiple-io", null);
            return false;
        }
        this.requestRunning = true;
        return true;
    }

    private void updateFilterEnabled() {
        this.filterField.setEnabled(this.filterCheckbox.isSelected());
        this.filterEditor.setEnabled(this.filterCheckbox.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadDirectory(String string) {
        if (MiscUtilities.isURL(string) && MiscUtilities.getProtocolOfURL(string).equals("favorites") && this.favorites != null) {
            this.favorites.popup = null;
        }
        if (this.maybeReloadRequestRunning) {
            return;
        }
        if (this.path != null) {
            try {
                this.maybeReloadRequestRunning = true;
                this.browserView.maybeReloadDirectory(string);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        VFSBrowser.this.maybeReloadRequestRunning = false;
                    }
                });
                throw throwable;
            }
            VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
            {
            }
        }
    }

    static {
        ActionSet actionSet = new ActionSet(null, null, null, jEdit.class.getResource("browser.actions.xml"));
        actionSet.setLabel(jEdit.getProperty("action-set.browser"));
        actionSet.load();
        actionContext.addActionSet(actionSet);
    }

    public static class DirectoriesOnlyFilter
    implements VFSFileFilter {
        public boolean accept(VFSFile vFSFile) {
            return vFSFile.getType() == 1 || vFSFile.getType() == 2;
        }

        public boolean accept(String string) {
            return false;
        }

        public String getDescription() {
            return jEdit.getProperty("vfs.browser.file_filter.dir_only");
        }
    }

    private static class VFSFileFilterRenderer
    extends DefaultListCellRenderer {
        private VFSFileFilterRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof VFSFileFilter) : "Filter is not a VFSFileFilter";
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(((VFSFileFilter)object).getDescription());
            return this;
        }
    }

    private static class HistoryComboBoxEditor
    extends HistoryTextField
    implements ComboBoxEditor {
        private GlobVFSFileFilter current;

        HistoryComboBoxEditor(String string) {
            super(string);
        }

        public Object getItem() {
            if (this.current == null) {
                this.current = new GlobVFSFileFilter(this.getText());
            }
            if (!this.current.getGlob().equals(this.getText())) {
                this.current.setGlob(this.getText());
            }
            return this.current;
        }

        public void setItem(Object object) {
            if (object == this.current) {
                if (object != null) {
                    GlobVFSFileFilter globVFSFileFilter = (GlobVFSFileFilter)object;
                    this.current = new GlobVFSFileFilter(globVFSFileFilter.getGlob());
                    this.setText(this.current.getGlob());
                }
                return;
            }
            if (!(object instanceof GlobVFSFileFilter)) {
                return;
            }
            if (object != null) {
                GlobVFSFileFilter globVFSFileFilter = (GlobVFSFileFilter)object;
                globVFSFileFilter = new GlobVFSFileFilter(globVFSFileFilter.getGlob());
                this.setText(globVFSFileFilter.getGlob());
                this.addCurrentToHistory();
                this.current = globVFSFileFilter;
            } else {
                this.setText("*");
                this.current = new GlobVFSFileFilter("*");
            }
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.getID() != 1005) {
                super.processFocusEvent(focusEvent);
            } else {
                this.setCaretPosition(0);
                this.getCaret().setVisible(false);
            }
        }

        public Component getEditorComponent() {
            return this;
        }
    }

    static class BrowserActionContext
    extends ActionContext {
        BrowserActionContext() {
        }

        private static VFSFile[] getSelectedFiles(EventObject eventObject, VFSBrowser vFSBrowser) {
            Component component = (Component)eventObject.getSource();
            if (GUIUtilities.getComponentParent(component, BrowserView.ParentDirectoryList.class) != null) {
                Object[] objectArray = vFSBrowser.getBrowserView().getParentDirectoryList().getSelectedValues();
                VFSFile[] vFSFileArray = new VFSFile[objectArray.length];
                System.arraycopy(objectArray, 0, vFSFileArray, 0, objectArray.length);
                return vFSFileArray;
            }
            return vFSBrowser.getSelectedFiles();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void invokeAction(EventObject eventObject, EditAction editAction) {
            block9: {
                VFSBrowser vFSBrowser = (VFSBrowser)GUIUtilities.getComponentParent((Component)eventObject.getSource(), VFSBrowser.class);
                VFSFile[] vFSFileArray = BrowserActionContext.getSelectedFiles(eventObject, vFSBrowser);
                NameSpace nameSpace = BeanShell.getNameSpace();
                nameSpace.setVariable("browser", vFSBrowser);
                nameSpace.setVariable("files", vFSFileArray);
                View view = vFSBrowser.getView();
                if (view == null) {
                    view = jEdit.getActiveView();
                }
                editAction.invoke(view);
                Object var8_8 = null;
                try {
                    nameSpace.setVariable("browser", null);
                    nameSpace.setVariable("files", null);
                }
                catch (UtilEvalError utilEvalError) {
                    Log.log(9, this, utilEvalError);
                }
                break block9;
                {
                    catch (UtilEvalError utilEvalError) {
                        Log.log(9, this, utilEvalError);
                        Object var8_9 = null;
                        try {
                            nameSpace.setVariable("browser", null);
                            nameSpace.setVariable("files", null);
                        }
                        catch (UtilEvalError utilEvalError2) {
                            Log.log(9, this, utilEvalError2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        nameSpace.setVariable("browser", null);
                        nameSpace.setVariable("files", null);
                    }
                    catch (UtilEvalError utilEvalError) {
                        Log.log(9, this, utilEvalError);
                    }
                    throw throwable;
                }
            }
        }
    }

    class DirectoryLoadedAWTRequest
    implements Runnable {
        private Object node;
        private Object[] loadInfo;
        private boolean addToHistory;

        DirectoryLoadedAWTRequest(Object object, Object[] objectArray, boolean bl) {
            this.node = object;
            this.loadInfo = objectArray;
            this.addToHistory = bl;
        }

        public void run() {
            String string = (String)this.loadInfo[0];
            if (string == null) {
                return;
            }
            VFSFile[] vFSFileArray = (VFSFile[])this.loadInfo[1];
            if (this.node == null) {
                VFSBrowser.this.path = string;
                if (!VFSBrowser.this.pathField.getText().equals(string)) {
                    VFSBrowser.this.pathField.setText(string);
                }
                if (string.endsWith("/") || string.endsWith(File.separator)) {
                    string = string.substring(0, string.length() - 1);
                }
                if (this.addToHistory) {
                    HistoryModel.getModel("vfs.browser.path").addItem(string);
                }
            }
            boolean bl = VFSBrowser.this.filterCheckbox.isSelected();
            ArrayList<VFSFile> arrayList = new ArrayList<VFSFile>();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (vFSFileArray != null) {
                VFSFileFilter vFSFileFilter = VFSBrowser.this.getVFSFileFilter();
                for (int i = 0; i < vFSFileArray.length; ++i) {
                    VFSFile vFSFile = vFSFileArray[i];
                    if (vFSFile.isHidden() && !VFSBrowser.this.showHiddenFiles) {
                        ++n3;
                        continue;
                    }
                    if (vFSFileFilter != null && (bl || vFSFileFilter instanceof DirectoriesOnlyFilter) && !vFSFileFilter.accept(vFSFile)) {
                        ++n3;
                        continue;
                    }
                    if (vFSFile.getType() == 0) {
                        ++n2;
                    } else {
                        ++n;
                    }
                    arrayList.add(vFSFile);
                }
                Collections.sort(arrayList, new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
            }
            VFSBrowser.this.browserView.directoryLoaded(this.node, string, arrayList);
            if (VFSBrowser.this.mode == 3) {
                VFSBrowser.this.filesSelected();
            }
        }

        public String toString() {
            return (String)this.loadInfo[0];
        }
    }

    class FavoritesMenuButton
    extends RolloverButton {
        JPopupMenu popup;

        FavoritesMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.favorites.label"));
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
            this.setHorizontalTextPosition(10);
            this.setName("favorites");
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        void createPopupMenu() {
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.add-to-favorites.label"));
            jMenuItem.setActionCommand("add-to-favorites");
            jMenuItem.addActionListener(actionHandler);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.edit-favorites.label"));
            jMenuItem.setActionCommand("dir@favorites:");
            jMenuItem.addActionListener(actionHandler);
            this.popup.add(jMenuItem);
            this.popup.addSeparator();
            VFSFile[] vFSFileArray = FavoritesVFS.getFavorites();
            if (vFSFileArray.length == 0) {
                jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
                jMenuItem.setEnabled(false);
                this.popup.add(jMenuItem);
            } else {
                Arrays.sort(vFSFileArray, new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
                for (int i = 0; i < vFSFileArray.length; ++i) {
                    VFSFile vFSFile = vFSFileArray[i];
                    jMenuItem = new JMenuItem(vFSFile.getPath());
                    jMenuItem.setIcon(FileCellRenderer.getIconForFile(vFSFile, false));
                    String string = (vFSFile.getType() == 0 ? "file@" : "dir@") + vFSFile.getPath();
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionHandler);
                    this.popup.add(jMenuItem);
                }
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (FavoritesMenuButton.this.popup != null && FavoritesMenuButton.this.popup.isVisible()) {
                    FavoritesMenuButton.this.popup.setVisible(false);
                    return;
                }
                if (FavoritesMenuButton.this.popup == null) {
                    FavoritesMenuButton.this.createPopupMenu();
                }
                GUIUtilities.showPopupMenu(FavoritesMenuButton.this.popup, FavoritesMenuButton.this, 0, FavoritesMenuButton.this.getHeight(), false);
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("add-to-favorites".equals(string)) {
                    VFSFile[] vFSFileArray = VFSBrowser.this.getSelectedFiles();
                    if (vFSFileArray == null || vFSFileArray.length == 0) {
                        if (VFSBrowser.this.path.equals("favorites:")) {
                            GUIUtilities.error(VFSBrowser.this, "vfs.browser.recurse-favorites", null);
                        } else {
                            FavoritesVFS.addToFavorites(VFSBrowser.this.path, 1);
                        }
                    } else {
                        for (int i = 0; i < vFSFileArray.length; ++i) {
                            VFSFile vFSFile = vFSFileArray[i];
                            FavoritesVFS.addToFavorites(vFSFile.getPath(), vFSFile.getType());
                        }
                    }
                } else if (string.startsWith("dir@")) {
                    VFSBrowser.this.setDirectory(string.substring(4));
                } else if (string.startsWith("file@")) {
                    switch (VFSBrowser.this.getMode()) {
                        case 2: {
                            jEdit.openFile(VFSBrowser.this.view, string.substring(5));
                            break;
                        }
                        default: {
                            VFSBrowser.this.locateFile(string.substring(5));
                        }
                    }
                }
            }
        }
    }

    class PluginsMenuButton
    extends RolloverButton {
        JPopupMenu popup;

        PluginsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.plugins.label"));
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
            this.setHorizontalTextPosition(10);
            this.setName("plugins");
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        void updatePopupMenu() {
            this.popup = null;
        }

        private void createPopupMenu() {
            if (this.popup != null) {
                return;
            }
            this.popup = (JPopupMenu)VFSBrowser.this.createPluginsMenu(new JPopupMenu(), true);
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PluginsMenuButton.this.createPopupMenu();
                if (!PluginsMenuButton.this.popup.isVisible()) {
                    GUIUtilities.showPopupMenu(PluginsMenuButton.this.popup, PluginsMenuButton.this, 0, PluginsMenuButton.this.getHeight(), false);
                } else {
                    PluginsMenuButton.this.popup.setVisible(false);
                }
            }
        }
    }

    class CommandsMenuButton
    extends RolloverButton {
        BrowserCommandsMenu popup;

        CommandsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.commands.label"));
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
            this.setHorizontalTextPosition(10);
            this.setName("commands");
            this.popup = new BrowserCommandsMenu(VFSBrowser.this, null);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!CommandsMenuButton.this.popup.isVisible()) {
                    CommandsMenuButton.this.popup.update();
                    GUIUtilities.showPopupMenu(CommandsMenuButton.this.popup, CommandsMenuButton.this, 0, CommandsMenuButton.this.getHeight(), false);
                } else {
                    CommandsMenuButton.this.popup.setVisible(false);
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener,
    ItemListener {
        private boolean isProcessingEvent;

        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isProcessingEvent) {
                return;
            }
            Object object = actionEvent.getSource();
            if (object == VFSBrowser.this.pathField || object == VFSBrowser.this.filterCheckbox) {
                this.isProcessingEvent = true;
                this.resetLater();
                VFSBrowser.this.updateFilterEnabled();
                String string = VFSBrowser.this.pathField.getText();
                if (string != null) {
                    VFSBrowser.this.setDirectory(string);
                }
                VFSBrowser.this.browserView.focusOnFileView();
            } else if (object == VFSBrowser.this.filterField.getEditor()) {
                VFSBrowser.this.filterField.getEditor().setItem(VFSBrowser.this.filterField.getEditor().getItem());
            } else if (object == VFSBrowser.this.filterEditor) {
                VFSBrowser.this.filterEditor.setItem(VFSBrowser.this.filterEditor.getItem());
                VFSBrowser.this.filterField.setSelectedItem(VFSBrowser.this.filterEditor.getItem());
                this.itemStateChanged(new ItemEvent(VFSBrowser.this.filterField, 701, VFSBrowser.this.filterEditor.getItem(), 1));
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.isProcessingEvent) {
                return;
            }
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            this.isProcessingEvent = true;
            this.resetLater();
            VFSBrowser.this.filterField.setEditable(itemEvent.getItem() instanceof GlobVFSFileFilter);
            VFSBrowser.this.updateFilterEnabled();
            String string = VFSBrowser.this.pathField.getText();
            if (string != null) {
                VFSBrowser.this.setDirectory(string);
            }
            VFSBrowser.this.browserView.focusOnFileView();
        }

        private void resetLater() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionHandler.this.isProcessingEvent = false;
                }
            });
        }
    }
}

