/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;

public class FileCellRenderer
extends DefaultTableCellRenderer {
    public static Icon fileIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.file.icon"));
    public static Icon openFileIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.open-file.icon"));
    public static Icon dirIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.dir.icon"));
    public static Icon openDirIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.open-dir.icon"));
    public static Icon filesystemIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.filesystem.icon"));
    public static Icon loadingIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.loading.icon"));
    Font plainFont = UIManager.getFont("Tree.font");
    Font boldFont;
    boolean showIcons;
    private static boolean defaultIcons = true;
    private boolean openBuffer;
    private boolean isSelected;
    private VFSFile file;

    public FileCellRenderer() {
        if (this.plainFont == null) {
            this.plainFont = jEdit.getFontProperty("metal.secondary.font");
        }
        this.boldFont = this.plainFont.deriveFont(1);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof VFSDirectoryEntryTableModel.Entry) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)object;
            VFSFile vFSFile = entry.dirEntry;
            this.setFont(vFSFile.getType() == 0 ? this.plainFont : this.boldFont);
            this.isSelected = bl;
            this.file = vFSFile;
            if (n2 == 0) {
                String string = vFSFile.getSymlinkPath() == null ? vFSFile.getPath() : vFSFile.getSymlinkPath();
                this.openBuffer = jEdit._getBuffer(string) != null;
                this.setIcon(this.showIcons ? FileCellRenderer.getIconForFile(vFSFile, entry.expanded, this.openBuffer) : null);
                this.setText(vFSFile.getName());
                int n3 = vFSFile.getType() == 0 ? 0 : (entry.expanded ? 2 : 1);
                this.setBorder(new ExpansionToggleBorder(n3, entry.level));
            } else {
                VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)jTable.getModel();
                String string = vFSDirectoryEntryTableModel.getExtendedAttribute(n2);
                this.openBuffer = false;
                this.setIcon(null);
                this.setText(vFSFile.getExtendedAttribute(string));
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        if (!this.isSelected) {
            serializable = this.file.getColor();
            this.setForeground(serializable == null ? UIManager.getColor("Tree.foreground") : serializable);
        }
        super.paintComponent(graphics);
        if (this.openBuffer) {
            int n;
            int n2;
            serializable = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics((Font)serializable);
            if (this.getIcon() == null) {
                n2 = 0;
                n = fontMetrics.getAscent() + 2;
            } else {
                n2 = this.getIcon().getIconWidth() + this.getIconTextGap();
                n = Math.max(fontMetrics.getAscent() + 2, 16);
            }
            Insets insets = this.getBorder().getBorderInsets(this);
            graphics.setColor(this.getForeground());
            graphics.drawLine(n2 += insets.left, n, n2 + fontMetrics.stringWidth(this.getText()), n);
        }
    }

    public static Icon getIconForFile(VFSFile vFSFile, boolean bl) {
        return FileCellRenderer.getIconForFile(vFSFile, bl, jEdit._getBuffer(vFSFile.getSymlinkPath()) != null);
    }

    public static Icon getIconForFile(VFSFile vFSFile, boolean bl, boolean bl2) {
        if (defaultIcons) {
            return vFSFile.getDefaultIcon(bl, bl2);
        }
        return vFSFile.getIcon(bl, bl2);
    }

    void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
        defaultIcons = jEdit.getBooleanProperty("vfs.browser.useDefaultIcons");
    }

    int getEntryWidth(VFSDirectoryEntryTableModel.Entry entry, Font font, FontRenderContext fontRenderContext) {
        String string = entry.dirEntry.getName();
        int n = (int)font.getStringBounds(string, fontRenderContext).getWidth();
        n += ExpansionToggleBorder.ICON_WIDTH + entry.level * 10 + 3;
        if (this.showIcons) {
            n += fileIcon.getIconWidth();
            n += this.getIconTextGap();
        }
        return n;
    }

    static class ExpansionToggleBorder
    implements Border {
        static final Icon COLLAPSE_ICON = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.collapse.icon"));
        static final Icon EXPAND_ICON = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.expand.icon"));
        static final int ICON_WIDTH = Math.max(COLLAPSE_ICON.getIconWidth(), EXPAND_ICON.getIconWidth());
        static final int LEVEL_WIDTH = 10;
        static final int STATE_NONE = 0;
        static final int STATE_COLLAPSED = 1;
        static final int STATE_EXPANDED = 2;
        private int state;
        private int level;

        ExpansionToggleBorder(int n, int n2) {
            this.state = n;
            this.level = n2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            switch (this.state) {
                case 1: {
                    EXPAND_ICON.paintIcon(component, graphics, n + this.level * 10 + 2, n2 + (n4 - EXPAND_ICON.getIconHeight()) / 2);
                    break;
                }
                case 2: {
                    COLLAPSE_ICON.paintIcon(component, graphics, n + this.level * 10 + 2, n2 + (n4 - COLLAPSE_ICON.getIconHeight()) / 2);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, this.level * 10 + ICON_WIDTH + 4, 1, 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public static boolean isExpansionToggle(int n, int n2) {
            return n2 >= n * 10 && n2 <= n * 10 + ICON_WIDTH;
        }
    }
}

