/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;

public class BrowserCommandsMenu
extends JPopupMenu {
    private VFSBrowser browser;
    private HashMap<String, JRadioButtonMenuItem> encodingMenuItems;
    private JCheckBoxMenuItem autoDetect;
    private JRadioButtonMenuItem otherEncoding;

    public BrowserCommandsMenu(VFSBrowser vFSBrowser, VFSFile[] vFSFileArray) {
        this.browser = vFSBrowser;
        if (vFSFileArray != null) {
            VFS vFS = VFSManager.getVFSForPath(vFSFileArray[0].getDeletePath());
            int n = vFSFileArray[0].getType();
            boolean bl = jEdit.getBuffer(vFSFileArray[0].getPath()) != null;
            boolean bl2 = jEdit.getBuffer(vFSFileArray[0].getDeletePath()) != null;
            boolean bl3 = !bl2 && (vFS.getCapabilities() & 8) != 0;
            boolean bl4 = !bl && (vFS.getCapabilities() & 0x10) != 0;
            for (int i = 1; i < vFSFileArray.length; ++i) {
                VFSFile vFSFile = vFSFileArray[i];
                VFS vFS2 = VFSManager.getVFSForPath(vFSFile.getDeletePath());
                bl3 &= vFS == vFS2 && (vFS2.getCapabilities() & 8) != 0;
                if (n != vFSFile.getType()) {
                    n = -1;
                }
                bl4 = false;
                if (jEdit.getBuffer(vFSFile.getPath()) == null) continue;
                bl = true;
            }
            if (n == 1 || n == 2) {
                if (vFSFileArray.length == 1) {
                    this.add(this.createMenuItem("browse"));
                }
                if (vFSBrowser.getMode() == 2) {
                    this.add(this.createMenuItem("browse-window"));
                }
            } else if (n == 0 && (vFSBrowser.getMode() == 2 || vFSBrowser.getMode() == 4)) {
                this.add(this.createMenuItem("open"));
                this.add(GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "vfs.browser.open-in"));
                this.add(this.createMenuItem("insert"));
                if (bl) {
                    this.add(this.createMenuItem("close"));
                }
            } else if (n != -1) {
                this.add(this.createMenuItem("open"));
            }
            if (bl4) {
                this.add(this.createMenuItem("rename"));
            }
            if (bl3) {
                this.add(this.createMenuItem("delete"));
            }
            this.add(this.createMenuItem("copy-path"));
            this.add(this.createMenuItem("paste"));
            if (vFSFileArray.length == 1 || vFSBrowser.getSelectedFiles().length != 0) {
                this.add(this.createMenuItem("properties"));
            }
            this.addSeparator();
        }
        this.add(this.createMenuItem("up"));
        this.add(this.createMenuItem("previous"));
        this.add(this.createMenuItem("next"));
        this.add(this.createMenuItem("reload"));
        this.add(this.createMenuItem("roots"));
        this.add(this.createMenuItem("home"));
        this.add(this.createMenuItem("synchronize"));
        this.addSeparator();
        if (vFSBrowser.getMode() == 2) {
            this.add(this.createMenuItem("new-file"));
        }
        this.add(this.createMenuItem("new-directory"));
        if (vFSBrowser.getMode() == 2) {
            this.addSeparator();
            this.add(this.createMenuItem("search-directory"));
        }
        this.addSeparator();
        this.add(this.createMenuItem("show-hidden-files"));
        if (vFSBrowser.getMode() == 2 || vFSBrowser.getMode() == 4) {
            this.addSeparator();
            this.add(this.createEncodingMenu());
        }
        this.addSeparator();
        this.add(this.createPluginMenu(vFSBrowser));
        this.update();
    }

    public void update() {
        if (this.encodingMenuItems != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.encodingMenuItems.get(this.browser.currentEncoding);
            if (jRadioButtonMenuItem != null) {
                jRadioButtonMenuItem.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding.label"));
            } else {
                this.otherEncoding.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding-2.label", new String[]{this.browser.currentEncoding}));
            }
        }
    }

    private JMenuItem createMenuItem(String string) {
        return GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), "vfs.browser." + string, false);
    }

    private JMenu createEncodingMenu() {
        Iterator iterator;
        JMenu jMenu;
        ActionHandler actionHandler = new ActionHandler();
        this.encodingMenuItems = new HashMap();
        JMenu jMenu2 = jMenu = new JMenu(jEdit.getProperty("vfs.browser.commands.encoding.label"));
        this.autoDetect = new JCheckBoxMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        this.autoDetect.setSelected(this.browser.autoDetectEncoding);
        this.autoDetect.setActionCommand("auto-detect");
        this.autoDetect.addActionListener(actionHandler);
        jMenu2.add(this.autoDetect);
        jMenu2.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = MiscUtilities.getEncodings(true);
        for (int i = 0; i < stringArray.length; ++i) {
            iterator = stringArray[i];
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((String)((Object)iterator));
            jRadioButtonMenuItem.setActionCommand("encoding@" + iterator);
            jRadioButtonMenuItem.addActionListener(actionHandler);
            buttonGroup.add(jRadioButtonMenuItem);
            this.encodingMenuItems.put((String)((Object)iterator), jRadioButtonMenuItem);
            arrayList.add(jRadioButtonMenuItem);
        }
        String string = System.getProperty("file.encoding");
        if (this.encodingMenuItems.get(string) == null) {
            iterator = new JRadioButtonMenuItem(string);
            ((AbstractButton)((Object)iterator)).setActionCommand("encoding@" + string);
            ((AbstractButton)((Object)iterator)).addActionListener(actionHandler);
            buttonGroup.add((AbstractButton)((Object)iterator));
            this.encodingMenuItems.put(string, (JRadioButtonMenuItem)((Object)iterator));
            arrayList.add(iterator);
        }
        Collections.sort(arrayList, new MenuItemTextComparator());
        for (JRadioButtonMenuItem jRadioButtonMenuItem : arrayList) {
            if (jMenu2.getMenuComponentCount() > 20) {
                JMenu jMenu3 = new JMenu(jEdit.getProperty("common.more"));
                jMenu2.add(jMenu3);
                jMenu2 = jMenu3;
            }
            jMenu2.add(jRadioButtonMenuItem);
        }
        jMenu2.addSeparator();
        this.otherEncoding = new JRadioButtonMenuItem();
        this.otherEncoding.setActionCommand("other-encoding");
        this.otherEncoding.addActionListener(actionHandler);
        buttonGroup.add(this.otherEncoding);
        jMenu2.add(this.otherEncoding);
        return jMenu;
    }

    private JMenu createPluginMenu(VFSBrowser vFSBrowser) {
        JMenu jMenu = new JMenu(jEdit.getProperty("vfs.browser.plugins.label"));
        return (JMenu)vFSBrowser.createPluginsMenu(jMenu, false);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("auto-detect")) {
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.autoDetectEncoding = BrowserCommandsMenu.this.autoDetect.isSelected();
            } else if (string.equals("other-encoding")) {
                String string2 = GUIUtilities.input(BrowserCommandsMenu.this.browser, "encoding-prompt", null, jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
                if (string2 == null) {
                    return;
                }
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.currentEncoding = string2;
            } else if (string.startsWith("encoding@")) {
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.currentEncoding = string.substring(9);
            }
        }
    }
}

