/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockingFrameworkProvider;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.gui.ToolBarManager;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchBar;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends JFrame
implements EBComponent,
InputHandlerProvider {
    public static final String VIEW_DOCKING_FRAMEWORK_PROPERTY = "view.docking.framework";
    private static final String ORIGINAL_DOCKING_FRAMEWORK = "Original";
    public static final String DOCKING_FRAMEWORK_PROVIDER_SERVICE = "org.gjt.sp.jedit.gui.DockingFrameworkProvider";
    private static DockingFrameworkProvider dockingFrameworkProvider;
    public static final int TOP_GROUP = 0;
    public static final int BOTTOM_GROUP = 1;
    public static final int DEFAULT_GROUP = 0;
    public static final int TOP_LAYER = Integer.MAX_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int BOTTOM_LAYER = Integer.MIN_VALUE;
    public static final int ABOVE_SYSTEM_BAR_LAYER = 150;
    public static final int SYSTEM_BAR_LAYER = 100;
    public static final int BELOW_SYSTEM_BAR_LAYER = 75;
    public static final int SEARCH_BAR_LAYER = 75;
    public static final int BELOW_SEARCH_BAR_LAYER = 50;
    @Deprecated
    public static final int ABOVE_ACTION_BAR_LAYER = -50;
    public static final int ACTION_BAR_LAYER = -75;
    public static final int STATUS_BAR_LAYER = -100;
    public static final int BELOW_STATUS_BAR_LAYER = -150;
    public static final int VIEW = 0;
    public static final int TEXT_AREA = 1;
    public static final int ACTION_BAR = 2;
    View prev;
    View next;
    private boolean closed;
    private DockableWindowManager dockableWindowManager;
    private JPanel mainPanel;
    private JPanel topToolBars;
    private JPanel bottomToolBars;
    private ToolBarManager toolBarManager;
    private Container toolBar;
    private SearchBar searchBar;
    private ActionBar actionBar;
    private EditPane editPane;
    private JSplitPane splitPane;
    private String lastSplitConfig;
    private final BufferSet localBufferSet;
    private StatusBar status;
    private InputHandler inputHandler;
    private Macros.Recorder recorder;
    private Component prefixFocusOwner;
    private int waitCount;
    private boolean showFullPath;
    private boolean plainView;
    private Socket waitSocket;
    private Component mainContent;
    private boolean fullScreenMode = false;
    private Rectangle windowedBounds;
    private JMenuBar menuBar = null;

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public static String getDockingFrameworkName() {
        String string = jEdit.getProperty(VIEW_DOCKING_FRAMEWORK_PROPERTY, ORIGINAL_DOCKING_FRAMEWORK);
        return string;
    }

    public static DockingFrameworkProvider getDockingFrameworkProvider() {
        String string;
        if (dockingFrameworkProvider == null && (dockingFrameworkProvider = (DockingFrameworkProvider)ServiceManager.getService(DOCKING_FRAMEWORK_PROVIDER_SERVICE, string = View.getDockingFrameworkName())) == null) {
            Log.log(9, View.class, "No docking framework " + string + " available, using the original one");
            dockingFrameworkProvider = (DockingFrameworkProvider)ServiceManager.getService(DOCKING_FRAMEWORK_PROVIDER_SERVICE, ORIGINAL_DOCKING_FRAMEWORK);
        }
        return dockingFrameworkProvider;
    }

    public Container getToolBar() {
        return this.toolBar;
    }

    public void addToolBar(Component component) {
        this.addToolBar(0, 0, component);
    }

    public void addToolBar(int n, Component component) {
        this.addToolBar(n, 0, component);
    }

    public void addToolBar(int n, int n2, Component component) {
        this.toolBarManager.addToolBar(n, n2, component);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component component) {
        if (this.toolBarManager == null) {
            return;
        }
        if (component == null) {
            return;
        }
        this.toolBarManager.removeToolBar(component);
        this.getRootPane().revalidate();
    }

    public synchronized void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public synchronized void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public final SearchBar getSearchBar() {
        return this.searchBar;
    }

    public final ActionBar getActionBar() {
        return this.actionBar;
    }

    public StatusBar getStatus() {
        return this.status;
    }

    public void quickIncrementalSearch(boolean bl) {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(false);
        JEditTextArea jEditTextArea = this.getTextArea();
        if (bl) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                jEditTextArea.selectWord();
                string = jEditTextArea.getSelectedText();
            } else if (string.indexOf(10) != -1) {
                string = null;
            }
            if (string != null && SearchAndReplace.getRegexp()) {
                string = SearchAndReplace.escapeRegexp(string, false);
            }
            this.searchBar.getField().setText(string);
        }
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void quickHyperSearch(boolean bl) {
        JEditTextArea jEditTextArea = this.getTextArea();
        if (bl) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                jEditTextArea.selectWord();
                string = jEditTextArea.getSelectedText();
            }
            if (string != null && string.indexOf(10) == -1) {
                if (SearchAndReplace.getRegexp()) {
                    string = SearchAndReplace.escapeRegexp(string, false);
                }
                HistoryModel.getModel("find").addItem(string);
                SearchAndReplace.setSearchString(string);
                SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
                SearchAndReplace.hyperSearch(this);
                return;
            }
        }
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(true);
        this.searchBar.getField().setText(null);
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void actionBar() {
        if (this.actionBar == null) {
            this.actionBar = new ActionBar(this, true);
        }
        if (this.actionBar.getParent() == null) {
            this.addToolBar(1, -75, this.actionBar);
        }
        this.actionBar.goToActionBar();
    }

    public KeyListener getKeyEventInterceptor() {
        return this.inputHandler.getKeyEventInterceptor();
    }

    public void setKeyEventInterceptor(KeyListener keyListener) {
        this.inputHandler.setKeyEventInterceptor(keyListener);
    }

    @Override
    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public Macros.Recorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(Macros.Recorder recorder) {
        this.recorder = recorder;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        this.inputHandler.processKeyEvent(keyEvent, 0, false);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent, boolean bl) {
        this.processKeyEvent(keyEvent, bl ? 1 : 0);
    }

    public void processKeyEvent(KeyEvent keyEvent, int n) {
        this.processKeyEvent(keyEvent, n, false);
    }

    @Deprecated
    public void processKeyEvent(KeyEvent keyEvent, int n, boolean bl) {
        this.inputHandler.processKeyEvent(keyEvent, n, bl);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int n) {
        PerspectiveManager.setPerspectiveDirty(true);
        this.editPane.saveCaretInfo();
        EditPane editPane = this.editPane;
        String string = jEdit.getProperty("editpane.bufferset.new");
        BufferSetManager.NewBufferSetAction newBufferSetAction = BufferSetManager.NewBufferSetAction.fromString(string);
        EditPane editPane2 = newBufferSetAction == BufferSetManager.NewBufferSetAction.empty ? this.createEditPane(null) : this.createEditPane(editPane.getBuffer());
        editPane2.loadCaretInfo();
        JComponent jComponent = (JComponent)editPane.getParent();
        final JSplitPane jSplitPane = new JSplitPane(n, jEdit.getBooleanProperty("appearance.continuousLayout"));
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setBorder(null);
        jSplitPane.setMinimumSize(new Dimension(0, 0));
        jSplitPane.setResizeWeight(0.5);
        int n2 = n == 0 ? editPane.getHeight() : editPane.getWidth();
        final int n3 = (int)((double)(n2 - jSplitPane.getDividerSize()) * 0.5);
        jSplitPane.setDividerLocation(n3);
        if (jComponent instanceof JSplitPane) {
            JSplitPane jSplitPane2 = (JSplitPane)jComponent;
            int n4 = jSplitPane2.getDividerLocation();
            Component component = jSplitPane2.getLeftComponent();
            if (component == editPane) {
                jSplitPane2.setLeftComponent(jSplitPane);
            } else {
                jSplitPane2.setRightComponent(jSplitPane);
            }
            jSplitPane.setLeftComponent(editPane);
            jSplitPane.setRightComponent(editPane2);
            jSplitPane2.setDividerLocation(n4);
        } else {
            this.splitPane = jSplitPane;
            jSplitPane.setLeftComponent(editPane);
            jSplitPane.setRightComponent(editPane2);
            this.setMainContent(jSplitPane);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jSplitPane.setDividerLocation(n3);
            }
        });
        editPane2.focusOnTextArea();
        return editPane2;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            for (EditPane editPane : this.getEditPanes()) {
                if (this.editPane == editPane) continue;
                View.mergeBufferSets(this.editPane, editPane);
                editPane.close();
            }
            this.setMainContent(this.editPane);
            this.splitPane = null;
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            int n;
            Container container;
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            for (container = this.editPane; !(container instanceof JSplitPane) && container != null; container = container.getParent()) {
            }
            EditPane[] editPaneArray = this.getEditPanes();
            int n2 = editPaneArray.length;
            for (n = 0; n < n2; ++n) {
                EditPane editPane = editPaneArray[n];
                if (!GUIUtilities.isAncestorOf(container, editPane) || editPane == this.editPane) continue;
                View.mergeBufferSets(this.editPane, editPane);
                editPane.close();
            }
            EditPane[] editPaneArray2 = editPaneArray = container == null ? null : (EditPane[])container.getParent();
            if (editPaneArray instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)editPaneArray;
                n = jSplitPane.getDividerLocation();
                if (jSplitPane.getLeftComponent() == container) {
                    jSplitPane.setLeftComponent(this.editPane);
                } else {
                    jSplitPane.setRightComponent(this.editPane);
                }
                jSplitPane.setDividerLocation(n);
                editPaneArray.revalidate();
            } else {
                this.setMainContent(this.editPane);
                this.splitPane = null;
            }
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void resplit() {
        if (this.lastSplitConfig == null) {
            this.getToolkit().beep();
        } else {
            this.setSplitConfig(null, this.lastSplitConfig);
        }
    }

    public String getSplitConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.splitPane != null) {
            View.getSplitConfig(this.splitPane, stringBuilder);
        } else {
            View.appendToSplitConfig(stringBuilder, this.editPane);
        }
        return stringBuilder.toString();
    }

    public void setSplitConfig(Buffer buffer, String string) {
        try {
            Component component = this.restoreSplitConfig(buffer, string);
            this.setMainContent(component);
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    public void nextTextArea() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            if (this.editPane != editPaneArray[i]) continue;
            if (i == editPaneArray.length - 1) {
                editPaneArray[0].focusOnTextArea();
                break;
            }
            editPaneArray[i + 1].focusOnTextArea();
            break;
        }
    }

    public void prevTextArea() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            if (this.editPane != editPaneArray[i]) continue;
            if (i == 0) {
                editPaneArray[editPaneArray.length - 1].focusOnTextArea();
                break;
            }
            editPaneArray[i - 1].focusOnTextArea();
            break;
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public Buffer getBuffer() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getBuffer();
    }

    public void setBuffer(Buffer buffer) {
        this.setBuffer(buffer, false);
    }

    public void setBuffer(Buffer buffer, boolean bl) {
        this.setBuffer(buffer, bl, true);
    }

    public void setBuffer(Buffer buffer, boolean bl, boolean bl2) {
        this.editPane.setBuffer(buffer, bl2);
        int n = jEdit.getIntegerProperty("checkFileStatus");
        if (!(bl || n != 1 && n != 2 && n != 3)) {
            jEdit.checkBufferStatus(this, true);
        }
    }

    public EditPane goToBuffer(Buffer buffer) {
        return this.showBuffer(buffer, true);
    }

    public EditPane showBuffer(Buffer buffer) {
        return this.showBuffer(buffer, false);
    }

    public JEditTextArea getTextArea() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getTextArea();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        if (this.splitPane == null) {
            EditPane[] editPaneArray = new EditPane[]{this.editPane};
            return editPaneArray;
        }
        ArrayList<EditPane> arrayList = new ArrayList<EditPane>();
        View.getEditPanes(arrayList, this.splitPane);
        EditPane[] editPaneArray = new EditPane[arrayList.size()];
        arrayList.toArray(editPaneArray);
        return editPaneArray;
    }

    public BufferSet getLocalBufferSet() {
        return this.localBufferSet;
    }

    public ViewConfig getViewConfig() {
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.plainView = this.isPlainView();
        viewConfig.splitConfig = this.getSplitConfig();
        viewConfig.extState = this.getExtendedState();
        viewConfig.docking = this.dockableWindowManager.getDockingLayout(viewConfig);
        String string = viewConfig.plainView ? "plain-view" : "view";
        switch (viewConfig.extState) {
            case 1: 
            case 6: {
                viewConfig.x = jEdit.getIntegerProperty(string + ".x", this.getX());
                viewConfig.y = jEdit.getIntegerProperty(string + ".y", this.getY());
                viewConfig.width = jEdit.getIntegerProperty(string + ".width", this.getWidth());
                viewConfig.height = jEdit.getIntegerProperty(string + ".height", this.getHeight());
                break;
            }
            case 4: {
                viewConfig.x = this.getX();
                viewConfig.y = jEdit.getIntegerProperty(string + ".y", this.getY());
                viewConfig.width = this.getWidth();
                viewConfig.height = jEdit.getIntegerProperty(string + ".height", this.getHeight());
                break;
            }
            case 2: {
                viewConfig.x = jEdit.getIntegerProperty(string + ".x", this.getX());
                viewConfig.y = this.getY();
                viewConfig.width = jEdit.getIntegerProperty(string + ".width", this.getWidth());
                viewConfig.height = this.getHeight();
                break;
            }
            default: {
                viewConfig.x = this.getX();
                viewConfig.y = this.getY();
                viewConfig.width = this.getWidth();
                viewConfig.height = this.getHeight();
            }
        }
        return viewConfig;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public View getNext() {
        return this.next;
    }

    public View getPrev() {
        return this.prev;
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (eBMessage instanceof SearchSettingsChanged) {
            if (this.searchBar != null) {
                this.searchBar.update();
            }
        } else if (eBMessage instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)eBMessage);
        } else if (eBMessage instanceof EditPaneUpdate) {
            this.handleEditPaneUpdate((EditPaneUpdate)eBMessage);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setWaitSocket(Socket socket) {
        this.waitSocket = socket;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '[' + (jEdit.getActiveView() == this ? "active" : "inactive") + ']';
    }

    public void updateTitle() {
        ArrayList<Buffer> arrayList = new ArrayList<Buffer>();
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            Buffer buffer = editPaneArray[i].getBuffer();
            if (arrayList.contains(buffer)) continue;
            arrayList.add(buffer);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!OperatingSystem.isMacOS()) {
            stringBuilder.append(jEdit.getProperty("view.title"));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            Buffer buffer = (Buffer)arrayList.get(i);
            stringBuilder.append(this.showFullPath && !buffer.isNewFile() ? buffer.getPath(true) : buffer.getName());
            if (!buffer.isDirty()) continue;
            stringBuilder.append(jEdit.getProperty("view.title.dirty"));
        }
        this.setTitle(stringBuilder.toString());
    }

    public Component getPrefixFocusOwner() {
        return this.prefixFocusOwner;
    }

    public void setPrefixFocusOwner(Component component) {
        this.prefixFocusOwner = component;
    }

    public void visit(JEditVisitor jEditVisitor) {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            EditPane editPane = editPaneArray[i];
            jEditVisitor.visit(editPane);
            jEditVisitor.visit(editPane.getTextArea());
        }
    }

    View(Buffer buffer, ViewConfig viewConfig) {
        this.plainView = viewConfig.plainView;
        this.enableEvents(8L);
        this.setIconImage(GUIUtilities.getEditorIcon());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.dockableWindowManager = View.getDockingFrameworkProvider().create(this, DockableWindowFactory.getInstance(), viewConfig);
        this.dockableWindowManager.setMainPanel(this.mainPanel);
        this.topToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.bottomToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.toolBarManager = new ToolBarManager(this.topToolBars, this.bottomToolBars);
        this.status = new StatusBar(this);
        this.inputHandler = new DefaultInputHandler(this, (DefaultInputHandler)jEdit.getInputHandler());
        this.localBufferSet = new BufferSet();
        this.setSplitConfig(buffer, viewConfig.splitConfig);
        this.getContentPane().add("Center", this.dockableWindowManager);
        this.dockableWindowManager.init();
        this.propertiesChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        EditBus.addToBus(this);
        GUIUtilities.addSizeSaver(this, null, this.plainView ? "plain-view" : "view");
    }

    public void updateFullScreenProps() {
        boolean bl = jEdit.getBooleanProperty("view.toolbar.alternateLayout");
        boolean bl2 = jEdit.getBooleanProperty("fullScreenIncludesMenu");
        boolean bl3 = jEdit.getBooleanProperty("fullScreenIncludesToolbar");
        boolean bl4 = jEdit.getBooleanProperty("fullScreenIncludesStatus");
        if (!bl2) {
            this.menuBar = this.getJMenuBar();
            this.setJMenuBar(null);
        } else if (this.menuBar != null) {
            this.setJMenuBar(this.menuBar);
        }
        if (bl) {
            if (!bl3) {
                this.getContentPane().remove(this.topToolBars);
            } else {
                this.getContentPane().add("North", this.topToolBars);
            }
            if (!bl4) {
                this.removeToolBar(this.status);
            } else {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            if (!bl3) {
                this.mainPanel.remove(this.topToolBars);
            } else {
                this.mainPanel.add((Component)this.topToolBars, "North");
            }
            if (!bl4) {
                this.getContentPane().remove(this.status);
            } else {
                this.getContentPane().add("South", this.status);
            }
        }
    }

    public void toggleFullScreen() {
        this.fullScreenMode = !this.fullScreenMode;
        GraphicsDevice graphicsDevice = this.getGraphicsConfiguration().getDevice();
        this.dispose();
        if (this.fullScreenMode) {
            this.updateFullScreenProps();
            this.windowedBounds = this.getBounds();
            this.setUndecorated(true);
            this.setBounds(graphicsDevice.getDefaultConfiguration().getBounds());
            this.validate();
        } else {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible");
            if (this.menuBar != null && this.getJMenuBar() != this.menuBar) {
                this.setJMenuBar(this.menuBar);
            }
            if (bl = jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
                this.getContentPane().add("North", this.topToolBars);
                if (bl2) {
                    this.addToolBar(1, -100, this.status);
                }
            } else {
                this.mainPanel.add((Component)this.topToolBars, "North");
                if (bl2) {
                    this.getContentPane().add("South", this.status);
                }
            }
            this.setUndecorated(false);
            this.setBounds(this.windowedBounds);
        }
        this.setVisible(true);
        this.toFront();
        this.editPane.getTextArea().requestFocus();
    }

    boolean confirmToCloseDirty() {
        Set<Buffer> set = this.getOpenBuffers();
        for (View view : jEdit.getViews()) {
            if (view == this) continue;
            set.removeAll(view.getOpenBuffers());
        }
        for (Buffer buffer : set) {
            if (!buffer.isDirty()) continue;
            return new CloseDialog(this, set).isOK();
        }
        return true;
    }

    void close() {
        EditBus.send(new ViewUpdate(this, ViewUpdate.CLOSED));
        this.closed = true;
        this.dockableWindowManager.close();
        EditBus.removeFromBus(this);
        this.dispose();
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            editPaneArray[i].close();
        }
        this.toolBarManager = null;
        this.toolBar = null;
        this.searchBar = null;
        this.splitPane = null;
        this.inputHandler = null;
        this.recorder = null;
        this.getContentPane().removeAll();
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setMainContent(Component component) {
        if (this.mainContent != null) {
            this.mainPanel.remove(this.mainContent);
        }
        this.mainContent = component;
        this.mainPanel.add(this.mainContent, "Center");
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private static void getEditPanes(List<EditPane> list, Component component) {
        if (component instanceof EditPane) {
            list.add((EditPane)component);
        } else if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            View.getEditPanes(list, jSplitPane.getLeftComponent());
            View.getEditPanes(list, jSplitPane.getRightComponent());
        }
    }

    private EditPane showBuffer(Buffer buffer, boolean bl) {
        if (this.editPane.getBuffer() == buffer && this.editPane.getTextArea().getVisibleLines() > 1) {
            if (bl) {
                this.editPane.focusOnTextArea();
            }
            return this.editPane;
        }
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            EditPane editPane = editPaneArray[i];
            if (editPane.getBuffer() != buffer || editPane.getTextArea().getVisibleLines() <= 1) continue;
            this.setEditPane(editPane);
            if (bl) {
                editPane.focusOnTextArea();
            }
            return editPane;
        }
        this.setBuffer(buffer, false, bl);
        return this.editPane;
    }

    private static void getSplitConfig(JSplitPane jSplitPane, StringBuilder stringBuilder) {
        Component component = jSplitPane.getRightComponent();
        View.appendToSplitConfig(stringBuilder, component);
        stringBuilder.append(' ');
        Component component2 = jSplitPane.getLeftComponent();
        View.appendToSplitConfig(stringBuilder, component2);
        stringBuilder.append(' ');
        stringBuilder.append(jSplitPane.getDividerLocation());
        stringBuilder.append(' ');
        stringBuilder.append(jSplitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    private static void appendToSplitConfig(StringBuilder stringBuilder, Component component) {
        if (component instanceof JSplitPane) {
            View.getSplitConfig((JSplitPane)component, stringBuilder);
        } else {
            Buffer[] bufferArray;
            EditPane editPane = (EditPane)component;
            stringBuilder.append('\"');
            stringBuilder.append(StandardUtilities.charsToEscapes(editPane.getBuffer().getPath()));
            stringBuilder.append("\" buffer");
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buffer : bufferArray = bufferSet.getAllBuffers()) {
                if (buffer.isNewFile()) continue;
                stringBuilder.append(" \"");
                stringBuilder.append(StandardUtilities.charsToEscapes(buffer.getPath()));
                stringBuilder.append("\" buff");
            }
            stringBuilder.append(" \"");
            stringBuilder.append((Object)editPane.getBufferSetScope());
            stringBuilder.append("\" bufferset");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Component restoreSplitConfig(Buffer var1_1, String var2_2) throws IOException {
        if (var1_1 != null) {
            this.editPane = this.createEditPane(var1_1);
            return this.editPane;
        }
        if (var2_2 == null) {
            this.editPane = this.createEditPane(jEdit.getFirstBuffer());
            return this.editPane;
        }
        var3_3 = jEdit.getBuffers();
        var4_4 = new Stack<Object>();
        var5_5 = new StreamTokenizer(new StringReader(var2_2));
        var5_5.whitespaceChars(0, 32);
        var5_5.wordChars(35, 126);
        var5_5.commentChar(33);
        var5_5.quoteChar(34);
        var5_5.eolIsSignificant(false);
        var6_6 = jEdit.getBooleanProperty("appearance.continuousLayout");
        var7_7 = new ArrayList<Buffer>();
        block6: while (true) {
            switch (var5_5.nextToken()) {
                case -1: {
                    break block6;
                }
                case -3: {
                    if (var5_5.sval.equals("vertical") || var5_5.sval.equals("horizontal")) {
                        var8_8 = var5_5.sval.equals("vertical") != false ? 0 : 1;
                        var9_13 = (Integer)var4_4.pop();
                        var10_16 /* !! */  = var4_4.pop();
                        var11_19 /* !! */  = var4_4.pop();
                        if (var10_16 /* !! */  instanceof Buffer) {
                            var1_1 = (Buffer)var10_16 /* !! */ ;
                            var12_21 = var1_1;
                            jEdit.getGlobalBufferSet().addBufferAt((Buffer)var12_21, -1);
                            this.editPane = this.createEditPane((Buffer)var12_21, BufferSet.Scope.global);
                            var10_16 /* !! */  = this.editPane;
                        }
                        if (var11_19 /* !! */  instanceof Buffer) {
                            var12_21 = (Buffer)var11_19 /* !! */ ;
                            jEdit.getGlobalBufferSet().addBufferAt((Buffer)var12_21, -1);
                            var11_19 /* !! */  = this.createEditPane((Buffer)var12_21, BufferSet.Scope.global);
                        }
                        this.splitPane = new JSplitPane(var8_8, var6_6, (Component)var10_16 /* !! */ , (Component)var11_19 /* !! */ );
                        var4_4.push(this.splitPane);
                        this.splitPane.setOneTouchExpandable(true);
                        this.splitPane.setBorder(null);
                        this.splitPane.setMinimumSize(new Dimension(0, 0));
                        this.splitPane.setDividerLocation(var9_13);
                    } else if (var5_5.sval.equals("buffer")) {
                        var8_9 = var4_4.pop();
                        if (var8_9 instanceof Integer) {
                            var9_13 = (Integer)var8_9;
                            if (var9_13 >= 0 && var9_13 < var3_3.length) {
                                var1_1 = var3_3[var9_13];
                            }
                        } else if (var8_9 instanceof String && (var1_1 = jEdit.getBuffer(var9_14 = (String)var8_9)) == null) {
                            var10_17 = jEdit.getNextUntitledBufferId();
                            var1_1 = jEdit.openFile(this, null, "Untitled-" + var10_17, true, null);
                        }
                        if (var1_1 == null) {
                            var1_1 = jEdit.getFirstBuffer();
                        }
                        var4_4.push(var1_1);
                    } else if (var5_5.sval.equals("buff")) {
                        var8_10 = (String)var4_4.pop();
                        var1_1 = jEdit.getBuffer(var8_10);
                        if (var1_1 == null) {
                            Log.log(7, this, "Buffer " + var8_10 + " doesn't exist");
                        } else {
                            var7_7.add(var1_1);
                        }
                    } else if (var5_5.sval.equals("bufferset")) {
                        var8_11 = BufferSet.Scope.fromString((String)var4_4.pop());
                        var1_1 = (Buffer)var4_4.pop();
                        this.editPane = this.createEditPane(var1_1, var8_11);
                        var4_4.push(this.editPane);
                        var9_15 = jEdit.getBufferSetManager();
                        var10_18 = this.editPane.getBufferSet();
                        var11_20 = 0;
                        for (Buffer var13_22 : var7_7) {
                            if (var13_22 == var1_1) {
                                var10_18.addBufferAt(var1_1, var11_20);
                            } else {
                                var9_15.addBuffer(var10_18, var13_22);
                            }
                            ++var11_20;
                        }
                        var7_7.clear();
                    }
                    ** GOTO lbl94
                }
                case -2: {
                    var4_4.push((int)var5_5.nval);
                    ** GOTO lbl94
                }
                case 34: {
                    var4_4.push(var5_5.sval);
                }
lbl94:
                // 8 sources

                default: {
                    continue block6;
                }
            }
            break;
        }
        var8_12 /* !! */  = var4_4.peek();
        if (var8_12 /* !! */  instanceof Buffer) {
            jEdit.getGlobalBufferSet().addBufferAt((Buffer)var8_12 /* !! */ , -1);
            this.editPane = this.createEditPane((Buffer)var8_12 /* !! */ , BufferSet.Scope.global);
            var8_12 /* !! */  = this.editPane;
        }
        this.updateGutterBorders();
        return (Component)var8_12 /* !! */ ;
    }

    private void propertiesChanged() {
        boolean bl;
        this.setJMenuBar(GUIUtilities.loadMenuBar("view.mbar"));
        this.loadToolBars();
        this.showFullPath = jEdit.getBooleanProperty("view.showFullPath");
        this.updateTitle();
        this.status.propertiesChanged();
        this.removeToolBar(this.status);
        this.getContentPane().remove(this.status);
        boolean bl2 = bl = this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible");
        if (jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
            this.getContentPane().add("North", this.topToolBars);
            this.getContentPane().add("South", this.bottomToolBars);
            if (bl) {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            this.mainPanel.add((Component)this.topToolBars, "North");
            this.mainPanel.add((Component)this.bottomToolBars, "South");
            if (bl) {
                this.getContentPane().add("South", this.status);
            }
        }
        this.updateBufferSwitcherStates();
        this.getRootPane().revalidate();
        if (this.splitPane != null) {
            GUIUtilities.initContinuousLayout(this.splitPane);
        }
        if (this.fullScreenMode) {
            this.updateFullScreenProps();
        }
    }

    public void updateBufferSwitcherStates() {
        Component component;
        int n;
        boolean bl = jEdit.getBooleanProperty("view.showBufferSwitcher");
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        String string = jEdit.getProperty("view.label");
        string = string.replace("$", "");
        String string2 = jEdit.getProperty("focus-buffer-switcher.label");
        string2 = string2.replace("$", "");
        JMenu jMenu = null;
        for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
            component = jMenuBar.getMenu(n);
            if (!component.getText().equals(string)) continue;
            jMenu = component;
            break;
        }
        if (jMenu != null) {
            for (n = 0; n < jMenu.getMenuComponentCount(); ++n) {
                component = jMenu.getMenuComponent(n);
                if (!(component instanceof JMenuItem) || !((JMenuItem)component).getText().equals(string2)) continue;
                ((JMenuItem)component).setEnabled(bl);
            }
        }
        for (View view : jEdit.getViews()) {
            for (EditPane editPane : view.getEditPanes()) {
                editPane.loadBufferSwitcher();
            }
        }
    }

    private void loadToolBars() {
        if (jEdit.getBooleanProperty("view.showToolbar") && !this.plainView) {
            if (this.toolBar != null) {
                this.toolBarManager.removeToolBar(this.toolBar);
            }
            this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
            this.addToolBar(0, 100, this.toolBar);
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.searchBar != null) {
            this.searchBar.propertiesChanged();
            this.removeToolBar(this.searchBar);
        }
        if (jEdit.getBooleanProperty("view.showSearchbar") && !this.plainView) {
            if (this.searchBar == null) {
                this.searchBar = new SearchBar(this, false);
            }
            this.addToolBar(0, 75, this.searchBar);
        }
    }

    private EditPane createEditPane(Buffer buffer) {
        return this.createEditPane(buffer, BufferSet.Scope.fromString(jEdit.getProperty("editpane.bufferset.default")));
    }

    private EditPane createEditPane(Buffer buffer, BufferSet.Scope scope) {
        EditPane editPane = new EditPane(this, buffer, scope);
        JEditTextArea jEditTextArea = editPane.getTextArea();
        jEditTextArea.addFocusListener(new FocusHandler());
        jEditTextArea.addCaretListener(new CaretHandler());
        jEditTextArea.addScrollListener(new ScrollHandler());
        EditBus.send(new EditPaneUpdate(editPane, EditPaneUpdate.CREATED));
        return editPane;
    }

    private void setEditPane(EditPane editPane) {
        this.editPane = editPane;
        this.status.updateCaretStatus();
        this.status.updateBufferStatus();
        this.status.updateMiscStatus();
        this.updateGutterBorders();
        EditBus.send(new ViewUpdate(this, ViewUpdate.EDIT_PANE_CHANGED));
    }

    private void handleBufferUpdate(BufferUpdate bufferUpdate) {
        Buffer buffer = bufferUpdate.getBuffer();
        if (bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED || bufferUpdate.getWhat() == BufferUpdate.LOADED) {
            EditPane[] editPaneArray = this.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                if (editPaneArray[i].getBuffer() != buffer) continue;
                this.updateTitle();
                break;
            }
        }
    }

    private void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPane.getView() == this && editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane.getBuffer().isLoaded()) {
            this.closeDuplicateBuffers(editPaneUpdate);
            this.status.updateCaretStatus();
            this.status.updateBufferStatus();
            this.status.updateMiscStatus();
        }
    }

    private void closeDuplicateBuffers(EditPaneUpdate editPaneUpdate) {
        if (!jEdit.getBooleanProperty("buffersets.exclusive")) {
            return;
        }
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPane.getView() != this) {
            return;
        }
        Buffer buffer = editPane.getBuffer();
        for (View view : jEdit.getViews()) {
            for (EditPane editPane2 : view.getEditPanes()) {
                if (editPane2 == editPane || editPane2.getBufferSetScope() == BufferSet.Scope.view && view == this || editPane2.getBufferSet() == jEdit.getGlobalBufferSet() || editPane2.getBufferSet().indexOf(buffer) < 0) continue;
                jEdit.getBufferSetManager().removeBuffer(editPane2, buffer);
            }
        }
    }

    private void updateGutterBorders() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            editPaneArray[i].getTextArea().getGutter().updateBorder();
        }
    }

    private Set<Buffer> getOpenBuffers() {
        HashSet<Buffer> hashSet = new HashSet<Buffer>();
        for (EditPane editPane : this.getEditPanes()) {
            hashSet.addAll(Arrays.asList(editPane.getBufferSet().getAllBuffers()));
        }
        return hashSet;
    }

    private static void mergeBufferSets(EditPane editPane, EditPane editPane2) {
        BufferSet bufferSet;
        BufferSet bufferSet2 = editPane2.getBufferSet();
        if (bufferSet2 != (bufferSet = editPane.getBufferSet())) {
            jEdit.getBufferSetManager().mergeBufferSet(bufferSet, bufferSet2);
        }
    }

    private boolean isInsideScreen(View view, Rectangle rectangle) {
        Rectangle rectangle2 = view == null ? GUIUtilities.getScreenBounds() : view.getGraphicsConfiguration().getBounds();
        int n = jEdit.getIntegerProperty("view.minStartupWidth");
        int n2 = jEdit.getIntegerProperty("view.minStartupHeight");
        return rectangle.x < rectangle2.width - n && rectangle.x + rectangle.width > n && rectangle.y < rectangle2.height - n2 && rectangle.y + rectangle.height > n2;
    }

    public void adjust(View view, ViewConfig viewConfig) {
        if (viewConfig.width != 0 && viewConfig.height != 0) {
            Rectangle rectangle = new Rectangle(viewConfig.x, viewConfig.y, viewConfig.width, viewConfig.height);
            if (!this.isInsideScreen(view, rectangle)) {
                this.setLocationRelativeTo(view);
            } else if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
                new GUIUtilities.UnixWorkaround(this, "view", rectangle, viewConfig.extState);
            } else {
                this.setBounds(rectangle);
                this.setExtendedState(viewConfig.extState);
            }
        } else {
            this.setLocationRelativeTo(view);
        }
    }

    private static class SetCursorVisitor
    extends JEditVisitorAdapter {
        private final Cursor cursor;

        SetCursorVisitor(Cursor cursor) {
            this.cursor = cursor;
        }

        public void visit(EditPane editPane) {
            editPane.setCursor(this.cursor);
        }
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        public Component getDefaultComponent(Container container) {
            return GUIUtilities.getView(container).getTextArea();
        }
    }

    public static class ViewConfig {
        public int x;
        public int y;
        public int width;
        public int height;
        public int extState;
        public boolean plainView;
        public String splitConfig;
        public DockableWindowManager.DockingLayout docking;

        public ViewConfig() {
        }

        public ViewConfig(boolean bl) {
            this.plainView = bl;
            String string = bl ? "plain-view" : "view";
            this.x = jEdit.getIntegerProperty(string + ".x", 0);
            this.y = jEdit.getIntegerProperty(string + ".y", 0);
            this.width = jEdit.getIntegerProperty(string + ".width", 0);
            this.height = jEdit.getIntegerProperty(string + ".height", 0);
            this.extState = jEdit.getIntegerProperty(string + ".extendedState", 0);
        }

        public ViewConfig(boolean bl, String string, int n, int n2, int n3, int n4, int n5) {
            this.plainView = bl;
            this.splitConfig = string;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.extState = n5;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            boolean bl = jEdit.getActiveViewInternal() != View.this;
            jEdit.setActiveView(View.this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = jEdit.getIntegerProperty("checkFileStatus");
                    if (n == 0 || n == 1) {
                        jEdit.checkBufferStatus(View.this, false);
                    } else if (n == 3) {
                        jEdit.checkBufferStatus(View.this, true);
                    }
                }
            });
            if (bl) {
                EditBus.send(new ViewUpdate(View.this, ViewUpdate.ACTIVATED));
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            jEdit.closeView(View.this);
        }
    }

    private class ScrollHandler
    implements ScrollListener {
        private ScrollHandler() {
        }

        public void scrolledVertically(TextArea textArea) {
            if (View.this.getTextArea() == textArea) {
                View.this.status.updateCaretStatus();
            }
        }

        public void scrolledHorizontally(TextArea textArea) {
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            while (!(component instanceof EditPane)) {
                if (component == null) {
                    return;
                }
                component = component.getParent();
            }
            if (component != View.this.editPane) {
                View.this.setEditPane((EditPane)component);
            } else {
                View.this.updateGutterBorders();
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (caretEvent.getSource() == View.this.getTextArea()) {
                View.this.status.updateCaretStatus();
            }
        }
    }
}

