/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ServiceListHandler
extends DefaultHandler {
    private PluginJAR plugin;
    private URL uri;
    private String serviceName;
    private String serviceClass;
    private StringBuilder code;
    private Stack<String> stateStack;
    private List<ServiceManager.Descriptor> cachedServices;

    ServiceListHandler(PluginJAR pluginJAR, URL uRL) {
        this.plugin = pluginJAR;
        this.uri = uRL;
        this.code = new StringBuilder();
        this.stateStack = new Stack();
        this.cachedServices = new LinkedList<ServiceManager.Descriptor>();
    }

    public InputSource resolveEntity(String string, String string2) {
        return XMLUtilities.findEntity(string2, "services.dtd", this.getClass());
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        if (string == "SERVICE") {
            this.code.append(cArray, n, n2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        string3 = this.pushElement(string3);
        this.serviceName = attributes.getValue("NAME");
        this.serviceClass = attributes.getValue("CLASS");
    }

    public void endElement(String string, String string2, String string3) {
        String string4 = this.peekElement();
        if (string3.equals(string4)) {
            if (string4.equals("SERVICE")) {
                ServiceManager.Descriptor descriptor = new ServiceManager.Descriptor(this.serviceClass, this.serviceName, this.code.toString(), this.plugin);
                ServiceManager.registerService(descriptor);
                this.cachedServices.add(descriptor);
                this.code.setLength(0);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception exception) {
            Log.log(9, exception, exception);
        }
    }

    public ServiceManager.Descriptor[] getCachedServices() {
        return this.cachedServices.toArray(new ServiceManager.Descriptor[this.cachedServices.size()]);
    }

    private String pushElement(String string) {
        string = string == null ? null : string.intern();
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

