/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.StringReader;
import org.gjt.sp.jedit.RegisterSaver;
import org.gjt.sp.jedit.RegistersListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers = new Register[256];
    private static boolean loaded;
    private static boolean loading;
    private static RegisterSaver saver;
    private static RegistersListener listener;
    private static boolean modified;

    public static void copy(TextArea textArea, char c) {
        String string = textArea.getSelectedText();
        if (string == null) {
            return;
        }
        Registers.setRegister(c, string);
        HistoryModel.getModel("clipboard").addItem(string);
    }

    public static void cut(TextArea textArea, char c) {
        if (textArea.isEditable()) {
            String string = textArea.getSelectedText();
            if (string == null) {
                return;
            }
            Registers.setRegister(c, string);
            HistoryModel.getModel("clipboard").addItem(string);
            textArea.setSelectedText("");
        } else {
            textArea.getToolkit().beep();
        }
    }

    public static void append(TextArea textArea, char c) {
        Registers.append(textArea, c, "\n", false);
    }

    public static void append(TextArea textArea, char c, String string) {
        Registers.append(textArea, c, string, false);
    }

    public static void append(TextArea textArea, char c, String string, boolean bl) {
        String string2;
        if (bl && !textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        String string3 = textArea.getSelectedText();
        if (string3 == null) {
            return;
        }
        Register register = Registers.getRegister(c);
        if (register != null && (string2 = ((Object)register).toString()) != null) {
            string3 = string2.endsWith(string) ? string2 + string3 : string2 + string + string3;
        }
        Registers.setRegister(c, string3);
        HistoryModel.getModel("clipboard").addItem(string3);
        if (bl) {
            textArea.setSelectedText("");
        }
    }

    public static void paste(TextArea textArea, char c) {
        Registers.paste(textArea, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paste(TextArea textArea, char c, boolean bl) {
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        Register register = Registers.getRegister(c);
        if (register == null) {
            textArea.getToolkit().beep();
            return;
        }
        String string = ((Object)register).toString();
        if (string == null) {
            textArea.getToolkit().beep();
            return;
        }
        JEditBuffer jEditBuffer = textArea.getBuffer();
        try {
            jEditBuffer.beginCompoundEdit();
            if (bl && textArea.getSelectionCount() == 0) {
                int n = textArea.getCaretPosition();
                int n2 = textArea.getCaretLine();
                Selection.Rect rect = new Selection.Rect(n2, n, n2, n);
                textArea.setSelectedText(rect, string);
                n2 = textArea.getCaretLine();
                if (n2 != textArea.getLineCount() - 1) {
                    int n3 = rect.getStartColumn(jEditBuffer);
                    int n4 = jEditBuffer.getOffsetOfVirtualColumn(n2 + 1, n3, null);
                    if (n4 == -1) {
                        jEditBuffer.insertAtColumn(n2 + 1, n3, "");
                        textArea.setCaretPosition(jEditBuffer.getLineEndOffset(n2 + 1) - 1);
                    } else {
                        textArea.setCaretPosition(jEditBuffer.getLineStartOffset(n2 + 1) + n4);
                    }
                }
            } else {
                textArea.replaceSelection(string);
            }
        }
        finally {
            jEditBuffer.endCompoundEdit();
        }
        HistoryModel.getModel("clipboard").addItem(string);
    }

    public static Register getRegister(char c) {
        if (c != '$' && c != '%' && !loaded) {
            Registers.loadRegisters();
        }
        if (registers == null || c >= registers.length) {
            return null;
        }
        return registers[c];
    }

    public static void setRegister(char c, Register register) {
        Registers.touchRegister(c);
        if (c >= registers.length) {
            Register[] registerArray = new Register[Math.min(65536, c << 1)];
            System.arraycopy(registers, 0, registerArray, 0, registers.length);
            registers = registerArray;
        }
        Registers.registers[c] = register;
        if (listener != null) {
            listener.registerChanged(c);
        }
    }

    public static void setRegister(char c, String string) {
        Registers.touchRegister(c);
        Register register = Registers.getRegister(c);
        if (register != null) {
            register.setValue(string);
            if (listener != null) {
                listener.registerChanged(c);
            }
        } else {
            Registers.setRegister(c, new StringRegister(string));
        }
    }

    public static void clearRegister(char c) {
        if (c >= registers.length) {
            return;
        }
        Register register = registers[c];
        if (c == '$' || c == '%') {
            register.setValue("");
        } else {
            Registers.registers[c] = null;
            modified = true;
            if (listener != null) {
                listener.registerChanged(c);
            }
        }
    }

    public static Register[] getRegisters() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        return registers;
    }

    public static String getRegisterNameString() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        StringBuilder stringBuilder = new StringBuilder(registers.length << 1);
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append((char)i);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static void saveRegisters() {
        if (!loaded || !modified) {
            return;
        }
        if (saver != null) {
            saver.saveRegisters();
            modified = false;
        }
    }

    public static void setListener(RegistersListener registersListener) {
        listener = registersListener;
    }

    public static void setSaver(RegisterSaver registerSaver) {
        saver = registerSaver;
    }

    public static boolean isLoading() {
        return loading;
    }

    public static void setLoading(boolean bl) {
        loading = bl;
    }

    private Registers() {
    }

    private static void touchRegister(char c) {
        if (c == '%' || c == '$') {
            return;
        }
        if (!loaded) {
            Registers.loadRegisters();
        }
        if (!loading) {
            modified = true;
        }
    }

    private static void loadRegisters() {
        if (saver != null) {
            loaded = true;
            saver.loadRegisters();
        }
    }

    protected static void debugListDataFlavors(Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            Log.log(1, Registers.class, "debugListDataFlavors(): dataFlavor=" + dataFlavor + '.');
        }
        if (dataFlavorArray.length == 0) {
            Log.log(1, Registers.class, "debugListDataFlavors(): no dataFlavor supported.");
        }
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Registers.registers[36] = new ClipboardRegister(toolkit.getSystemClipboard());
        Clipboard clipboard = toolkit.getSystemSelection();
        if (clipboard != null) {
            Registers.registers[37] = new ClipboardRegister(clipboard);
        }
    }

    public static class StringRegister
    implements Register {
        private String value;

        public StringRegister(String string) {
            this.value = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }

        public void dispose() {
        }
    }

    public static class ClipboardRegister
    implements Register {
        Clipboard clipboard;

        public ClipboardRegister(Clipboard clipboard) {
            this.clipboard = clipboard;
        }

        public void setValue(String string) {
            StringSelection stringSelection = new StringSelection(string);
            this.clipboard.setContents(stringSelection, null);
        }

        public String toString() {
            try {
                String string;
                String string2 = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                boolean bl = string2.endsWith("\n") || string2.endsWith(System.getProperty("line.separator"));
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.endsWith("\u0000")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    stringBuilder.append(string);
                    stringBuilder.append('\n');
                }
                if (!bl && stringBuilder.length() != 0) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                Log.log(5, this, exception);
                return null;
            }
        }
    }

    public static interface Register {
        public String toString();

        public void setValue(String var1);
    }
}

