/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.HashSet;
import javax.swing.UIManager;
import org.gjt.sp.util.Log;

public class OperatingSystem {
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int VMS = 912082;
    private static final int UNKNOWN = 2989;
    private static int os;
    private static boolean java14;
    private static boolean java15;
    private static boolean java16;
    private static int hasScreenMenuBar;

    public static Rectangle getScreenBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n6 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (OperatingSystem.isMacOS()) {
            n4 = 0;
            n3 = 22;
            n2 = n5;
            n = n6 - n3 - 4;
        } else if (OperatingSystem.isWindows()) {
            n4 = -4;
            n3 = -4;
            n2 = n5 - 2 * n4;
            n = n6 - 2 * n3;
        } else {
            n4 = 0;
            n3 = 0;
            n2 = n5;
            n = n6;
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public static Rectangle getScreenBounds(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            if (!rectangle.intersects(graphicsConfiguration.getBounds()) || hashSet.contains(graphicsConfiguration)) continue;
            hashSet.add(graphicsConfiguration);
        }
        GraphicsConfiguration graphicsConfiguration = null;
        if (!hashSet.isEmpty()) {
            for (GraphicsConfiguration graphicsConfiguration2 : hashSet) {
                if (graphicsConfiguration == null) {
                    graphicsConfiguration = graphicsConfiguration2;
                    continue;
                }
                Rectangle rectangle2 = graphicsConfiguration.getBounds().intersection(rectangle);
                Rectangle rectangle3 = graphicsConfiguration2.getBounds().intersection(rectangle);
                n4 = rectangle3.width * rectangle3.height;
                n3 = rectangle2.width * rectangle2.height;
                if (n4 <= n3) continue;
                graphicsConfiguration = graphicsConfiguration2;
            }
        } else {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int n5 = graphicsConfiguration.getBounds().x;
        int n6 = graphicsConfiguration.getBounds().y;
        int n7 = graphicsConfiguration.getBounds().width;
        int n8 = graphicsConfiguration.getBounds().height;
        if (OperatingSystem.isMacOS()) {
            n3 = n5;
            n4 = n6 + 22;
            n2 = n7;
            n = n8 - n4 - 4;
        } else {
            n3 = n5;
            n4 = n6;
            n2 = n7;
            n = n8;
        }
        return new Rectangle(n3, n4, n2, n);
    }

    public static boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static boolean isWindows9x() {
        return os == 1600;
    }

    public static boolean isWindowsNT() {
        return os == 1638;
    }

    public static boolean isOS2() {
        return os == 57005;
    }

    public static boolean isUnix() {
        return os == 201527 || os == 2748;
    }

    public static boolean isMacOS() {
        return os == 2748;
    }

    public static boolean isX11() {
        return os == 201527;
    }

    public static boolean isVMS() {
        return os == 912082;
    }

    public static boolean isMacOSLF() {
        return OperatingSystem.isMacOS() && UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static boolean hasScreenMenuBar() {
        if (!OperatingSystem.isMacOS()) {
            return false;
        }
        if (hasScreenMenuBar == -1) {
            String string = System.getProperty("apple.laf.useScreenMenuBar");
            if (string == null) {
                string = System.getProperty("com.apple.macos.useScreenMenuBar");
            }
            hasScreenMenuBar = "true".equals(string) ? 1 : 0;
        }
        return hasScreenMenuBar == 1;
    }

    @Deprecated
    public static boolean hasJava14() {
        return java14;
    }

    @Deprecated
    public static boolean hasJava15() {
        return java15;
    }

    public static boolean hasJava16() {
        return java16;
    }

    public static boolean isCaseInsensitiveFS() {
        return OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS();
    }

    static {
        String string;
        hasScreenMenuBar = -1;
        if (System.getProperty("mrj.version") != null) {
            os = 2748;
        } else {
            string = System.getProperty("os.name");
            if (string.contains("Windows 9") || string.contains("Windows M")) {
                os = 1600;
            } else if (string.contains("Windows")) {
                os = 1638;
            } else if (string.contains("OS/2")) {
                os = 57005;
            } else if (string.contains("VMS")) {
                os = 912082;
            } else if (File.separatorChar == '/') {
                os = 201527;
            } else {
                os = 2989;
                Log.log(7, OperatingSystem.class, "Unknown operating system: " + string);
            }
        }
        string = System.getProperty("jedit.force.java.version");
        if (string == null || string.length() == 0) {
            string = System.getProperty("java.version");
        }
        if (string == null || string.length() == 0) {
            string = System.getProperty("java.runtime.version");
        }
        java14 = string.compareTo("1.4") >= 0;
        java15 = string.compareTo("1.5") >= 0;
        java16 = string.compareTo("1.6") >= 0;
    }
}

