/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.indent.DeepIndentRule;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.indent.IndentRuleFactory;
import org.gjt.sp.jedit.indent.WhitespaceRule;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mode {
    protected String name;
    protected Map<String, Object> props;
    private Pattern firstlineRE;
    private Pattern filenameRE;
    protected TokenMarker marker;
    private List<IndentRule> indentRules;
    private String electricKeys;
    private boolean ignoreWhitespace;

    public Mode(String string) {
        this.name = string;
        this.ignoreWhitespace = true;
        this.props = new Hashtable<String, Object>();
    }

    public void init() {
        try {
            String string;
            String string2 = (String)this.getProperty("filenameGlob");
            if (string2 != null && string2.length() != 0) {
                this.filenameRE = Pattern.compile(StandardUtilities.globToRE(string2), 2);
            }
            if ((string = (String)this.getProperty("firstlineGlob")) != null && string.length() != 0) {
                this.firstlineRE = Pattern.compile(StandardUtilities.globToRE(string), 2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Log.log(9, this, "Invalid filename/firstline globs in mode " + this.name);
            Log.log(9, this, patternSyntaxException);
        }
        this.marker = null;
    }

    public TokenMarker getTokenMarker() {
        this.loadIfNecessary();
        return this.marker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.marker = tokenMarker;
    }

    public void loadIfNecessary() {
        if (this.marker == null) {
            ModeProvider.instance.loadMode(this);
            if (this.marker == null) {
                Log.log(9, this, "Mode not correctly loaded, token marker is still null");
            }
        }
    }

    public Object getProperty(String string) {
        Object object = this.props.get(string);
        if (object != null) {
            return object;
        }
        return null;
    }

    public boolean getBooleanProperty(String string) {
        Object object = this.getProperty(string);
        return StandardUtilities.getBoolean(object, false);
    }

    public void setProperty(String string, Object object) {
        this.props.put(string, object);
    }

    public void unsetProperty(String string) {
        this.props.remove(string);
    }

    public void setProperties(Map hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        this.ignoreWhitespace = !"false".equalsIgnoreCase((String)hashtable.get("ignoreWhitespace"));
        String string = (String)this.props.get("filenameGlob");
        String string2 = (String)this.props.get("firstlineGlob");
        String string3 = (String)this.props.get("file");
        this.props = hashtable;
        if (string != null) {
            hashtable.put("filenameGlob", string);
        }
        if (string2 != null) {
            hashtable.put("firstlineGlob", string2);
        }
        if (string3 != null) {
            hashtable.put("file", string3);
        }
    }

    public boolean accept(String string, String string2) {
        return this.acceptFilename(string) || this.acceptFirstLine(string2);
    }

    public boolean acceptFilename(String string) {
        return this.filenameRE != null && this.filenameRE.matcher(string).matches();
    }

    public boolean acceptFirstLine(String string) {
        return this.firstlineRE != null && this.firstlineRE.matcher(string).matches();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean getIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public synchronized List<IndentRule> getIndentRules() {
        if (this.indentRules == null) {
            this.initIndentRules();
        }
        return this.indentRules;
    }

    public synchronized boolean isElectricKey(char c) {
        if (this.electricKeys == null) {
            String[] stringArray = new String[]{"indentOpenBrackets", "indentCloseBrackets", "electricKeys"};
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = (String)this.getProperty(stringArray[i]);
                if (string == null) continue;
                stringBuilder.append(string);
            }
            this.electricKeys = stringBuilder.toString();
        }
        return this.electricKeys.indexOf(c) >= 0;
    }

    private void initIndentRules() {
        String string;
        LinkedList<IndentRule> linkedList = new LinkedList<IndentRule>();
        String[] stringArray = new String[]{"indentNextLine", "indentNextLines"};
        for (int i = 0; i < stringArray.length; ++i) {
            IndentRule indentRule = this.createRegexpIndentRule(stringArray[i]);
            if (indentRule == null) continue;
            linkedList.add(indentRule);
        }
        String[] stringArray2 = new String[]{"indentOpenBracket", "indentCloseBracket", "unalignedOpenBracket", "unalignedCloseBracket"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.createBracketIndentRules(stringArray2[i], linkedList);
        }
        String[] stringArray3 = new String[]{"unindentThisLine", "unindentNextLines"};
        for (int i = 0; i < stringArray3.length; ++i) {
            IndentRule indentRule = this.createRegexpIndentRule(stringArray3[i]);
            if (indentRule == null) continue;
            linkedList.add(indentRule);
        }
        if (this.getBooleanProperty("deepIndent") && (string = (String)this.getProperty("unalignedOpenBrackets")) != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                char c2 = TextUtilities.getComplementaryBracket(c, null);
                if (c2 == '\u0000') continue;
                linkedList.add(new DeepIndentRule(c, c2));
            }
        }
        if (!this.getIgnoreWhitespace()) {
            linkedList.add(new WhitespaceRule());
        }
        this.indentRules = Collections.unmodifiableList(linkedList);
    }

    private IndentRule createRegexpIndentRule(String string) {
        String string2 = (String)this.getProperty(string);
        try {
            if (string2 != null) {
                Method method = IndentRuleFactory.class.getMethod(string, String.class);
                return (IndentRule)method.invoke(null, string2);
            }
        }
        catch (Exception exception) {
            Log.log(9, this, "Bad indent rule " + string + '=' + string2 + ':');
            Log.log(9, this, exception);
        }
        return null;
    }

    private void createBracketIndentRules(String string, List<IndentRule> list) {
        String string2 = (String)this.getProperty(string + 's');
        try {
            if (string2 != null) {
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    Method method = IndentRuleFactory.class.getMethod(string, Character.TYPE);
                    list.add((IndentRule)method.invoke(null, Character.valueOf(c)));
                }
            }
        }
        catch (Exception exception) {
            Log.log(9, this, "Bad indent rule " + string + '=' + string2 + ':');
            Log.log(9, this, exception);
        }
    }
}

