/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.AutoDetection;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscUtilities {
    @Deprecated
    public static final String UTF_8_Y = "UTF-8Y";
    static final String varPatternString = "(\\$([a-zA-Z0-9_]+))";
    static final String varPatternString2 = "(\\$\\{([^}]+)\\})";
    static final Pattern varPattern = Pattern.compile("(\\$([a-zA-Z0-9_]+))");
    static final Pattern varPattern2 = Pattern.compile("(\\$\\{([^}]+)\\})");
    public static final DecimalFormat KB_FORMAT = new DecimalFormat("#.# kB");
    public static final DecimalFormat MB_FORMAT = new DecimalFormat("#.# MB");
    static VarCompressor svc = null;

    public static String canonPath(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        } else if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        } else if (MiscUtilities.isURL(string)) {
            return string;
        }
        if (File.separatorChar == '\\') {
            string = string.replace('/', '\\');
            int n = string.length();
            while (string.charAt(n - 1) == ' ') {
                --n;
            }
            if (string.charAt(n - 1) == '\\') {
                while (n > 1 && string.charAt(n - 2) == '\\') {
                    --n;
                }
            }
            string = string.substring(0, n);
        } else if (OperatingSystem.isMacOS()) {
            string = string.replace(':', '/');
        }
        if (string.startsWith('~' + File.separator)) {
            string = string.substring(2);
            String string2 = System.getProperty("user.home");
            if (string2.endsWith(File.separator)) {
                return string2 + string;
            }
            return string2 + File.separator + string;
        }
        if ("~".equals(string)) {
            return System.getProperty("user.home");
        }
        if ("-".equals(string)) {
            return MiscUtilities.getParentOfPath(jEdit.getActiveView().getBuffer().getPath());
        }
        return string;
    }

    public static String expandVariables(String string) {
        Pattern pattern = varPattern;
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find() && !(matcher = (pattern = varPattern2).matcher(string)).find()) {
            return string;
        }
        String string2 = matcher.group(2);
        String string3 = System.getenv(string2);
        if (string3 == null) {
            string2 = string2.toUpperCase();
            String string4 = string.toUpperCase();
            matcher = pattern.matcher(string4);
            string3 = System.getenv(string2);
        }
        if (string3 != null) {
            string3 = string3.replace("\\", "\\\\");
            return matcher.replaceFirst(string3);
        }
        return string;
    }

    public static String abbreviate(String string) {
        if (svc == null) {
            svc = new VarCompressor();
        }
        return svc.compress(string);
    }

    public static String resolveSymlinks(String string) {
        if (MiscUtilities.isURL(string)) {
            return string;
        }
        if (OperatingSystem.isOS2()) {
            return string;
        }
        if (OperatingSystem.isDOSDerived() && (string.length() == 2 || string.length() == 3) && string.charAt(1) == ':') {
            return string;
        }
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static boolean isAbsolutePath(String string) {
        if (MiscUtilities.isURL(string)) {
            return true;
        }
        if (string.startsWith("~/") || string.startsWith('~' + File.separator) || "~".equals(string)) {
            return true;
        }
        if ("-".equals(string)) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (string.length() == 2 && string.charAt(1) == ':') {
                return true;
            }
            if (string.length() > 2 && string.charAt(1) == ':' && (string.charAt(2) == '\\' || string.charAt(2) == '/')) {
                return true;
            }
            if (string.startsWith("\\\\") || string.startsWith("//")) {
                return true;
            }
        } else if ((OperatingSystem.isUnix() || OperatingSystem.isVMS()) && string.length() > 0 && string.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String constructPath(String string, String string2) {
        if (MiscUtilities.isAbsolutePath(string2)) {
            return MiscUtilities.canonPath(string2);
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (string2.length() == 2 && string2.charAt(1) == ':') {
                return string2;
            }
            if (string2.length() > 2 && string2.charAt(1) == ':' && string2.charAt(2) != '\\') {
                string2 = string2.substring(0, 2) + '\\' + string2.substring(2);
                return MiscUtilities.canonPath(string2);
            }
        }
        String string3 = ".." + File.separator;
        String string4 = '.' + File.separator;
        while (true) {
            if (".".equals(string2)) {
                return string;
            }
            if ("..".equals(string2)) {
                return MiscUtilities.getParentOfPath(string);
            }
            if (string2.startsWith(string3) || string2.startsWith("../")) {
                string = MiscUtilities.getParentOfPath(string);
                string2 = string2.substring(3);
                continue;
            }
            if (!string2.startsWith(string4) && !string2.startsWith("./")) break;
            string2 = string2.substring(2);
        }
        if (string2.length() == 0) {
            return string;
        }
        if (OperatingSystem.isDOSDerived() && !MiscUtilities.isURL(string) && string2.charAt(0) == '\\') {
            string = string.substring(0, 2);
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        return MiscUtilities.canonPath(vFS.constructPath(string, string2));
    }

    public static String constructPath(String string, String string2, String string3) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(string, string2), string3);
    }

    public static String concatPath(String string, String string2) {
        string = MiscUtilities.canonPath(string);
        if ((string2 = MiscUtilities.canonPath(string2)).startsWith(File.separator)) {
            string2 = string2.substring(1);
        } else if (string2.length() >= 3 && string2.charAt(1) == ':') {
            string2 = string2.replace(':', File.separatorChar);
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string.endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public static int getFirstSeparatorIndex(String string) {
        int n = MiscUtilities.getPathStart(string);
        int n2 = string.indexOf(47, n);
        if (n2 == -1) {
            n2 = string.indexOf(File.separatorChar, n);
        }
        return n2;
    }

    public static int getLastSeparatorIndex(String string) {
        int n;
        int n2 = MiscUtilities.getPathStart(string);
        if (n2 != 0) {
            string = string.substring(n2);
        }
        if ((n = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar))) == -1) {
            return n;
        }
        return n + n2;
    }

    public static String getFileExtension(String string) {
        int n = MiscUtilities.getLastSeparatorIndex(string);
        int n2 = string.lastIndexOf(46);
        if (n2 == -1 || n2 < n) {
            return "";
        }
        return string.substring(n2);
    }

    public static String getFileName(String string) {
        return VFSManager.getVFSForPath(string).getFileName(string);
    }

    public static String getFileNameNoExtension(String string) {
        String string2 = MiscUtilities.getFileName(string);
        int n = string2.indexOf(46);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    @Deprecated
    public static String getFileParent(String string) {
        return MiscUtilities.getParentOfPath(string);
    }

    public static String getParentOfPath(String string) {
        return VFSManager.getVFSForPath(string).getParentOfPath(string);
    }

    @Deprecated
    public static String getFileProtocol(String string) {
        return MiscUtilities.getProtocolOfURL(string);
    }

    public static String getProtocolOfURL(String string) {
        return string.substring(0, string.indexOf(58));
    }

    public static boolean isURL(String string) {
        int n = MiscUtilities.getLastSeparatorIndex(string);
        if (n == 0) {
            return false;
        }
        if (n == 2) {
            return false;
        }
        int n2 = string.indexOf(58);
        if (n2 <= 1) {
            return false;
        }
        String string2 = string.substring(0, n2);
        VFS vFS = VFSManager.getVFSForProtocol(string2);
        if (vFS != null && !(vFS instanceof UrlVFS)) {
            return true;
        }
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static void saveBackup(File file, int n, String string, String string2, String string3) {
        MiscUtilities.saveBackup(file, n, string, string2, string3, 0);
    }

    public static void saveBackup(File file, int n, String string, String string2, String string3, int n2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        String string4 = file.getName();
        if (n == 1) {
            File file2 = new File(string3, string + string4 + string2);
            long l = file2.lastModified();
            if (System.currentTimeMillis() - l >= (long)n2) {
                Log.log(1, MiscUtilities.class, "Saving backup of file \"" + file.getAbsolutePath() + "\" to \"" + file2.getAbsolutePath() + '\"');
                file2.delete();
                if (!file.renameTo(file2)) {
                    IOUtilities.moveFile(file, file2);
                }
            }
        } else {
            new File(string3, string + string4 + string2 + n + string2).delete();
            File file3 = new File(string3, string + string4 + string2 + '1' + string2);
            long l = file3.lastModified();
            if (System.currentTimeMillis() - l >= (long)n2) {
                for (int i = n - 1; i > 0; --i) {
                    File file4 = new File(string3, string + string4 + string2 + i + string2);
                    file4.renameTo(new File(string3, string + string4 + string2 + (i + 1) + string2));
                }
                File file5 = new File(string3, string + string4 + string2 + '1' + string2);
                Log.log(1, MiscUtilities.class, "Saving backup of file \"" + file.getAbsolutePath() + "\" to \"" + file5.getAbsolutePath() + '\"');
                if (!file.renameTo(file5)) {
                    IOUtilities.moveFile(file, file5);
                }
            }
        }
    }

    @Deprecated
    public static boolean moveFile(File file, File file2) {
        return IOUtilities.moveFile(file, file2);
    }

    @Deprecated
    public static boolean copyStream(int n, ProgressObserver progressObserver, InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return IOUtilities.copyStream(n, progressObserver, inputStream, outputStream, bl);
    }

    @Deprecated
    public static boolean copyStream(ProgressObserver progressObserver, InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return IOUtilities.copyStream(4096, progressObserver, inputStream, outputStream, bl);
    }

    @Deprecated
    public static boolean isBinary(Reader reader) throws IOException {
        return MiscUtilities.containsNullCharacter(reader);
    }

    public static boolean isBinary(InputStream inputStream) throws IOException {
        AutoDetection.Result result = new AutoDetection.Result(inputStream);
        if (result.getDetectedEncoding() != null) {
            return false;
        }
        try {
            return MiscUtilities.containsNullCharacter(new InputStreamReader(result.getRewindedStream()));
        }
        catch (MalformedInputException malformedInputException) {
            return true;
        }
    }

    public static boolean isBackup(String string) {
        if (string.startsWith("#")) {
            return true;
        }
        if (string.endsWith("~")) {
            return true;
        }
        return string.endsWith(".bak");
    }

    public static Reader autodetect(InputStream inputStream, Buffer buffer) throws IOException {
        Object object;
        String string = buffer == null ? System.getProperty("file.encoding") : buffer.getStringProperty("encoding");
        boolean bl = false;
        if (buffer == null || buffer.getBooleanProperty("encodingAutodetect")) {
            String string2;
            object = new AutoDetection.Result(inputStream);
            bl = ((AutoDetection.Result)object).streamIsGzipped();
            if (bl) {
                Log.log(1, MiscUtilities.class, "Stream is Gzipped");
            }
            if ((string2 = ((AutoDetection.Result)object).getDetectedEncoding()) != null) {
                string = string2;
                Log.log(1, MiscUtilities.class, "Stream encoding detected is " + string2);
            }
            inputStream = ((AutoDetection.Result)object).getRewindedStream();
        } else {
            inputStream = AutoDetection.getMarkedStream(inputStream);
        }
        object = EncodingServer.getTextReader(inputStream, string);
        if (buffer != null) {
            if (bl) {
                buffer.setBooleanProperty("gzipped", true);
            }
            buffer.setProperty("encoding", string);
        }
        return object;
    }

    @Deprecated
    public static void closeQuietly(InputStream inputStream) {
        IOUtilities.closeQuietly(inputStream);
    }

    @Deprecated
    public static void closeQuietly(OutputStream outputStream) {
        IOUtilities.closeQuietly(outputStream);
    }

    public static String fileToClass(String string) {
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 6; i >= 0; --i) {
            if (cArray[i] != '/') continue;
            cArray[i] = 46;
        }
        return new String(cArray, 0, cArray.length - 6);
    }

    public static String classToFile(String string) {
        return string.replace('.', '/').concat(".class");
    }

    public static boolean pathsEqual(String string, String string2) {
        VFS vFS;
        VFS vFS2 = VFSManager.getVFSForPath(string);
        if (vFS2 != (vFS = VFSManager.getVFSForPath(string2))) {
            return false;
        }
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("/") || string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((vFS2.getCapabilities() & 0x80) != 0) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    @Deprecated
    public static int getLeadingWhiteSpace(String string) {
        return StandardUtilities.getLeadingWhiteSpace(string);
    }

    @Deprecated
    public static int getTrailingWhiteSpace(String string) {
        return StandardUtilities.getTrailingWhiteSpace(string);
    }

    @Deprecated
    public static int getLeadingWhiteSpaceWidth(String string, int n) {
        return StandardUtilities.getLeadingWhiteSpaceWidth(string, n);
    }

    @Deprecated
    public static int getVirtualWidth(Segment segment, int n) {
        return StandardUtilities.getVirtualWidth(segment, n);
    }

    @Deprecated
    public static int getOffsetOfVirtualColumn(Segment segment, int n, int n2, int[] nArray) {
        return StandardUtilities.getOffsetOfVirtualColumn(segment, n, n2, nArray);
    }

    @Deprecated
    public static String createWhiteSpace(int n, int n2) {
        return StandardUtilities.createWhiteSpace(n, n2, 0);
    }

    @Deprecated
    public static String createWhiteSpace(int n, int n2, int n3) {
        return StandardUtilities.createWhiteSpace(n, n2, n3);
    }

    @Deprecated
    public static String globToRE(String string) {
        return StandardUtilities.globToRE(string);
    }

    public static String escapesToChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == string.length() - 1) {
                        stringBuilder.append('\\');
                        continue block7;
                    }
                    c = string.charAt(++i);
                    switch (c) {
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block7;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block7;
                        }
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String charsToEscapes(String string) {
        return StandardUtilities.charsToEscapes(string);
    }

    @Deprecated
    public static String charsToEscapes(String string, String string2) {
        return StandardUtilities.charsToEscapes(string, string2);
    }

    @Deprecated
    public static int compareVersions(String string, String string2) {
        return StandardUtilities.compareStrings(string, string2, false);
    }

    @Deprecated
    public static int compareStrings(String string, String string2, boolean bl) {
        return StandardUtilities.compareStrings(string, string2, bl);
    }

    @Deprecated
    public static boolean stringsEqual(String string, String string2) {
        return StandardUtilities.objectsEqual(string, string2);
    }

    @Deprecated
    public static boolean objectsEqual(Object object, Object object2) {
        return StandardUtilities.objectsEqual(object, object2);
    }

    @Deprecated
    public static String charsToEntities(String string) {
        return XMLUtilities.charsToEntities(string, false);
    }

    public static String formatFileSize(long l) {
        if (l < 1024L) {
            return l + " Bytes";
        }
        if (l < 0x100000L) {
            return KB_FORMAT.format((double)l / 1024.0);
        }
        return MB_FORMAT.format((double)l / 1024.0 / 1024.0);
    }

    public static String getLongestPrefix(List<String> list, boolean bl) {
        String string;
        int n;
        if (list.isEmpty()) {
            return "";
        }
        block0: for (n = 0; n < (string = list.get(0)).length(); ++n) {
            char c = string.charAt(n);
            for (int i = 1; i < list.size(); ++i) {
                string = list.get(i);
                if (n >= string.length() || !MiscUtilities.compareChars(string.charAt(n), c, bl)) break block0;
            }
        }
        return list.get(0).substring(0, n);
    }

    public static String getLongestPrefix(String[] stringArray, boolean bl) {
        return MiscUtilities.getLongestPrefix((Object[])stringArray, bl);
    }

    public static String getLongestPrefix(Object[] objectArray, boolean bl) {
        int n;
        if (objectArray.length == 0) {
            return "";
        }
        String string = objectArray[0].toString();
        block0: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            for (int i = 1; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                if (n >= string2.length() || !MiscUtilities.compareChars(string2.charAt(n), c, bl)) break block0;
            }
        }
        return string.substring(0, n);
    }

    @Deprecated
    public static void quicksort(Object[] objectArray, Comparator comparator) {
        Arrays.sort(objectArray, comparator);
    }

    @Deprecated
    public static void quicksort(Vector vector, Comparator comparator) {
        Collections.sort(vector, comparator);
    }

    @Deprecated
    public static void quicksort(List list, Comparator comparator) {
        Collections.sort(list, comparator);
    }

    @Deprecated
    public static void quicksort(Object[] objectArray, Compare compare) {
        Arrays.sort(objectArray, compare);
    }

    @Deprecated
    public static void quicksort(Vector vector, Compare compare) {
        Collections.sort(vector, compare);
    }

    public static String buildToVersion(String string) {
        if (string.length() != 11) {
            return "<unknown version: " + string + '>';
        }
        int n = Integer.parseInt(string.substring(0, 2));
        int n2 = Integer.parseInt(string.substring(3, 5));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(9, 11));
        return n + "." + n2 + (n3 != 99 ? "rc" + n3 : (n4 != 0 ? "." + n4 : ""));
    }

    public static boolean isToolsJarAvailable() {
        Log.log(1, MiscUtilities.class, "Searching for tools.jar...");
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("System classpath: " + System.getProperty("java.class.path"));
        try {
            try {
                Class.forName("sun.tools.javac.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class.forName("com.sun.tools.javac.Main");
            }
            Log.log(1, MiscUtilities.class, "- is in classpath. Fine.");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string;
            String string2;
            String string3 = jEdit.getSettingsDirectory();
            if (string3 != null) {
                string2 = MiscUtilities.constructPath(string3, "jars", "tools.jar");
                linkedList.add(string2);
                if (new File(string2).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in the user's jars folder. Fine.");
                    return true;
                }
            }
            if ((string2 = jEdit.getJEditHome()) != null) {
                string = MiscUtilities.constructPath(string2, "jars", "tools.jar");
                linkedList.add(string);
                if (new File(string).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in jEdit's system jars folder. Fine.");
                    return true;
                }
            }
            if ((string = System.getProperty("java.home")).toLowerCase().endsWith(File.separator + "jre")) {
                string = string.substring(0, string.length() - 4);
            }
            string = MiscUtilities.constructPath(string, "lib", "tools.jar");
            linkedList.add(string);
            if (!new File(string).exists()) {
                Log.log(7, MiscUtilities.class, "Could not find tools.jar.\nI checked the following locations:\n" + ((Object)linkedList).toString());
                return false;
            }
            PluginJAR pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null) {
                Log.log(1, MiscUtilities.class, "- adding " + string + " to jEdit plugins.");
                jEdit.addPluginJAR(string);
            } else {
                Log.log(1, MiscUtilities.class, "- has been loaded before.");
            }
            return true;
        }
    }

    public static int parsePermissions(String string) {
        int n = 0;
        if (string.length() == 9) {
            if (string.charAt(0) == 'r') {
                n += 256;
            }
            if (string.charAt(1) == 'w') {
                n += 128;
            }
            if (string.charAt(2) == 'x') {
                n += 64;
            } else if (string.charAt(2) == 's') {
                n += 2112;
            } else if (string.charAt(2) == 'S') {
                n += 2048;
            }
            if (string.charAt(3) == 'r') {
                n += 32;
            }
            if (string.charAt(4) == 'w') {
                n += 16;
            }
            if (string.charAt(5) == 'x') {
                n += 8;
            } else if (string.charAt(5) == 's') {
                n += 1032;
            } else if (string.charAt(5) == 'S') {
                n += 1024;
            }
            if (string.charAt(6) == 'r') {
                n += 4;
            }
            if (string.charAt(7) == 'w') {
                n += 2;
            }
            if (string.charAt(8) == 'x') {
                ++n;
            } else if (string.charAt(8) == 't') {
                n += 513;
            } else if (string.charAt(8) == 'T') {
                n += 512;
            }
        }
        return n;
    }

    @Deprecated
    public static String[] getEncodings() {
        return MiscUtilities.getEncodings(false);
    }

    public static String[] getEncodings(boolean bl) {
        Set<String> set = bl ? EncodingServer.getSelectedNames() : EncodingServer.getAvailableNames();
        return set.toArray(new String[set.size()]);
    }

    public static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Deprecated
    public static boolean parseXML(InputStream inputStream, DefaultHandler defaultHandler) throws IOException {
        return XMLUtilities.parseXML(inputStream, defaultHandler);
    }

    @Deprecated
    public static InputSource findEntity(String string, String string2, Class clazz) {
        return XMLUtilities.findEntity(string, string2, clazz);
    }

    private MiscUtilities() {
    }

    private static boolean compareChars(char c, char c2, boolean bl) {
        if (bl) {
            return Character.toUpperCase(c) == Character.toUpperCase(c2);
        }
        return c == c2;
    }

    private static int getPathStart(String string) {
        if (string.startsWith("/")) {
            return 0;
        }
        if (OperatingSystem.isDOSDerived() && string.length() >= 3 && string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    private static boolean containsNullCharacter(Reader reader) throws IOException {
        int n = jEdit.getIntegerProperty("vfs.binaryCheck.length", 100);
        int n2 = jEdit.getIntegerProperty("vfs.binaryCheck.count", 1);
        for (long i = 0L; i < (long)n; ++i) {
            int n3 = reader.read();
            if (n3 == -1) {
                return false;
            }
            if (n3 != 0 || --n2 != 0) continue;
            return true;
        }
        return false;
    }

    static class VarCompressor {
        final Map<String, String> prefixMap = new HashMap<String, String>();
        final Map<String, String> previous = new HashMap<String, String>();

        VarCompressor() {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            Map<String, String> map = processBuilder.environment();
            if (OperatingSystem.isUnix()) {
                this.prefixMap.put(System.getProperty("user.home"), "~");
            }
            for (String string : map.keySet()) {
                String string2;
                String string3;
                if (string.equalsIgnoreCase("pwd") || string.equalsIgnoreCase("oldpwd") || !Character.isLetter(string.charAt(0)) || !this.canBePathPrefix(string3 = map.get(string))) continue;
                if (string3.endsWith(File.separator)) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (OperatingSystem.isWindows() && (string.length() + 2 > string3.length() || string.length() + 1 > string3.length())) continue;
                if (OperatingSystem.isWindows()) {
                    string3 = string3.toLowerCase();
                    string = string.toLowerCase();
                }
                if (this.prefixMap.containsKey(string3) && (string2 = this.prefixMap.get(string3)).length() < string.length()) continue;
                this.prefixMap.put(string3, string);
            }
        }

        String compress(String string) {
            String string2;
            String string3 = string;
            if (this.previous.containsKey(string)) {
                return this.previous.get(string);
            }
            String string4 = string2 = "/";
            for (String string5 : this.prefixMap.keySet()) {
                if (string5.length() < string2.length()) continue;
                if (OperatingSystem.isWindows() && string.toLowerCase().startsWith(string5)) {
                    string2 = string5;
                } else if (string.startsWith(string5)) {
                    string2 = string5;
                }
                if (string2.equals(string4)) continue;
                String string6 = string3.substring(string2.length());
                if (string6.length() < 1 || string6.startsWith(File.separator)) {
                    string4 = string2;
                    continue;
                }
                string2 = string4;
            }
            if (string2.length() > 1) {
                String string5;
                String string7 = string3.substring(string2.length());
                string5 = this.prefixMap.get(string2);
                string = string5.equals("~") ? string5 + (String)string7 : (OperatingSystem.isWindows() ? '%' + string5.toUpperCase() + '%' + (String)string7 : '$' + string5 + (String)string7);
            }
            this.previous.put(string3, string);
            return string;
        }

        private boolean canBePathPrefix(String string) {
            return !string.contains(File.pathSeparator) && new File(string).isAbsolute();
        }
    }

    @Deprecated
    public static class MenuItemCompare
    implements Compare {
        private MenuItemTextComparator comparator = new MenuItemTextComparator();

        public int compare(Object object, Object object2) {
            return this.comparator.compare((JMenuItem)object, (JMenuItem)object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class StringICaseCompare
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            return StandardUtilities.compareStrings(object.toString(), object2.toString(), true);
        }
    }

    @Deprecated
    public static class StringCompare
    implements Compare {
        public int compare(Object object, Object object2) {
            return StandardUtilities.compareStrings(object.toString(), object2.toString(), false);
        }
    }

    @Deprecated
    public static interface Compare
    extends Comparator {
        public int compare(Object var1, Object var2);
    }
}

