/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class JEditKillRing
extends KillRing {
    private SettingsXML killringXML;

    JEditKillRing() {
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            this.killringXML = new SettingsXML(string, "killring");
        }
    }

    public void load() {
        if (this.killringXML == null) {
            return;
        }
        if (!this.killringXML.fileExists()) {
            return;
        }
        Log.log(3, KillRing.class, "Loading " + this.killringXML);
        KillRingHandler killRingHandler = new KillRingHandler();
        try {
            this.killringXML.load(killRingHandler);
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
        }
        this.reset(killRingHandler.list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        if (this.killringXML == null) {
            return;
        }
        if (this.killringXML.hasChangedOnDisk()) {
            Log.log(7, KillRing.class, this.killringXML + " changed on disk; will not save killring" + " files");
            return;
        }
        Log.log(3, KillRing.class, "Saving " + this.killringXML);
        String string = System.getProperty("line.separator");
        SettingsXML.Saver saver = null;
        try {
            try {
                saver = this.killringXML.openSaver();
                saver.writeXMLDeclaration("1.1");
                saver.write("<!DOCTYPE KILLRING SYSTEM \"killring.dtd\">");
                saver.write(string);
                saver.write("<KILLRING>");
                saver.write(string);
                int n = this.getSize();
                for (int i = n - 1; i >= 0; --i) {
                    saver.write("<ENTRY>");
                    saver.write(XMLUtilities.charsToEntities(this.getElementAt(i).toString(), true));
                    saver.write("</ENTRY>");
                    saver.write(string);
                }
                saver.write("</KILLRING>");
                saver.write(string);
                saver.finish();
            }
            catch (Exception exception) {
                Log.log(9, KillRing.class, exception);
                Object var6_7 = null;
                IOUtilities.closeQuietly(saver);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            IOUtilities.closeQuietly(saver);
            throw throwable;
        }
        IOUtilities.closeQuietly(saver);
    }

    private static class KillRingHandler
    extends DefaultHandler {
        public List<String> list = new LinkedList<String>();
        private final StringBuilder charData = new StringBuilder();
        private boolean inEntry;

        private KillRingHandler() {
        }

        public InputSource resolveEntity(String string, String string2) {
            return XMLUtilities.findEntity(string2, "killring.dtd", this.getClass());
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.inEntry = string3.equals("ENTRY");
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("ENTRY")) {
                this.list.add(this.charData.toString());
                this.inEntry = false;
                this.charData.setLength(0);
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.inEntry) {
                this.charData.append(cArray, n, n2);
            }
        }

        public void processingInstruction(String string, String string2) {
            if ("illegal-xml-character".equals(string)) {
                char c;
                try {
                    c = (char)Integer.parseInt(string2.trim());
                }
                catch (Exception exception) {
                    Log.log(9, this, "Failed to get character from PI\"" + string + "\"" + " with \"" + string2 + "\"" + ": " + exception);
                    return;
                }
                this.characters(new char[]{c}, 0, 1);
            }
        }
    }
}

