/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GutterOptionPane;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.GutterPopupHandler;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.MouseHandler;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StatusListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.textarea.TextAreaTransferHandler;
import org.gjt.sp.util.SyntaxUtilities;

public class EditPane
extends JPanel
implements EBComponent,
BufferSetListener {
    private boolean init = true;
    private final View view;
    private BufferSet bufferSet;
    private BufferSet.Scope bufferSetScope;
    private Buffer buffer;
    private Buffer recentBuffer;
    private BufferSwitcher bufferSwitcher;
    private final JEditTextArea textArea;
    private final MarkerHighlight markerHighlight;
    private final Map<String, CaretInfo> caretsForPath = new HashMap<String, CaretInfo>();

    public View getView() {
        return this.view;
    }

    public static EditPane get(TextArea textArea) {
        if (textArea == null) {
            return null;
        }
        return (EditPane)SwingUtilities.getAncestorOfClass(EditPane.class, textArea);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.setBuffer(buffer, true);
    }

    public void setBuffer(final Buffer buffer, boolean bl) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (this.buffer == buffer) {
            return;
        }
        if (this.bufferSet.indexOf(buffer) == -1) {
            jEdit.getBufferSetManager().addBuffer(this, buffer);
        }
        EditBus.send(new BufferChanging(this, buffer));
        if (this.bufferSet.indexOf(this.buffer) != -1) {
            this.recentBuffer = this.buffer;
        }
        if (this.recentBuffer != null) {
            this.saveCaretInfo();
        }
        this.buffer = buffer;
        this.textArea.setBuffer(buffer);
        if (!this.init) {
            this.view.updateTitle();
            if (this.bufferSwitcher != null) {
                if (this.bufferSwitcher.getSelectedItem() != buffer) {
                    this.bufferSwitcher.setSelectedItem(buffer);
                }
                this.bufferSwitcher.setToolTipText(buffer.getPath());
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFER_CHANGED));
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!(EditPane.this.view.getEditPane() != EditPane.this || EditPane.this.bufferSwitcher != null && EditPane.this.bufferSwitcher.isPopupVisible())) {
                        EditPane.this.textArea.requestFocus();
                    }
                }
            });
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (buffer == EditPane.this.getBuffer()) {
                    EditPane.this.loadCaretInfo();
                }
            }
        };
        if (buffer.isPerformingIO()) {
            VFSManager.runInAWTThread(runnable);
        } else {
            runnable.run();
        }
    }

    public void prevBuffer() {
        Buffer buffer = this.bufferSet.getPreviousBuffer(this.bufferSet.indexOf(this.buffer));
        this.setBuffer(buffer);
    }

    public void nextBuffer() {
        Buffer buffer = this.bufferSet.getNextBuffer(this.bufferSet.indexOf(this.buffer));
        this.setBuffer(buffer);
    }

    public void recentBuffer() {
        if (this.recentBuffer != null) {
            this.setBuffer(this.recentBuffer);
        } else {
            this.getToolkit().beep();
        }
    }

    public void focusOnTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditPane.this.textArea.requestFocus();
            }
        });
    }

    public JEditTextArea getTextArea() {
        return this.textArea;
    }

    public BufferSwitcher getBufferSwitcher() {
        return this.bufferSwitcher;
    }

    public void focusBufferSwitcher() {
        if (this.bufferSwitcher == null) {
            this.getToolkit().beep();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditPane.this.bufferSwitcher.requestFocus();
                    EditPane.this.bufferSwitcher.showPopup();
                }
            });
        }
    }

    public void saveCaretInfo() {
        if (!this.buffer.isLoaded()) {
            return;
        }
        this.buffer.setIntegerProperty("Buffer__caret", this.textArea.getCaretPosition());
        CaretInfo caretInfo = this.caretsForPath.get(this.buffer.getPath());
        if (caretInfo == null) {
            caretInfo = new CaretInfo();
            this.caretsForPath.put(this.buffer.getPath(), caretInfo);
        }
        caretInfo.caret = this.textArea.getCaretPosition();
        Selection[] selectionArray = this.textArea.getSelection();
        for (int i = 0; i < selectionArray.length; ++i) {
            selectionArray[i] = (Selection)selectionArray[i].clone();
        }
        this.buffer.setProperty("Buffer__selection", selectionArray);
        caretInfo.selection = selectionArray;
        caretInfo.rectangularSelection = this.textArea.isRectangularSelectionEnabled();
        caretInfo.multipleSelection = this.textArea.isMultipleSelectionEnabled();
        this.buffer.setIntegerProperty("Buffer__scrollVert", this.textArea.getFirstPhysicalLine());
        caretInfo.scrollVert = this.textArea.getFirstPhysicalLine();
        this.buffer.setIntegerProperty("Buffer__scrollHoriz", this.textArea.getHorizontalOffset());
        caretInfo.scrollHoriz = this.textArea.getHorizontalOffset();
        if (!this.buffer.isUntitled()) {
            BufferHistory.setEntry(this.buffer.getPath(), this.textArea.getCaretPosition(), (Selection[])this.buffer.getProperty("Buffer__selection"), this.buffer.getStringProperty("encoding"), this.buffer.getMode().getName());
        }
    }

    public void loadCaretInfo() {
        int n;
        Object object;
        int n2;
        Selection[] selectionArray;
        int n3;
        CaretInfo caretInfo = this.caretsForPath.get(this.buffer.getPath());
        if (caretInfo == null) {
            caretInfo = new CaretInfo();
        }
        if ((n3 = caretInfo.caret) == -1 || this.buffer.getBooleanProperty("Buffer__caretPositioned")) {
            selectionArray = (Selection[])this.buffer.getProperty("Buffer__caret");
            n3 = selectionArray == null ? -1 : selectionArray.intValue();
        }
        this.buffer.unsetProperty("Buffer__caretPositioned");
        if (n3 != -1) {
            this.textArea.setCaretPosition(Math.min(n3, this.buffer.getLength()));
        }
        if ((selectionArray = caretInfo.selection) == null) {
            selectionArray = (Selection[])this.buffer.getProperty("Buffer__selection");
        }
        if (selectionArray != null) {
            for (n2 = 0; n2 < selectionArray.length; ++n2) {
                object = selectionArray[n2];
                int n4 = this.buffer.getLength();
                if (((Selection)object).getStart() <= n4 && ((Selection)object).getEnd() <= n4) continue;
                selectionArray[n2] = null;
            }
        }
        this.textArea.setSelection(selectionArray);
        this.textArea.setRectangularSelectionEnabled(caretInfo.rectangularSelection);
        this.textArea.setMultipleSelectionEnabled(caretInfo.multipleSelection);
        n2 = caretInfo.scrollVert;
        if (n2 == -1) {
            object = (Integer)this.buffer.getProperty("Buffer__scrollVert");
            int n5 = n2 = object == null ? -1 : (Integer)object;
        }
        if (n2 != -1) {
            this.textArea.setFirstPhysicalLine(n2);
        }
        if ((n = caretInfo.scrollHoriz) == -1) {
            Integer n6 = (Integer)this.buffer.getProperty("Buffer__scrollHoriz");
            int n7 = n = n6 == null ? -1 : n6;
        }
        if (n != -1) {
            this.textArea.setHorizontalOffset(n);
        }
        this.view.getStatus().setMessage(null);
    }

    void bufferRenamed(String string, String string2) {
        CaretInfo caretInfo = this.caretsForPath.remove(string);
        if (caretInfo != null) {
            this.caretsForPath.put(string2, caretInfo);
        }
    }

    public void goToNextMarker(boolean bl) {
        Vector<Marker> vector = this.buffer.getMarkers();
        if (vector.isEmpty()) {
            this.getToolkit().beep();
            return;
        }
        Marker marker = null;
        int n = this.textArea.getCaretPosition();
        for (int i = 0; i < vector.size(); ++i) {
            Marker marker2 = (Marker)vector.get(i);
            if (marker2.getPosition() <= n) continue;
            marker = marker2;
            break;
        }
        if (marker == null) {
            marker = (Marker)vector.get(0);
        }
        if (bl) {
            this.textArea.extendSelection(n, marker.getPosition());
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(marker.getPosition());
    }

    public void goToPrevMarker(boolean bl) {
        Vector<Marker> vector = this.buffer.getMarkers();
        if (vector.isEmpty()) {
            this.getToolkit().beep();
            return;
        }
        int n = this.textArea.getCaretPosition();
        Marker marker = null;
        for (int i = vector.size() - 1; i >= 0; --i) {
            Marker marker2 = (Marker)vector.get(i);
            if (marker2.getPosition() >= n) continue;
            marker = marker2;
            break;
        }
        if (marker == null) {
            marker = (Marker)vector.get(vector.size() - 1);
        }
        if (bl) {
            this.textArea.extendSelection(n, marker.getPosition());
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(marker.getPosition());
    }

    public void goToMarker(char c, boolean bl) {
        Marker marker = this.buffer.getMarker(c);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int n = marker.getPosition();
        if (bl) {
            this.textArea.extendSelection(this.textArea.getCaretPosition(), n);
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(n);
    }

    public void addMarker() {
        int n = this.textArea.getCaretLine();
        Selection[] selectionArray = this.textArea.getSelection();
        for (int i = 0; i < selectionArray.length; ++i) {
            Selection selection = selectionArray[i];
            int n2 = selection.getStartLine();
            if (n2 != selection.getEndLine() && n2 != n) {
                this.buffer.addMarker('\u0000', selection.getStart());
            }
            if (selection.getEndLine() == n) continue;
            this.buffer.addMarker('\u0000', selection.getEnd());
        }
        this.buffer.addOrRemoveMarker('\u0000', this.textArea.getCaretPosition());
    }

    public void swapMarkerAndCaret(char c) {
        Marker marker = this.buffer.getMarker(c);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int n = this.textArea.getCaretPosition();
        this.textArea.setCaretPosition(marker.getPosition());
        this.buffer.addMarker(c, n);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
            this.loadBufferSwitcher();
        } else if (eBMessage instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)eBMessage);
        }
    }

    public final Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public BufferSet getBufferSet() {
        return this.bufferSet;
    }

    public BufferSet.Scope getBufferSetScope() {
        return this.bufferSetScope;
    }

    public void setBufferSetScope(BufferSet.Scope scope) {
        if (this.bufferSetScope != scope) {
            BufferSet bufferSet;
            BufferSet bufferSet2 = this.bufferSet;
            switch (scope) {
                case editpane: {
                    bufferSet = new BufferSet();
                    break;
                }
                case view: {
                    bufferSet = this.view.getLocalBufferSet();
                    break;
                }
                default: {
                    scope = BufferSet.Scope.global;
                }
                case global: {
                    bufferSet = jEdit.getGlobalBufferSet();
                }
            }
            BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
            if (jEdit.isStartupDone()) {
                String string = jEdit.getProperty("editpane.bufferset.new");
                BufferSetManager.NewBufferSetAction newBufferSetAction = BufferSetManager.NewBufferSetAction.fromString(string);
                View view = jEdit.getActiveView();
                switch (newBufferSetAction) {
                    case copy: {
                        if (bufferSet2 == null) {
                            EditPane editPane = this.view.getEditPane();
                            if (editPane == null && view != null) {
                                editPane = view.getEditPane();
                            }
                            if (editPane == null) {
                                bufferSetManager.addAllBuffers(bufferSet);
                                break;
                            }
                            bufferSetManager.mergeBufferSet(bufferSet, editPane.bufferSet);
                            break;
                        }
                        bufferSetManager.mergeBufferSet(bufferSet, bufferSet2);
                        break;
                    }
                    case empty: {
                        break;
                    }
                    case currentbuffer: {
                        if (view == null) break;
                        EditPane editPane = view.getEditPane();
                        Buffer buffer = editPane.getBuffer();
                        bufferSetManager.addBuffer(bufferSet, buffer);
                    }
                }
            }
            if (this.buffer != null) {
                bufferSetManager.addBuffer(bufferSet, this.buffer);
            }
            this.bufferSet = bufferSet;
            this.bufferSetScope = scope;
            if (bufferSet.size() == 0) {
                jEdit.newFile(this);
            }
            if (bufferSet2 != null) {
                bufferSet2.removeBufferSetListener(this);
            }
            bufferSet.addBufferSetListener(this);
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFERSET_CHANGED));
            if (bufferSet.indexOf(this.recentBuffer) == -1) {
                this.recentBuffer = null;
            }
            if (bufferSet.indexOf(this.buffer) == -1) {
                if (this.recentBuffer != null) {
                    this.setBuffer(this.recentBuffer);
                } else {
                    this.setBuffer(bufferSet.getBuffer(0));
                }
            }
            if (jEdit.isStartupDone()) {
                PerspectiveManager.setPerspectiveDirty(true);
            }
        }
    }

    public void bufferAdded(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
        if (this.bufferSet.indexOf(this.buffer) == -1) {
            this.setBuffer(buffer);
        }
    }

    public void bufferRemoved(Buffer buffer, int n) {
        if (buffer.isUntitled()) {
            this.caretsForPath.remove(buffer.getPath());
        }
        if (buffer == this.buffer) {
            Buffer buffer2;
            Buffer buffer3 = buffer2 = this.recentBuffer != null ? this.recentBuffer : this.bufferSet.getPreviousBuffer(n);
            if (buffer2 != null && !buffer2.isClosed()) {
                this.setBuffer(buffer2);
                if (this.bufferSet.size() > 1) {
                    this.recentBuffer = this.bufferSet.getPreviousBuffer(n - 1);
                }
            } else if (this.bufferSet.size() != 0) {
                this.setBuffer(this.bufferSet.getBuffer(0));
                this.recentBuffer = null;
            }
        }
        if (buffer == this.recentBuffer) {
            this.recentBuffer = null;
        }
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    public void bufferMoved(Buffer buffer, int n, int n2) {
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    public void bufferSetSorted() {
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    public String toString() {
        return this.getClass().getName() + '[' + (this.view.getEditPane() == this ? "active" : "inactive") + ',' + (Object)((Object)this.bufferSetScope) + ']';
    }

    EditPane(View view, Buffer buffer, BufferSet.Scope scope) {
        super(new BorderLayout());
        this.view = view;
        this.textArea = new JEditTextArea(view);
        this.textArea.getPainter().setAntiAlias(new AntiAlias(jEdit.getProperty("view.antiAlias")));
        this.textArea.setMouseHandler(new MouseHandler(this.textArea));
        this.textArea.setTransferHandler(new TextAreaTransferHandler());
        this.markerHighlight = new MarkerHighlight();
        Gutter gutter = this.textArea.getGutter();
        gutter.setGutterEnabled(GutterOptionPane.isGutterEnabled());
        gutter.setMinLineNumberDigitCount(GutterOptionPane.getMinLineNumberDigits());
        gutter.setSelectionAreaEnabled(GutterOptionPane.isSelectionAreaEnabled());
        gutter.addExtension(this.markerHighlight);
        gutter.setSelectionPopupHandler(new GutterPopupHandler(){

            public void handlePopup(int n, int n2, int n3) {
                Buffer buffer = EditPane.this.getBuffer();
                buffer.addOrRemoveMarker('\u0000', buffer.getLineStartOffset(n3));
            }
        });
        this.textArea.addStatusListener(new StatusHandler());
        this.add("Center", this.textArea);
        this.propertiesChanged();
        this.buffer = buffer;
        this.setBufferSetScope(scope);
        this.buffer = null;
        if (buffer == null) {
            this.setBuffer(jEdit.getFirstBuffer());
        } else {
            this.setBuffer(buffer);
        }
        this.loadBufferSwitcher();
        this.init = false;
        EditBus.addToBus(this);
    }

    void close() {
        this.saveCaretInfo();
        EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.DESTROYED));
        this.bufferSet.removeBufferSetListener(this);
        EditBus.removeFromBus(this);
        this.textArea.dispose();
    }

    private void propertiesChanged() {
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        EditPane.initPainter(textAreaPainter);
        Gutter gutter = this.textArea.getGutter();
        gutter.setExpanded(jEdit.getBooleanProperty("view.gutter.lineNumbers"));
        int n = jEdit.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(n);
        gutter.setCurrentLineHighlightEnabled(jEdit.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(jEdit.getColorProperty("view.gutter.structureHighlightColor"));
        gutter.setBackground(jEdit.getColorProperty("view.gutter.bgColor"));
        gutter.setForeground(jEdit.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(jEdit.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(jEdit.getColorProperty("view.gutter.foldColor"));
        this.markerHighlight.setMarkerHighlightColor(jEdit.getColorProperty("view.gutter.markerColor"));
        this.markerHighlight.setMarkerHighlightEnabled(jEdit.getBooleanProperty("view.gutter.markerHighlight"));
        gutter.setCurrentLineForeground(jEdit.getColorProperty("view.gutter.currentLineColor"));
        String string = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(string)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(string)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(jEdit.getFontProperty("view.gutter.font"));
        gutter.setGutterEnabled(GutterOptionPane.isGutterEnabled());
        gutter.setMinLineNumberDigitCount(GutterOptionPane.getMinLineNumberDigits());
        gutter.setSelectionAreaEnabled(GutterOptionPane.isSelectionAreaEnabled());
        gutter.setSelectionAreaBackground(GutterOptionPane.getSelectionAreaBackground());
        gutter.setSelectionAreaWidth(GutterOptionPane.getSelectionAreaWidth());
        int n2 = jEdit.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(n2, jEdit.getColorProperty("view.gutter.focusBorderColor"), jEdit.getColorProperty("view.gutter.noFocusBorderColor"), this.textArea.getPainter().getBackground());
        gutter.setFoldPainter(this.textArea.getFoldPainter());
        this.textArea.setCaretBlinkEnabled(jEdit.getBooleanProperty("view.caretBlink"));
        this.textArea.setElectricScroll(jEdit.getIntegerProperty("view.electricBorders", 0));
        this.textArea.createPopupMenu(null);
        this.textArea.setQuickCopyEnabled(jEdit.getBooleanProperty("view.middleMousePaste"));
        this.textArea.setDragEnabled(jEdit.getBooleanProperty("view.dragAndDrop"));
        this.textArea.setJoinNonWordChars(jEdit.getBooleanProperty("view.joinNonWordChars"));
        this.textArea.setCtrlForRectangularSelection(jEdit.getBooleanProperty("view.ctrlForRectangularSelection"));
        this.textArea.propertiesChanged();
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        }
    }

    public static void initPainter(TextAreaPainter textAreaPainter) {
        textAreaPainter.setFont(jEdit.getFontProperty("view.font"));
        textAreaPainter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.structureHighlight"));
        textAreaPainter.setStructureHighlightColor(jEdit.getColorProperty("view.structureHighlightColor"));
        textAreaPainter.setEOLMarkersPainted(jEdit.getBooleanProperty("view.eolMarkers"));
        textAreaPainter.setEOLMarkerColor(jEdit.getColorProperty("view.eolMarkerColor"));
        textAreaPainter.setWrapGuidePainted(jEdit.getBooleanProperty("view.wrapGuide"));
        textAreaPainter.setWrapGuideColor(jEdit.getColorProperty("view.wrapGuideColor"));
        textAreaPainter.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        textAreaPainter.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        textAreaPainter.setMultipleSelectionColor(jEdit.getColorProperty("view.multipleSelectionColor"));
        textAreaPainter.setBackground(jEdit.getColorProperty("view.bgColor"));
        textAreaPainter.setForeground(jEdit.getColorProperty("view.fgColor"));
        textAreaPainter.setBlockCaretEnabled(jEdit.getBooleanProperty("view.blockCaret"));
        textAreaPainter.setThickCaretEnabled(jEdit.getBooleanProperty("view.thickCaret"));
        textAreaPainter.setLineHighlightEnabled(jEdit.getBooleanProperty("view.lineHighlight"));
        textAreaPainter.setLineHighlightColor(jEdit.getColorProperty("view.lineHighlightColor"));
        textAreaPainter.setAntiAlias(new AntiAlias(jEdit.getProperty("view.antiAlias")));
        textAreaPainter.setFractionalFontMetricsEnabled(jEdit.getBooleanProperty("view.fracFontMetrics"));
        String string = jEdit.getProperty("view.font");
        int n = jEdit.getIntegerProperty("view.fontsize", 12);
        textAreaPainter.setStyles(SyntaxUtilities.loadStyles(string, n));
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            syntaxStyleArray[i] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.foldLine." + i), string, n);
        }
        textAreaPainter.setFoldLineStyle(syntaxStyleArray);
    }

    void loadBufferSwitcher() {
        if (jEdit.getBooleanProperty("view.showBufferSwitcher")) {
            if (this.bufferSwitcher == null) {
                this.bufferSwitcher = new BufferSwitcher(this);
                this.add("North", this.bufferSwitcher);
                this.bufferSwitcher.updateBufferList();
                this.revalidate();
            }
        } else if (this.bufferSwitcher != null) {
            this.remove(this.bufferSwitcher);
            this.revalidate();
            this.bufferSwitcher = null;
        }
    }

    private void handleBufferUpdate(BufferUpdate bufferUpdate) {
        Buffer buffer = bufferUpdate.getBuffer();
        if (bufferUpdate.getWhat() == BufferUpdate.CREATED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (this.buffer.isClosed()) {
                this.recentBuffer = null;
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            Buffer buffer2;
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (buffer == this.buffer) {
                Buffer buffer3 = buffer2 = this.recentBuffer != null ? this.recentBuffer : buffer.getPrev();
                if (buffer2 != null && !buffer2.isClosed()) {
                    this.setBuffer(buffer2);
                    this.recentBuffer = buffer2.getPrev();
                }
            } else if (buffer == this.recentBuffer) {
                this.recentBuffer = null;
            }
            buffer2 = bufferUpdate.getBuffer();
            if (buffer2.isUntitled()) {
                this.caretsForPath.remove(buffer2.getPath());
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.LOAD_STARTED) {
            if (buffer == this.buffer) {
                this.textArea.setCaretPosition(0);
                this.textArea.getPainter().repaint();
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.LOADED) {
            if (buffer == this.buffer) {
                this.textArea.repaint();
                if (this.bufferSwitcher != null) {
                    this.bufferSwitcher.updateBufferList();
                }
                if (this.view.getEditPane() == this) {
                    StatusBar statusBar = this.view.getStatus();
                    statusBar.updateCaretStatus();
                    statusBar.updateBufferStatus();
                    statusBar.updateMiscStatus();
                }
                this.loadCaretInfo();
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED) {
            if (buffer == this.buffer && this.bufferSwitcher != null) {
                if (this.buffer.isDirty()) {
                    this.bufferSwitcher.repaint();
                } else {
                    this.bufferSwitcher.updateBufferList();
                }
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            if (buffer == this.buffer) {
                this.textArea.getGutter().repaint();
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.PROPERTIES_CHANGED) {
            if (buffer == this.buffer && this.buffer.isLoaded()) {
                this.textArea.propertiesChanged();
                if (this.view.getEditPane() == this) {
                    this.view.getStatus().updateBufferStatus();
                }
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.SAVED && buffer == this.buffer) {
            this.textArea.propertiesChanged();
        }
    }

    class MarkerHighlight
    extends TextAreaExtension {
        private boolean markerHighlight;
        private Color markerHighlightColor;

        MarkerHighlight() {
        }

        public Color getMarkerHighlightColor() {
            return this.markerHighlightColor;
        }

        public void setMarkerHighlightColor(Color color) {
            this.markerHighlightColor = color;
        }

        public boolean isMarkerHighlightEnabled() {
            return this.markerHighlight;
        }

        public void setMarkerHighlightEnabled(boolean bl) {
            this.markerHighlight = bl;
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            Buffer buffer;
            if (this.isMarkerHighlightEnabled() && (buffer = (Buffer)EditPane.this.textArea.getBuffer()).getMarkerInRange(n3, n4) != null) {
                graphics2D.setColor(this.getMarkerHighlightColor());
                FontMetrics fontMetrics = EditPane.this.textArea.getPainter().getFontMetrics();
                graphics2D.fillRect(0, n5, EditPane.this.textArea.getGutter().getWidth(), fontMetrics.getHeight());
            }
        }

        public String getToolTipText(int n, int n2) {
            if (this.isMarkerHighlightEnabled()) {
                int n3 = EditPane.this.textArea.getPainter().getFontMetrics().getHeight();
                if (n3 == 0) {
                    return null;
                }
                int n4 = n2 / n3;
                int n5 = EditPane.this.textArea.getScreenLineStartOffset(n4);
                int n6 = EditPane.this.textArea.getScreenLineEndOffset(n4);
                if (n5 == -1 || n6 == -1) {
                    return null;
                }
                Buffer buffer = (Buffer)EditPane.this.textArea.getBuffer();
                Marker marker = buffer.getMarkerInRange(n5, n6);
                if (marker != null) {
                    char c = marker.getShortcut();
                    if (c == '\u0000') {
                        return jEdit.getProperty("view.gutter.marker.no-name");
                    }
                    Object[] objectArray = new String[]{String.valueOf(c)};
                    return jEdit.getProperty("view.gutter.marker", objectArray);
                }
            }
            return null;
        }
    }

    class StatusHandler
    implements StatusListener {
        StatusHandler() {
        }

        public void statusChanged(TextArea textArea, int n, boolean bl) {
            StatusBar statusBar = EditPane.this.view.getStatus();
            if (statusBar == null) {
                return;
            }
            switch (n) {
                case 0: {
                    statusBar.setMessageAndClear(jEdit.getProperty("view.status.overwrite-changed", new Integer[]{bl ? 1 : 0}));
                    break;
                }
                case 1: {
                    statusBar.setMessageAndClear(jEdit.getProperty("view.status.multi-changed", new Integer[]{bl ? 1 : 0}));
                    break;
                }
                case 2: {
                    statusBar.setMessageAndClear(jEdit.getProperty("view.status.rect-select-changed", new Integer[]{bl ? 1 : 0}));
                }
            }
            statusBar.updateMiscStatus();
        }

        public void bracketSelected(TextArea textArea, int n, String string) {
            StatusBar statusBar = EditPane.this.view.getStatus();
            if (statusBar == null) {
                return;
            }
            statusBar.setMessageAndClear(jEdit.getProperty("view.status.bracket", new Object[]{n, string}));
        }

        public void narrowActive(TextArea textArea) {
            StatusBar statusBar = EditPane.this.view.getStatus();
            if (statusBar == null) {
                return;
            }
            statusBar.setMessageAndClear(jEdit.getProperty("view.status.narrow"));
        }
    }

    private static class CaretInfo {
        public int caret = -1;
        public Selection[] selection;
        public int scrollVert = -1;
        public int scrollHoriz = -1;
        public boolean rectangularSelection;
        public boolean multipleSelection;

        private CaretInfo() {
        }
    }
}

