/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeListener;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.BufferUndoListener;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.bufferio.BufferAutosaveRequest;
import org.gjt.sp.jedit.bufferio.MarkersSaveRequest;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.jedit.visitors.SaveCaretInfoVisitor;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffer
extends JEditBuffer {
    public static final String BACKED_UP = "Buffer__backedUp";
    public static final String CARET = "Buffer__caret";
    public static final String CARET_POSITIONED = "Buffer__caretPositioned";
    public static final String SELECTION = "Buffer__selection";
    public static final String SCROLL_VERT = "Buffer__scrollVert";
    public static final String SCROLL_HORIZ = "Buffer__scrollHoriz";
    public static final String ENCODING_AUTODETECT = "encodingAutodetect";
    public static final String TRAILING_EOL = "trailingEOL";
    public static final String GZIPPED = "gzipped";
    public static final int FILE_NOT_CHANGED = 0;
    public static final int FILE_CHANGED = 1;
    public static final int FILE_DELETED = 2;
    Buffer prev;
    Buffer next;
    private static final int CLOSED = 0;
    private static final int NEW_FILE = 3;
    private static final int UNTITLED = 4;
    private static final int AUTOSAVE_DIRTY = 5;
    private static final int AUTORELOAD = 6;
    private static final int AUTORELOAD_DIALOG = 7;
    private static final int TEMPORARY = 10;
    private static final int MARKERS_CHANGED = 12;
    private int flags;
    private String path;
    private String symlinkPath;
    private String name;
    private String directory;
    private File file;
    private File autosaveFile;
    private long modTime;
    private byte[] md5hash;
    private int initialLength;
    private final Vector<Marker> markers = new Vector();
    private Socket waitSocket;
    private List<BufferUndoListener> undoListeners;

    public void reload(View view) {
        Object[] objectArray;
        int n;
        if (this.getFlag(4)) {
            return;
        }
        if (this.isDirty() && (n = GUIUtilities.confirm(view, "changedreload", objectArray = new String[]{this.path}, 0, 2)) != 0) {
            return;
        }
        view.visit(new SaveCaretInfoVisitor());
        this.load(view, true);
    }

    public boolean load(final View view, final boolean bl) {
        Object object;
        boolean bl2;
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        this.setLoading(true);
        if (!this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, view, BufferUpdate.LOAD_STARTED));
        }
        if (bl || !this.getFlag(3)) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!bl && this.autosaveFile != null && this.autosaveFile.exists()) {
                bl2 = this.recoverAutosave(view);
            } else {
                if (this.autosaveFile != null) {
                    this.autosaveFile.delete();
                }
                bl2 = false;
            }
            if (!bl2) {
                object = VFSManager.getVFSForPath(this.path);
                if (!this.checkFileForLoad(view, (VFS)object, this.path)) {
                    this.setLoading(false);
                    return false;
                }
                if (!(!bl && this.getFlag(3) || ((VFS)object).load(view, this, this.path))) {
                    this.setLoading(false);
                    return false;
                }
            }
        } else {
            bl2 = false;
        }
        object = new Runnable(){

            public void run() {
                String string = Buffer.this.getStringProperty("BufferIORequest__newPath");
                Segment segment = (Segment)Buffer.this.getProperty("BufferIORequest__loadData");
                IntegerArray integerArray = (IntegerArray)Buffer.this.getProperty("BufferIORequest__endOffsets");
                Buffer.this.loadText(segment, integerArray);
                Buffer.this.unsetProperty("BufferIORequest__loadData");
                Buffer.this.unsetProperty("BufferIORequest__endOffsets");
                Buffer.this.unsetProperty("BufferIORequest__newPath");
                Buffer.this.undoMgr.clear();
                Buffer.this.undoMgr.setLimit(jEdit.getIntegerProperty("buffer.undoCount", 100));
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.finishLoading();
                }
                Buffer.this.setLoading(false);
                if (bl) {
                    Buffer.this.setDirty(false);
                }
                if (!bl2 && string != null) {
                    Buffer.this.setPath(string);
                }
                if (bl2) {
                    Buffer.super.setDirty(true);
                }
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.fireBufferLoaded();
                    EditBus.send(new BufferUpdate(Buffer.this, view, BufferUpdate.LOADED));
                }
            }
        };
        if (this.getFlag(10)) {
            object.run();
        } else {
            VFSManager.runInAWTThread((Runnable)object);
        }
        return true;
    }

    public boolean insertFile(View view, String string) {
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        string = MiscUtilities.constructPath(this.path, string);
        Buffer buffer = jEdit.getBuffer(string);
        if (buffer != null) {
            view.getTextArea().setSelectedText(buffer.getText(0, buffer.getLength()));
            return true;
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        return vFS.insert(view, this, string);
    }

    public void autosave() {
        if (this.autosaveFile == null || !this.getFlag(5) || !this.isDirty() || this.isPerformingIO() || !this.autosaveFile.getParentFile().exists()) {
            return;
        }
        this.setFlag(5, false);
        VFSManager.runInWorkThread(new BufferAutosaveRequest(null, this, null, VFSManager.getFileVFS(), this.autosaveFile.getPath()));
    }

    public boolean saveAs(View view, boolean bl) {
        String[] stringArray = GUIUtilities.showVFSFileDialog(view, this.path, 1, false);
        if (stringArray == null) {
            return false;
        }
        return this.save(view, stringArray[0], bl);
    }

    public boolean save(View view, String string) {
        return this.save(view, string, true, false);
    }

    public boolean save(View view, String string, boolean bl) {
        return this.save(view, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(final View view, String objectArray, boolean bl, boolean bl2) {
        Object object;
        VFS vFS;
        String string;
        String string2;
        Object[] objectArray2;
        block26: {
            boolean bl3;
            block30: {
                boolean bl4;
                block29: {
                    boolean bl5;
                    block28: {
                        boolean bl6;
                        block27: {
                            int n;
                            long l;
                            if (this.isPerformingIO()) {
                                GUIUtilities.error(view, "buffer-multiple-io", null);
                                return false;
                            }
                            this.setBooleanProperty("BufferIORequest__error", false);
                            if (objectArray == null && this.getFlag(3)) {
                                return this.saveAs(view, bl);
                            }
                            if (objectArray == null && this.file != null && (l = this.file.lastModified()) != this.modTime && jEdit.getBooleanProperty("view.checkModStatus") && (n = GUIUtilities.confirm(view, "filechanged-save", objectArray2 = new Object[]{this.path}, 0, 2)) != 0) {
                                return false;
                            }
                            EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVING));
                            this.setPerformingIO(true);
                            string2 = this.path;
                            string = this.symlinkPath;
                            objectArray2 = objectArray == null ? this.path : objectArray;
                            vFS = VFSManager.getVFSForPath((String)objectArray2);
                            if (!Buffer.checkFileForSave(view, vFS, (String)objectArray2)) {
                                this.setPerformingIO(false);
                                return false;
                            }
                            object = vFS.createVFSSession((String)objectArray2, view);
                            if (object == null) {
                                this.setPerformingIO(false);
                                return false;
                            }
                            this.unsetProperty("overwriteReadonly");
                            this.unsetProperty("forbidTwoStageSave");
                            try {
                                try {
                                    boolean bl7;
                                    VFSFile vFSFile = vFS._getFile(object, (String)objectArray2, view);
                                    if (vFSFile == null) break block26;
                                    boolean bl8 = bl7 = (vFS.getCapabilities() & 0x10) != 0;
                                    if (!vFSFile.isWriteable()) {
                                        Log.log(7, this, "Buffer saving : File " + vFSFile + " is readOnly");
                                        if (bl7) {
                                            Log.log(1, this, "Buffer saving : VFS can rename files");
                                            String string3 = vFS._canonPath(object, (String)objectArray2, view);
                                            if (!MiscUtilities.isURL(string3)) {
                                                string3 = MiscUtilities.resolveSymlinks(string3);
                                            }
                                            if ((string3 = vFS.getTwoStageSaveName(string3)) == null) {
                                                Log.log(1, this, "Buffer saving : two stage save impossible because path is null");
                                                VFSManager.error(view, (String)objectArray2, "ioerror.save-readonly-twostagefail", null);
                                                this.setPerformingIO(false);
                                                bl6 = false;
                                                Object var16_23 = null;
                                                break block27;
                                            }
                                            int n2 = GUIUtilities.confirm(view, "vfs.overwrite-readonly", new Object[]{objectArray2}, 0, 2);
                                            if (n2 == 0) {
                                                Log.log(7, this, "Buffer saving : two stage save will be used to save buffer");
                                                this.setBooleanProperty("overwriteReadonly", true);
                                                break block26;
                                            }
                                            Log.log(1, this, "Buffer not saved");
                                            this.setPerformingIO(false);
                                            bl5 = false;
                                            break block28;
                                        }
                                        Log.log(7, this, "Buffer saving : file is readonly and vfs cannot do two stage save");
                                        VFSManager.error(view, (String)objectArray2, "ioerror.write-error-readonly", null);
                                        this.setPerformingIO(false);
                                        bl4 = false;
                                        break block29;
                                    }
                                    String string4 = vFS._canonPath(object, (String)objectArray2, view);
                                    if (!MiscUtilities.isURL(string4)) {
                                        string4 = MiscUtilities.resolveSymlinks(string4);
                                    }
                                    string4 = vFS.getTwoStageSaveName(string4);
                                    if (!jEdit.getBooleanProperty("twoStageSave") || bl7 && string4 != null) break block26;
                                    int n3 = GUIUtilities.confirm(view, "vfs.twostageimpossible", new Object[]{objectArray2}, 0, 2);
                                    if (n3 == 0) {
                                        Log.log(7, this, "Buffer saving : two stage save cannot be used");
                                        this.setBooleanProperty("forbidTwoStageSave", true);
                                        break block26;
                                    }
                                    Log.log(1, this, "Buffer not saved");
                                    this.setPerformingIO(false);
                                    bl3 = false;
                                    break block30;
                                }
                                catch (IOException iOException) {
                                    VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
                                    this.setPerformingIO(false);
                                    boolean bl9 = false;
                                    Object var16_28 = null;
                                    try {
                                        vFS._endVFSSession(object, view);
                                        return bl9;
                                    }
                                    catch (IOException iOException2) {
                                        VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException2.toString()});
                                        this.setPerformingIO(false);
                                        return false;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var16_29 = null;
                                try {}
                                catch (IOException iOException) {
                                    VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
                                    this.setPerformingIO(false);
                                    return false;
                                }
                                vFS._endVFSSession(object, view);
                                throw throwable;
                            }
                        }
                        try {}
                        catch (IOException iOException) {
                            VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
                            this.setPerformingIO(false);
                            return false;
                        }
                        vFS._endVFSSession(object, view);
                        return bl6;
                    }
                    Object var16_24 = null;
                    try {}
                    catch (IOException iOException) {
                        VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
                        this.setPerformingIO(false);
                        return false;
                    }
                    vFS._endVFSSession(object, view);
                    return bl5;
                }
                Object var16_25 = null;
                try {}
                catch (IOException iOException) {
                    VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
                    this.setPerformingIO(false);
                    return false;
                }
                vFS._endVFSSession(object, view);
                return bl4;
            }
            Object var16_26 = null;
            try {}
            catch (IOException iOException) {
                VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
                this.setPerformingIO(false);
                return false;
            }
            vFS._endVFSSession(object, view);
            return bl3;
        }
        Object var16_27 = null;
        try {}
        catch (IOException iOException) {
            VFSManager.error(view, (String)objectArray2, "ioerror", new String[]{iOException.toString()});
            this.setPerformingIO(false);
            return false;
        }
        vFS._endVFSSession(object, view);
        if (!vFS.save(view, this, (String)objectArray2)) {
            this.setPerformingIO(false);
            return false;
        }
        VFSManager.runInAWTThread(new Runnable((String)objectArray2, bl){
            final /* synthetic */ String val$newPath;
            final /* synthetic */ boolean val$rename;
            {
                this.val$newPath = string3;
                this.val$rename = bl;
            }

            public void run() {
                Buffer.this.setPerformingIO(false);
                Buffer.this.setProperty("overwriteReadonly", null);
                Buffer.this.finishSaving(view, string2, string, this.val$newPath, this.val$rename, Buffer.this.getBooleanProperty("BufferIORequest__error"));
                Buffer.this.updateMarkersFile(view);
            }
        });
        int n = jEdit.getIntegerProperty("checkFileStatus");
        if (bl2) return true;
        if (n != 1) {
            if (n != 2) return true;
        }
        jEdit.checkBufferStatus(view, false);
        return true;
    }

    public int checkFileStatus(View view) {
        if (!this.isPerformingIO() && this.file != null && !this.getFlag(3)) {
            boolean bl;
            boolean bl2 = bl = this.file.exists() && !this.file.canWrite();
            if (bl != this.isFileReadOnly()) {
                this.setFileReadOnly(bl);
                EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
            }
            long l = this.modTime;
            long l2 = this.file.lastModified();
            if (l2 != l) {
                this.modTime = l2;
                if (!this.file.exists()) {
                    this.setFlag(3, true);
                    this.setDirty(true);
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    public long getLastModified() {
        return this.modTime;
    }

    public void setLastModified(long l) {
        this.modTime = l;
    }

    public boolean getAutoReload() {
        return this.getFlag(6);
    }

    public void setAutoReload(boolean bl) {
        this.setFlag(6, bl);
    }

    public boolean getAutoReloadDialog() {
        return this.getFlag(7);
    }

    public void setAutoReloadDialog(boolean bl) {
        this.setFlag(7, bl);
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public File getAutosaveFile() {
        return this.autosaveFile;
    }

    public void removeAutosaveFile() {
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
            this.setFlag(5, true);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(Boolean bl) {
        return bl != false ? MiscUtilities.abbreviate(this.path) : this.getPath();
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isClosed() {
        return this.getFlag(0);
    }

    public boolean isLoaded() {
        return !this.isLoading();
    }

    public boolean isNewFile() {
        return this.getFlag(3);
    }

    public void setNewFile(boolean bl) {
        this.setFlag(3, bl);
        if (!bl) {
            this.setFlag(4, false);
        }
    }

    public boolean isUntitled() {
        return this.getFlag(4);
    }

    @Override
    public void setDirty(boolean bl) {
        boolean bl2 = this.isDirty();
        if (this.isUntitled() && jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled")) {
            bl = false;
        }
        if (bl && this.getLength() == this.initialLength && jEdit.getBooleanProperty("useMD5forDirtyCalculation")) {
            bl = !Arrays.equals(this.calculateHash(), this.md5hash);
        }
        super.setDirty(bl);
        boolean bl3 = this.isEditable();
        if (bl) {
            if (bl3) {
                this.setFlag(5, true);
            }
        } else {
            this.setFlag(5, false);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
        }
        if (bl != bl2 && bl3) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isTemporary() {
        return this.getFlag(10);
    }

    public Icon getIcon() {
        if (this.isDirty()) {
            return GUIUtilities.loadIcon("dirty.gif");
        }
        if (this.isReadOnly()) {
            return GUIUtilities.loadIcon("readonly.gif");
        }
        if (this.getFlag(3)) {
            return GUIUtilities.loadIcon("new.gif");
        }
        return GUIUtilities.loadIcon("normal.gif");
    }

    @Deprecated
    public void addBufferChangeListener(BufferChangeListener bufferChangeListener, int n) {
        this.addBufferListener(new BufferChangeListener.Adapter(bufferChangeListener), n);
    }

    @Deprecated
    public void addBufferChangeListener(BufferChangeListener bufferChangeListener) {
        this.addBufferListener(new BufferChangeListener.Adapter(bufferChangeListener), 0);
    }

    @Deprecated
    public void removeBufferChangeListener(BufferChangeListener bufferChangeListener) {
        BufferListener[] bufferListenerArray = this.getBufferListeners();
        for (int i = 0; i < bufferListenerArray.length; ++i) {
            BufferListener bufferListener = bufferListenerArray[i];
            if (!(bufferListener instanceof BufferChangeListener.Adapter) || ((BufferChangeListener.Adapter)bufferListener).getDelegate() != bufferChangeListener) continue;
            this.removeBufferListener(bufferListener);
            return;
        }
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        this.setAutoReloadDialog(jEdit.getBooleanProperty("autoReloadDialog"));
        this.setAutoReload(jEdit.getBooleanProperty("autoReload"));
        if (!this.isTemporary()) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.PROPERTIES_CHANGED));
        }
    }

    @Override
    public Object getDefaultProperty(String string) {
        Object object;
        if (this.mode != null) {
            Object object2 = this.mode.getProperty(string);
            if (object2 == null) {
                return null;
            }
            this.setDefaultProperty(string, object2);
            return object2;
        }
        String string2 = jEdit.getProperty("buffer." + string);
        if (string2 == null) {
            return null;
        }
        try {
            object = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            object = string2;
        }
        return object;
    }

    public void toggleWordWrap(View view) {
        String string = this.getStringProperty("wrap");
        if (string.equals("none")) {
            string = "soft";
        } else if (string.equals("soft")) {
            string = "hard";
        } else if (string.equals("hard")) {
            string = "none";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.wrap-changed", new String[]{string}));
        this.setProperty("wrap", string);
        this.propertiesChanged();
    }

    public void toggleLineSeparator(View view) {
        String string = null;
        String string2 = this.getStringProperty("lineSeparator");
        if ("\n".equals(string2)) {
            string = "windows";
            string2 = "\r\n";
        } else if ("\r\n".equals(string2)) {
            string = "mac";
            string2 = "\r";
        } else if ("\r".equals(string2)) {
            string = "unix";
            string2 = "\n";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.linesep-changed", new String[]{jEdit.getProperty("lineSep." + string)}));
        this.setProperty("lineSeparator", string2);
        this.setDirty(true);
        this.propertiesChanged();
    }

    @Override
    public String getContextSensitiveProperty(int n, String string) {
        ParserRuleSet parserRuleSet;
        Object object = super.getContextSensitiveProperty(n, string);
        if (object == null && (object = jEdit.getMode((parserRuleSet = this.getRuleSetAtOffset(n)).getModeName()).getProperty(string)) == null) {
            object = this.mode.getProperty(string);
        }
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public void setMode() {
        Mode mode;
        Object object;
        String string = this.getStringProperty("mode");
        if (string != null) {
            this.unsetProperty("mode");
            object = ModeProvider.instance.getMode(string);
            if (object != null) {
                this.setMode((Mode)object);
                return;
            }
        }
        if ((mode = ModeProvider.instance.getModeForFile(this.name, (String)(object = this.getLineText(0)))) != null) {
            this.setMode(mode);
            return;
        }
        Mode mode2 = jEdit.getMode(jEdit.getProperty("buffer.defaultMode"));
        if (mode2 == null) {
            mode2 = jEdit.getMode("text");
        }
        if (mode2 != null) {
            this.setMode(mode2);
        }
    }

    @Deprecated
    public void putProperty(Object object, Object object2) {
        if (!(object instanceof String)) {
            return;
        }
        this.setProperty((String)object, object2);
    }

    @Deprecated
    public void putBooleanProperty(String string, boolean bl) {
        this.setBooleanProperty(string, bl);
    }

    @Deprecated
    public TokenList markTokens(int n) {
        TokenList tokenList = new TokenList();
        this.markTokens(n, tokenList);
        return tokenList;
    }

    @Deprecated
    public void insertString(int n, String string, AttributeSet attributeSet) {
        this.insert(n, string);
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    public Vector<Marker> getMarkers() {
        return this.markers;
    }

    public String getMarkerStatusPrompt(String string) {
        return jEdit.getProperty("view.status." + string, new String[]{this.getMarkerNameString()});
    }

    public String getMarkerNameString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (marker.getShortcut() == '\u0000') continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(marker.getShortcut());
        }
        if (stringBuilder.length() == 0) {
            return jEdit.getProperty("view.status.no-markers");
        }
        return stringBuilder.toString();
    }

    public void addOrRemoveMarker(char c, int n) {
        int n2 = this.getLineOfOffset(n);
        if (this.getMarkerAtLine(n2) != null) {
            this.removeMarker(n2);
        } else {
            this.addMarker(c, n);
        }
    }

    public void addMarker(char c, int n) {
        Marker marker = new Marker(this, c, n);
        boolean bl = false;
        if (this.isLoaded()) {
            Marker marker2;
            int n2;
            this.setFlag(12, true);
            marker.createPosition();
            for (n2 = 0; n2 < this.markers.size(); ++n2) {
                marker2 = this.markers.get(n2);
                if (c != '\u0000' && marker2.getShortcut() == c) {
                    marker2.setShortcut('\u0000');
                }
                if (marker2.getPosition() != n) continue;
                this.markers.removeElementAt(n2);
                --n2;
            }
            for (n2 = 0; n2 < this.markers.size(); ++n2) {
                marker2 = this.markers.get(n2);
                if (marker2.getPosition() <= n) continue;
                this.markers.insertElementAt(marker, n2);
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.markers.addElement(marker);
        }
        if (this.isLoaded() && !this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarkerInRange(int n, int n2) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            int n3 = marker.getPosition();
            if (n3 < n || n3 >= n2) continue;
            return marker;
        }
        return null;
    }

    public Marker getMarkerAtLine(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (this.getLineOfOffset(marker.getPosition()) != n) continue;
            return marker;
        }
        return null;
    }

    public void removeMarker(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (this.getLineOfOffset(marker.getPosition()) != n) continue;
            this.setFlag(12, true);
            marker.removePosition();
            this.markers.removeElementAt(i);
            --i;
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
    }

    public void removeAllMarkers() {
        this.setFlag(12, true);
        for (int i = 0; i < this.markers.size(); ++i) {
            this.markers.get(i).removePosition();
        }
        this.markers.removeAllElements();
        if (this.isLoaded()) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarker(char c) {
        for (Marker marker : this.markers) {
            if (marker.getShortcut() != c) continue;
            return marker;
        }
        return null;
    }

    @Deprecated
    public String getMarkersPath(VFS vFS) {
        return Buffer.getMarkersPath(vFS, this.path);
    }

    public static String getMarkersPath(VFS vFS, String string) {
        return vFS.getParentOfPath(string) + '.' + vFS.getFileName(string) + ".marks";
    }

    public boolean updateMarkersFile(View view) {
        if (!this.markersChanged()) {
            return true;
        }
        VFS vFS = VFSManager.getVFSForPath(this.getPath());
        if ((vFS.getCapabilities() & 2) == 0 || !vFS.isMarkersFileSupported()) {
            VFSManager.error(view, this.path, "vfs.not-supported.save", new String[]{"markers file"});
            return false;
        }
        Object object = vFS.createVFSSession(this.path, view);
        if (object == null) {
            return false;
        }
        VFSManager.runInWorkThread(new MarkersSaveRequest(view, this, object, vFS, this.path));
        return true;
    }

    public boolean markersChanged() {
        return this.getFlag(12);
    }

    public void setMarkersChanged(boolean bl) {
        this.setFlag(12, bl);
    }

    public void setWaitSocket(Socket socket) {
        this.waitSocket = socket;
    }

    public Buffer getNext() {
        return this.next;
    }

    public Buffer getPrev() {
        return this.prev;
    }

    public int getIndex() {
        int n = 0;
        Buffer buffer = this.prev;
        while (buffer != null) {
            ++n;
            buffer = buffer.prev;
        }
        return n;
    }

    public String toString() {
        return this.name + " (" + MiscUtilities.abbreviate(this.directory) + ')';
    }

    public void addBufferUndoListener(BufferUndoListener bufferUndoListener) {
        this.undoListeners.add(bufferUndoListener);
    }

    public void removeBufferUndoListener(BufferUndoListener bufferUndoListener) {
        this.undoListeners.remove(bufferUndoListener);
    }

    Buffer(String string, boolean bl, boolean bl2, Map map) {
        super(map);
        this.setFlag(10, bl2);
        this.setPath(string);
        this.setFlag(4, bl);
        this.setFlag(3, bl);
        this.setFlag(6, jEdit.getBooleanProperty("autoReload"));
        this.setFlag(7, jEdit.getBooleanProperty("autoReloadDialog"));
        this.undoListeners = new Vector<BufferUndoListener>();
    }

    void commitTemporary() {
        this.setFlag(10, false);
        this.finishLoading();
    }

    void close() {
        this.setFlag(0, true);
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
        }
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void fireBeginUndo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.beginUndo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer undo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    @Override
    protected void fireEndUndo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.endUndo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer undo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    @Override
    protected void fireBeginRedo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.beginRedo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer begin redo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    @Override
    protected void fireEndRedo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.endRedo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer end redo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    private void setPath(final String string) {
        jEdit.visit(new JEditVisitorAdapter(){

            public void visit(EditPane editPane) {
                editPane.bufferRenamed(Buffer.this.path, string);
            }
        });
        this.path = string;
        VFS vFS = VFSManager.getVFSForPath(string);
        if ((vFS.getCapabilities() & 2) == 0) {
            this.setFileReadOnly(true);
        }
        this.name = vFS.getFileName(string);
        this.directory = vFS.getParentOfPath(string);
        if (vFS instanceof FileVFS) {
            this.file = new File(string);
            this.symlinkPath = MiscUtilities.resolveSymlinks(string);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            this.autosaveFile = new File(this.file.getParent(), '#' + this.name + '#');
        } else {
            this.file = null;
            this.autosaveFile = null;
            this.symlinkPath = string;
        }
    }

    private boolean recoverAutosave(final View view) {
        if (!this.autosaveFile.canRead()) {
            return false;
        }
        GUIUtilities.hideSplashScreen();
        final Object[] objectArray = new Object[]{this.autosaveFile.getPath()};
        int n = GUIUtilities.confirm(view, "autosave-found", objectArray, 0, 2);
        if (n == 0) {
            VFSManager.getFileVFS().load(view, this, this.autosaveFile.getPath());
            VFSManager.runInAWTThread(new Runnable(){

                public void run() {
                    GUIUtilities.message(view, "autosave-loaded", objectArray);
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileForLoad(View view, VFS vFS, String string) {
        Object object;
        block16: {
            boolean bl;
            block17: {
                boolean bl2;
                block15: {
                    boolean bl3;
                    block14: {
                        if ((vFS.getCapabilities() & 0x40) == 0) return true;
                        object = vFS.createVFSSession(string, view);
                        if (object == null) {
                            return false;
                        }
                        try {
                            try {
                                VFSFile vFSFile = vFS._getFile(object, string, view);
                                if (vFSFile == null) {
                                    this.setNewFile(true);
                                    bl3 = true;
                                    Object var8_11 = null;
                                    break block14;
                                }
                                if (!vFSFile.isReadable()) {
                                    VFSManager.error(view, string, "ioerror.no-read", null);
                                    this.setNewFile(false);
                                    bl2 = false;
                                    break block15;
                                }
                                this.setFileReadOnly(!vFSFile.isWriteable());
                                if (vFSFile.getType() == 0) break block16;
                                VFSManager.error(view, string, "ioerror.open-directory", null);
                                this.setNewFile(false);
                                bl = false;
                                break block17;
                            }
                            catch (IOException iOException) {
                                VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                                boolean bl4 = false;
                                Object var8_15 = null;
                                try {
                                    vFS._endVFSSession(object, view);
                                    return bl4;
                                }
                                catch (IOException iOException2) {
                                    VFSManager.error(view, string, "ioerror", new String[]{iOException2.toString()});
                                    return false;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            try {}
                            catch (IOException iOException) {
                                VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                                return false;
                            }
                            vFS._endVFSSession(object, view);
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {
                        VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                        return false;
                    }
                    vFS._endVFSSession(object, view);
                    return bl3;
                }
                Object var8_12 = null;
                try {}
                catch (IOException iOException) {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                    return false;
                }
                vFS._endVFSSession(object, view);
                return bl2;
            }
            Object var8_13 = null;
            try {}
            catch (IOException iOException) {
                VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                return false;
            }
            vFS._endVFSSession(object, view);
            return bl;
        }
        Object var8_14 = null;
        try {}
        catch (IOException iOException) {
            VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
            return false;
        }
        vFS._endVFSSession(object, view);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkFileForSave(View view, VFS vFS, String string) {
        Object object;
        block13: {
            boolean bl;
            block14: {
                boolean bl2;
                block12: {
                    if ((vFS.getCapabilities() & 0x40) == 0) return true;
                    object = vFS.createVFSSession(string, view);
                    if (object == null) {
                        return false;
                    }
                    try {
                        try {
                            VFSFile vFSFile = vFS._getFile(object, string, view);
                            if (vFSFile == null) {
                                bl2 = true;
                                Object var7_9 = null;
                                break block12;
                            }
                            if (vFSFile.getType() == 0) break block13;
                            VFSManager.error(view, string, "ioerror.save-directory", null);
                            bl = false;
                            break block14;
                        }
                        catch (IOException iOException) {
                            VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                            boolean bl3 = false;
                            Object var7_12 = null;
                            try {
                                vFS._endVFSSession(object, view);
                                return bl3;
                            }
                            catch (IOException iOException2) {
                                VFSManager.error(view, string, "ioerror", new String[]{iOException2.toString()});
                                return false;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        try {}
                        catch (IOException iOException) {
                            VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                            return false;
                        }
                        vFS._endVFSSession(object, view);
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                    return false;
                }
                vFS._endVFSSession(object, view);
                return bl2;
            }
            Object var7_10 = null;
            try {}
            catch (IOException iOException) {
                VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                return false;
            }
            vFS._endVFSSession(object, view);
            return bl;
        }
        Object var7_11 = null;
        try {}
        catch (IOException iOException) {
            VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
            return false;
        }
        vFS._endVFSSession(object, view);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateHash() {
        byte[] byArray = new byte[1];
        if (!jEdit.getBooleanProperty("useMD5forDirtyCalculation")) {
            return byArray;
        }
        ByteBuffer byteBuffer = null;
        this.readLock();
        try {
            int n = this.getLength();
            byteBuffer = ByteBuffer.allocate(n * 2);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            charBuffer.append(this.getSegment(0, n));
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.readUnlock();
            throw throwable;
        }
        this.readUnlock();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byteBuffer);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.log(9, this, "Can't Calculate MD5 hash!", noSuchAlgorithmException);
            return byArray;
        }
    }

    private void updateHash() {
        this.initialLength = this.getLength();
        this.md5hash = this.calculateHash();
    }

    private void finishLoading() {
        this.updateHash();
        this.parseBufferLocalProperties();
        FoldHandler foldHandler = this.getFoldHandler();
        this.setMode();
        if (this.getFoldHandler() == foldHandler) {
            this.invalidateFoldLevels();
            this.fireFoldHandlerChanged();
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            marker.removePosition();
            int n = marker.getPosition();
            if (n > this.getLength()) {
                marker.setPosition(this.getLength());
            } else if (n < 0) {
                marker.setPosition(0);
            }
            marker.createPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSaving(View view, String string, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        if (!bl2 && !string3.equals(string)) {
            object = jEdit.getBuffer(string3);
            if (bl) {
                if (object != null && !((Buffer)object).getPath().equals(string)) {
                    ((Buffer)object).setDirty(false);
                    jEdit.closeBuffer(view, (Buffer)object);
                }
                this.setPath(string3);
                final HashSet hashSet = new HashSet();
                final HashSet hashSet2 = new HashSet();
                jEdit.visit(new JEditVisitorAdapter(){

                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        if (bufferSet.indexOf(Buffer.this) != -1) {
                            hashSet.add(bufferSet);
                            if (editPane.getBuffer() == Buffer.this) {
                                hashSet2.add(editPane);
                            }
                        }
                    }
                });
                jEdit.getBufferSetManager().removeBuffer(this);
                for (Object object2 : hashSet) {
                    jEdit.getBufferSetManager().addBuffer((BufferSet)object2, this);
                }
                for (Object object2 : hashSet2) {
                    ((EditPane)object2).setBuffer(this);
                }
            } else if (object != null && !((Buffer)object).getPath().equals(string)) {
                ((Buffer)object).load(view, true);
            }
        }
        if (bl) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!bl2) {
                try {
                    this.writeLock();
                    if (this.autosaveFile != null) {
                        this.autosaveFile.delete();
                    }
                    this.setFlag(5, false);
                    this.setFileReadOnly(false);
                    this.setFlag(3, false);
                    this.setFlag(4, false);
                    super.setDirty(false);
                    if (jEdit.getBooleanProperty("resetUndoOnSave")) {
                        this.undoMgr.clear();
                    }
                    Object var13_12 = null;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.writeUnlock();
                    throw throwable;
                }
                this.writeUnlock();
                this.parseBufferLocalProperties();
                if (!this.getPath().equals(string)) {
                    if (!this.isTemporary()) {
                        jEdit.updatePosition(string2, this);
                    }
                    this.setMode();
                } else {
                    object = this.getStringProperty("mode");
                    if (object != null && !((String)object).equals(this.getMode().getName())) {
                        this.setMode();
                    } else {
                        this.propertiesChanged();
                    }
                }
                this.updateHash();
                if (!this.isTemporary()) {
                    EditBus.send(new BufferUpdate(this, view, BufferUpdate.DIRTY_CHANGED));
                    EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVED));
                }
            }
        }
    }

    public void editSyntaxStyle(JEditTextArea jEditTextArea) {
        int n = jEditTextArea.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = jEditTextArea.getCaretPosition();
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        this.markTokens(n, defaultTokenHandler);
        Token token = defaultTokenHandler.getTokens();
        while (token.id != 127) {
            int n4 = n2 + token.length;
            if (n2 <= n3 && n4 > n3) break;
            n2 = n4;
            token = token.next;
        }
        if (token.id == 127 || token.id == 0) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("syntax-style-no-token.message"), jEdit.getProperty("syntax-style-no-token.title"), -1);
            return;
        }
        String string = Token.tokenToString(token.id);
        String string2 = "view.style." + string.toLowerCase();
        SyntaxStyle syntaxStyle = GUIUtilities.parseStyle(jEdit.getProperty(string2), "Dialog", 12);
        SyntaxStyle syntaxStyle2 = new StyleEditor(jEdit.getActiveView(), syntaxStyle, string).getStyle();
        if (syntaxStyle2 != null) {
            jEdit.setProperty(string2, GUIUtilities.getStyleString(syntaxStyle2));
            jEdit.propertiesChanged();
        }
    }

    @Deprecated
    public static class TokenList
    extends DefaultTokenHandler {
        public Token getFirstToken() {
            return this.getTokens();
        }
    }
}

